/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.ManagedReferenceInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceLifecycleMethodInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceMethodInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceReleaseInterceptorFactory;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.TCCLInterceptor;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ConstructedValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class ComponentDescription {
    private static final DefaultFirstConfigurator FIRST_CONFIGURATOR = new DefaultFirstConfigurator();
    private static final AtomicInteger PROXY_ID = new AtomicInteger(0);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final ServiceName serviceName;
    private final String componentName;
    private final String componentClassName;
    private final EEApplicationClasses applicationClassesDescription;
    private final EEModuleDescription moduleDescription;
    private final EEModuleClassDescription classDescription;
    private List<InterceptorDescription> classInterceptors = new ArrayList<InterceptorDescription>();
    private List<InterceptorDescription> defaultInterceptors = new ArrayList<InterceptorDescription>();
    private final Map<MethodIdentifier, List<InterceptorDescription>> methodInterceptors = new HashMap<MethodIdentifier, List<InterceptorDescription>>();
    private final Map<MethodIdentifier, Set<String>> methodInterceptorsSet = new HashMap<MethodIdentifier, Set<String>>();
    private final Set<MethodIdentifier> methodExcludeDefaultInterceptors = new HashSet<MethodIdentifier>();
    private final Set<MethodIdentifier> methodExcludeClassInterceptors = new HashSet<MethodIdentifier>();
    private final Map<ServiceName, ServiceBuilder.DependencyType> dependencies = new HashMap<ServiceName, ServiceBuilder.DependencyType>();
    private Set<InterceptorDescription> allInterceptors;
    private ComponentNamingMode namingMode = ComponentNamingMode.USE_MODULE;
    private boolean excludeDefaultInterceptors = false;
    private DeploymentDescriptorEnvironment deploymentDescriptorEnvironment;
    private final Set<ViewDescription> views = new HashSet<ViewDescription>();
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final Deque<ComponentConfigurator> configurators = new ArrayDeque<ComponentConfigurator>();
    private String beanDeploymentArchiveId;

    public ComponentDescription(String componentName, String componentClassName, EEModuleDescription moduleDescription, EEModuleClassDescription classDescription, ServiceName deploymentUnitServiceName, EEApplicationClasses applicationClassesDescription) {
        this.moduleDescription = moduleDescription;
        this.classDescription = classDescription;
        this.applicationClassesDescription = applicationClassesDescription;
        if (componentName == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (componentClassName == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (moduleDescription == null) {
            throw new IllegalArgumentException("moduleName is null");
        }
        if (classDescription == null) {
            throw new IllegalArgumentException("classDescription is null");
        }
        if (deploymentUnitServiceName == null) {
            throw new IllegalArgumentException("deploymentUnitServiceName is null");
        }
        this.serviceName = deploymentUnitServiceName.append(new String[]{"component"}).append(new String[]{componentName});
        this.componentName = componentName;
        this.componentClassName = componentClassName;
        this.configurators.addLast(FIRST_CONFIGURATOR);
    }

    public ComponentConfiguration createConfiguration(EEApplicationDescription applicationDescription) {
        return new ComponentConfiguration(this, applicationDescription.getClassConfiguration(this.getComponentClassName()));
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public String getModuleName() {
        return this.moduleDescription.getModuleName();
    }

    public String getApplicationName() {
        return this.moduleDescription.getApplicationName();
    }

    public List<InterceptorDescription> getClassInterceptors() {
        return this.classInterceptors;
    }

    public void setClassInterceptors(List<InterceptorDescription> classInterceptors) {
        for (InterceptorDescription clazz : classInterceptors) {
            this.applicationClassesDescription.getOrAddClassByName(clazz.getInterceptorClassName());
        }
        this.classInterceptors = classInterceptors;
        this.allInterceptors = null;
    }

    public List<InterceptorDescription> getDefaultInterceptors() {
        return this.defaultInterceptors;
    }

    public void setDefaultInterceptors(List<InterceptorDescription> defaultInterceptors) {
        this.allInterceptors = null;
        this.defaultInterceptors = defaultInterceptors;
    }

    public Set<InterceptorDescription> getAllInterceptors() {
        if (this.allInterceptors == null) {
            this.allInterceptors = new HashSet<InterceptorDescription>();
            this.allInterceptors.addAll(this.classInterceptors);
            if (!this.excludeDefaultInterceptors) {
                this.allInterceptors.addAll(this.defaultInterceptors);
            }
            for (List<InterceptorDescription> interceptors : this.methodInterceptors.values()) {
                this.allInterceptors.addAll(interceptors);
            }
        }
        return this.allInterceptors;
    }

    public boolean isExcludeDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors) {
        this.allInterceptors = null;
        this.excludeDefaultInterceptors = excludeDefaultInterceptors;
    }

    public void excludeDefaultInterceptors(MethodIdentifier method) {
        this.methodExcludeDefaultInterceptors.add(method);
    }

    public boolean isExcludeDefaultInterceptors(MethodIdentifier method) {
        return this.methodExcludeDefaultInterceptors.contains(method);
    }

    public void excludeClassInterceptors(MethodIdentifier method) {
        this.methodExcludeClassInterceptors.add(method);
    }

    public boolean isExcludeClassInterceptors(MethodIdentifier method) {
        return this.methodExcludeClassInterceptors.contains(method);
    }

    public boolean addClassInterceptor(InterceptorDescription description) {
        String name = description.getInterceptorClassName();
        this.applicationClassesDescription.getOrAddClassByName(name);
        if (this.classInterceptors.contains(description)) {
            return false;
        }
        this.classInterceptors.add(description);
        this.allInterceptors = null;
        return true;
    }

    public InterceptorDescription getClassInterceptor(String interceptorClassName) {
        for (InterceptorDescription interceptor : this.classInterceptors) {
            if (!interceptor.getInterceptorClassName().equals(interceptorClassName)) continue;
            return interceptor;
        }
        return null;
    }

    public Map<MethodIdentifier, List<InterceptorDescription>> getMethodInterceptors() {
        return this.methodInterceptors;
    }

    public boolean addMethodInterceptor(MethodIdentifier method, InterceptorDescription description) {
        List<InterceptorDescription> interceptors = this.methodInterceptors.get(method);
        Set<String> interceptorClasses = this.methodInterceptorsSet.get(method);
        if (interceptors == null) {
            interceptors = new ArrayList<InterceptorDescription>();
            this.methodInterceptors.put(method, interceptors);
            interceptorClasses = new HashSet<String>();
            this.methodInterceptorsSet.put(method, interceptorClasses);
        }
        String name = description.getInterceptorClassName();
        this.applicationClassesDescription.getOrAddClassByName(name);
        if (interceptorClasses.contains(name)) {
            return false;
        }
        interceptors.add(description);
        interceptorClasses.add(name);
        this.allInterceptors = null;
        return true;
    }

    public void setMethodInterceptors(MethodIdentifier identifier, List<InterceptorDescription> interceptorDescriptions) {
        this.methodInterceptors.put(identifier, interceptorDescriptions);
        this.methodExcludeClassInterceptors.add(identifier);
        this.methodExcludeDefaultInterceptors.add(identifier);
    }

    public ComponentNamingMode getNamingMode() {
        return this.namingMode;
    }

    public void setNamingMode(ComponentNamingMode namingMode) {
        if (namingMode == null) {
            throw new IllegalArgumentException("namingMode is null");
        }
        this.namingMode = namingMode;
    }

    public EEModuleDescription getModuleDescription() {
        return this.moduleDescription;
    }

    public EEModuleClassDescription getClassDescription() {
        return this.classDescription;
    }

    public void addDependency(ServiceName serviceName, ServiceBuilder.DependencyType type) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        Map<ServiceName, ServiceBuilder.DependencyType> dependencies = this.dependencies;
        ServiceBuilder.DependencyType dependencyType = dependencies.get(serviceName);
        if (dependencyType == ServiceBuilder.DependencyType.REQUIRED) {
            dependencies.put(serviceName, ServiceBuilder.DependencyType.REQUIRED);
        } else {
            dependencies.put(serviceName, type);
        }
    }

    public Map<ServiceName, ServiceBuilder.DependencyType> getDependencies() {
        return this.dependencies;
    }

    public DeploymentDescriptorEnvironment getDeploymentDescriptorEnvironment() {
        return this.deploymentDescriptorEnvironment;
    }

    public void setDeploymentDescriptorEnvironment(DeploymentDescriptorEnvironment deploymentDescriptorEnvironment) {
        this.deploymentDescriptorEnvironment = deploymentDescriptorEnvironment;
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    public Set<ViewDescription> getViews() {
        return this.views;
    }

    public Deque<ComponentConfigurator> getConfigurators() {
        return this.configurators;
    }

    private static InterceptorFactory weaved(final Collection<InterceptorFactory> interceptorFactories) {
        return new InterceptorFactory(){

            public Interceptor create(InterceptorFactoryContext context) {
                Interceptor[] interceptors = new Interceptor[interceptorFactories.size()];
                Iterator factories = interceptorFactories.iterator();
                for (int i = 0; i < interceptors.length; ++i) {
                    interceptors[i] = ((InterceptorFactory)factories.next()).create(context);
                }
                return Interceptors.getWeavedInterceptor((Interceptor[])interceptors);
            }
        };
    }

    public String getBeanDeploymentArchiveId() {
        return this.beanDeploymentArchiveId;
    }

    public void setBeanDeploymentArchiveId(String beanDeploymentArchiveId) {
        this.beanDeploymentArchiveId = beanDeploymentArchiveId;
    }

    static class InjectedConfigurator
    implements DependencyConfigurator {
        private final ResourceInjectionConfiguration injectionConfiguration;
        private final ComponentConfiguration configuration;
        private final DeploymentPhaseContext context;
        private final InjectedValue<ManagedReferenceFactory> managedReferenceFactoryValue;

        InjectedConfigurator(ResourceInjectionConfiguration injectionConfiguration, ComponentConfiguration configuration, DeploymentPhaseContext context, InjectedValue<ManagedReferenceFactory> managedReferenceFactoryValue) {
            this.injectionConfiguration = injectionConfiguration;
            this.configuration = configuration;
            this.context = context;
            this.managedReferenceFactoryValue = managedReferenceFactoryValue;
        }

        @Override
        public void configureDependency(ServiceBuilder<?> serviceBuilder) throws DeploymentUnitProcessingException {
            InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(this.configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.USE_MODULE, this.configuration.getComponentName(), this.configuration.getModuleName(), this.configuration.getApplicationName());
            this.injectionConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, this.context, (Injector<ManagedReferenceFactory>)this.managedReferenceFactoryValue);
        }
    }

    private static class DefaultFirstConfigurator
    implements ComponentConfigurator {
        private DefaultFirstConfigurator() {
        }

        @Override
        public void configure(final DeploymentPhaseContext context, final ComponentDescription description, final ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            final DeploymentUnit deploymentUnit = context.getDeploymentUnit();
            final DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
            final Object instanceKey = BasicComponentInstance.INSTANCE_KEY;
            Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
            EEModuleClassConfiguration componentClassConfiguration = configuration.getModuleClassConfiguration();
            ArrayDeque<ManagedReferenceInterceptorFactory> instantiators = new ArrayDeque<ManagedReferenceInterceptorFactory>();
            final ArrayDeque injectors = new ArrayDeque();
            final ArrayDeque uninjectors = new ArrayDeque();
            ArrayDeque<ManagedReferenceReleaseInterceptorFactory> destructors = new ArrayDeque<ManagedReferenceReleaseInterceptorFactory>();
            final ClassReflectionIndex componentClassIndex = deploymentReflectionIndex.getClassIndex(componentClassConfiguration.getModuleClass());
            final ArrayList componentUserAroundInvoke = new ArrayList();
            final HashMap userAroundInvokesByInterceptorClass = new HashMap();
            final HashMap userPostConstructByInterceptorClass = new HashMap();
            final HashMap userPreDestroyByInterceptorClass = new HashMap();
            ManagedReferenceFactory instanceFactory = configuration.getInstanceFactory();
            if (instanceFactory != null) {
                instantiators.addFirst(new ManagedReferenceInterceptorFactory(instanceFactory, instanceKey));
            } else {
                Constructor constructor = componentClassIndex.getConstructor(EMPTY_CLASS_ARRAY);
                if (constructor == null) {
                    throw new DeploymentUnitProcessingException("Could not find default constructor for " + componentClassConfiguration.getModuleClass());
                }
                ValueManagedReferenceFactory factory = new ValueManagedReferenceFactory((Value)new ConstructedValue(constructor, Collections.emptyList()));
                instantiators.addFirst(new ManagedReferenceInterceptorFactory((ManagedReferenceFactory)factory, instanceKey));
            }
            destructors.addLast(new ManagedReferenceReleaseInterceptorFactory(instanceKey));
            new ClassDescriptionTraversal(componentClassConfiguration, applicationDescription){

                @Override
                public void handle(EEModuleClassConfiguration classConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    for (ResourceInjectionConfiguration injectionConfiguration : classConfiguration.getInjectionConfigurations()) {
                        Object valueContextKey = new Object();
                        InjectedValue managedReferenceFactoryValue = new InjectedValue();
                        configuration.getStartDependencies().add(new InjectedConfigurator(injectionConfiguration, configuration, context, (InjectedValue<ManagedReferenceFactory>)managedReferenceFactoryValue));
                        injectors.addFirst(injectionConfiguration.getTarget().createInjectionInterceptorFactory(instanceKey, valueContextKey, (Value<ManagedReferenceFactory>)managedReferenceFactoryValue, deploymentUnit));
                        uninjectors.addLast(new ManagedReferenceReleaseInterceptorFactory(valueContextKey));
                    }
                }
            }.run();
            LinkedHashSet<InterceptorDescription> interceptorWithLifecycleCallbacks = new LinkedHashSet<InterceptorDescription>();
            if (!description.isExcludeDefaultInterceptors()) {
                interceptorWithLifecycleCallbacks.addAll(description.getDefaultInterceptors());
            }
            interceptorWithLifecycleCallbacks.addAll(description.getClassInterceptors());
            for (InterceptorDescription interceptorDescription : description.getAllInterceptors()) {
                final String interceptorClassName = interceptorDescription.getInterceptorClassName();
                EEModuleClassConfiguration interceptorConfiguration = applicationDescription.getClassConfiguration(interceptorClassName);
                final Class<?> contextKey = interceptorConfiguration.getModuleClass();
                if (interceptorConfiguration.getInstantiator() == null) {
                    throw new DeploymentUnitProcessingException("No default constructor for interceptor class " + interceptorClassName + " on component " + componentClassConfiguration.getModuleClass());
                }
                instantiators.addFirst(new ManagedReferenceInterceptorFactory(interceptorConfiguration.getInstantiator(), contextKey));
                destructors.addLast(new ManagedReferenceReleaseInterceptorFactory(contextKey));
                final boolean interceptorHasLifecycleCallbacks = interceptorWithLifecycleCallbacks.contains(interceptorDescription);
                final ClassReflectionIndex interceptorIndex = deploymentReflectionIndex.getClassIndex(interceptorConfiguration.getModuleClass());
                new ClassDescriptionTraversal(interceptorConfiguration, applicationDescription){

                    @Override
                    public void handle(EEModuleClassConfiguration interceptorClassConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                        MethodIdentifier aroundInvokeMethodIdentifier;
                        Method method;
                        ClassReflectionIndex interceptorClassIndex = deploymentReflectionIndex.getClassIndex(interceptorClassConfiguration.getModuleClass());
                        for (ResourceInjectionConfiguration injectionConfiguration : interceptorClassConfiguration.getInjectionConfigurations()) {
                            Object valueContextKey = new Object();
                            InjectedValue managedReferenceFactoryValue = new InjectedValue();
                            configuration.getStartDependencies().add(new InjectedConfigurator(injectionConfiguration, configuration, context, (InjectedValue<ManagedReferenceFactory>)managedReferenceFactoryValue));
                            injectors.addFirst(injectionConfiguration.getTarget().createInjectionInterceptorFactory(contextKey, valueContextKey, (Value<ManagedReferenceFactory>)managedReferenceFactoryValue, deploymentUnit));
                            uninjectors.addLast(new ManagedReferenceReleaseInterceptorFactory(valueContextKey));
                        }
                        if (interceptorHasLifecycleCallbacks) {
                            Method method2;
                            MethodIdentifier preDestroyMethodIdentifier;
                            MethodIdentifier postConstructMethodIdentifier = classDescription.getPostConstructMethod();
                            if (postConstructMethodIdentifier != null && DefaultFirstConfigurator.this.isNotOverriden(interceptorClassConfiguration, method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)interceptorClassIndex, (MethodIdentifier)postConstructMethodIdentifier), interceptorIndex, deploymentReflectionIndex)) {
                                ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(contextKey, method, true);
                                ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory> userPostConstruct = (ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>)userPostConstructByInterceptorClass.get(interceptorClassName);
                                if (userPostConstruct == null) {
                                    userPostConstruct = new ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>();
                                    userPostConstructByInterceptorClass.put(interceptorClassName, userPostConstruct);
                                }
                                userPostConstruct.add(interceptorFactory);
                            }
                            if ((preDestroyMethodIdentifier = classDescription.getPreDestroyMethod()) != null && DefaultFirstConfigurator.this.isNotOverriden(interceptorClassConfiguration, method2 = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)interceptorClassIndex, (MethodIdentifier)preDestroyMethodIdentifier), interceptorIndex, deploymentReflectionIndex)) {
                                ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(contextKey, method2, true);
                                ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory> userPreDestroy = (ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>)userPreDestroyByInterceptorClass.get(interceptorClassName);
                                if (userPreDestroy == null) {
                                    userPreDestroy = new ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>();
                                    userPreDestroyByInterceptorClass.put(interceptorClassName, userPreDestroy);
                                }
                                userPreDestroy.add(interceptorFactory);
                            }
                        }
                        if ((aroundInvokeMethodIdentifier = classDescription.getAroundInvokeMethod()) != null && DefaultFirstConfigurator.this.isNotOverriden(interceptorClassConfiguration, method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)interceptorClassIndex, (MethodIdentifier)aroundInvokeMethodIdentifier), interceptorIndex, deploymentReflectionIndex)) {
                            ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory> interceptors = (ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                            if (interceptors == null) {
                                interceptors = new ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>();
                                userAroundInvokesByInterceptorClass.put(interceptorClassName, interceptors);
                            }
                            interceptors.add(new ManagedReferenceLifecycleMethodInterceptorFactory(contextKey, method, false));
                        }
                    }
                }.run();
            }
            final ArrayDeque userPostConstruct = new ArrayDeque();
            final ArrayDeque userPreDestroy = new ArrayDeque();
            for (InterceptorDescription interceptorClass : interceptorWithLifecycleCallbacks) {
                if (userPostConstructByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) {
                    userPostConstruct.addAll((Collection)userPostConstructByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
                }
                if (!userPreDestroyByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) continue;
                userPreDestroy.addAll((Collection)userPreDestroyByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
            }
            new ClassDescriptionTraversal(componentClassConfiguration, applicationDescription){

                @Override
                public void handle(EEModuleClassConfiguration configuration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    Method method;
                    MethodIdentifier componentAroundInvokeMethodIdentifier;
                    Method method2;
                    MethodIdentifier componentPreDestroyMethodIdentifier;
                    Method method3;
                    ClassReflectionIndex classReflectionIndex = deploymentReflectionIndex.getClassIndex(configuration.getModuleClass());
                    MethodIdentifier componentPostConstructMethodIdentifier = classDescription.getPostConstructMethod();
                    if (componentPostConstructMethodIdentifier != null && DefaultFirstConfigurator.this.isNotOverriden(configuration, method3 = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)classReflectionIndex, (MethodIdentifier)componentPostConstructMethodIdentifier), componentClassIndex, deploymentReflectionIndex)) {
                        ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(instanceKey, method3, true);
                        userPostConstruct.addLast(interceptorFactory);
                    }
                    if ((componentPreDestroyMethodIdentifier = classDescription.getPreDestroyMethod()) != null && DefaultFirstConfigurator.this.isNotOverriden(configuration, method2 = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)classReflectionIndex, (MethodIdentifier)componentPreDestroyMethodIdentifier), componentClassIndex, deploymentReflectionIndex)) {
                        ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(instanceKey, method2, true);
                        userPreDestroy.addLast(interceptorFactory);
                    }
                    if ((componentAroundInvokeMethodIdentifier = classDescription.getAroundInvokeMethod()) != null && DefaultFirstConfigurator.this.isNotOverriden(configuration, method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)classReflectionIndex, (MethodIdentifier)componentAroundInvokeMethodIdentifier), componentClassIndex, deploymentReflectionIndex)) {
                        componentUserAroundInvoke.add(new ManagedReferenceLifecycleMethodInterceptorFactory(instanceKey, method, false));
                    }
                }
            }.run();
            ImmediateInterceptorFactory tcclInterceptor = new ImmediateInterceptorFactory((Interceptor)new TCCLInterceptor((ClassLoader)module.getClassLoader()));
            if (!injectors.isEmpty()) {
                configuration.addPostConstructInterceptor(ComponentDescription.weaved(injectors), 1792);
            }
            if (!instantiators.isEmpty()) {
                configuration.addPostConstructInterceptor(ComponentDescription.weaved(instantiators), 1536);
            }
            if (!userPostConstruct.isEmpty()) {
                configuration.addPostConstructInterceptor(ComponentDescription.weaved(userPostConstruct), 2816);
            }
            configuration.addPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 3328);
            configuration.addPostConstructInterceptor((InterceptorFactory)tcclInterceptor, 256);
            if (!uninjectors.isEmpty()) {
                configuration.addPreDestroyInterceptor(ComponentDescription.weaved(uninjectors), 1280);
            }
            if (!destructors.isEmpty()) {
                configuration.addPreDestroyInterceptor(ComponentDescription.weaved(destructors), 1536);
            }
            if (!userPreDestroy.isEmpty()) {
                configuration.addPreDestroyInterceptor(ComponentDescription.weaved(userPreDestroy), 1792);
            }
            configuration.addPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 2304);
            configuration.addPreDestroyInterceptor((InterceptorFactory)tcclInterceptor, 256);
            List<InterceptorDescription> classInterceptors = description.getClassInterceptors();
            Map<MethodIdentifier, List<InterceptorDescription>> methodInterceptors = description.getMethodInterceptors();
            for (Method method : componentClassConfiguration.getClassMethods()) {
                List<InterceptorDescription> methodLevelInterceptors;
                List aroundInvokes;
                String interceptorClassName;
                configuration.addComponentInterceptor(method, Interceptors.getInitialInterceptorFactory(), 256);
                configuration.addComponentInterceptor(method, new ManagedReferenceMethodInterceptorFactory(instanceKey, method), 2560);
                configuration.addComponentInterceptor(method, (InterceptorFactory)tcclInterceptor, 512);
                MethodIdentifier identifier = MethodIdentifier.getIdentifier(method.getReturnType(), (String)method.getName(), (Class[])method.getParameterTypes());
                ArrayList userAroundInvokes = new ArrayList();
                if (!description.isExcludeDefaultInterceptors() && !description.isExcludeDefaultInterceptors(identifier)) {
                    for (InterceptorDescription interceptorDescription : description.getDefaultInterceptors()) {
                        interceptorClassName = interceptorDescription.getInterceptorClassName();
                        aroundInvokes = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                        if (aroundInvokes == null) continue;
                        userAroundInvokes.addAll(aroundInvokes);
                    }
                }
                if (!description.isExcludeClassInterceptors(identifier)) {
                    for (InterceptorDescription interceptorDescription : classInterceptors) {
                        interceptorClassName = interceptorDescription.getInterceptorClassName();
                        aroundInvokes = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                        if (aroundInvokes == null || aroundInvokes == null) continue;
                        userAroundInvokes.addAll(aroundInvokes);
                    }
                }
                if ((methodLevelInterceptors = methodInterceptors.get(identifier)) != null) {
                    for (InterceptorDescription methodLevelInterceptor : methodLevelInterceptors) {
                        String interceptorClassName2 = methodLevelInterceptor.getInterceptorClassName();
                        List aroundInvokes2 = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName2);
                        if (aroundInvokes2 == null || aroundInvokes2 == null) continue;
                        userAroundInvokes.addAll(aroundInvokes2);
                    }
                }
                if (componentUserAroundInvoke != null) {
                    userAroundInvokes.addAll(componentUserAroundInvoke);
                }
                if (userAroundInvokes.isEmpty()) continue;
                configuration.addComponentInterceptor(method, ComponentDescription.weaved(userAroundInvokes), 2048);
            }
            for (ViewDescription view : description.getViews()) {
                Class viewClass;
                try {
                    viewClass = module.getClassLoader().loadClass(view.getViewClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load view class " + view.getViewClassName() + " for component " + configuration, (Throwable)e);
                }
                ViewConfiguration viewConfiguration = viewClass.isInterface() ? view.createViewConfiguration(viewClass, configuration, new ProxyFactory(viewClass.getName() + "$$$view" + PROXY_ID.incrementAndGet(), Object.class, viewClass.getClassLoader(), viewClass.getProtectionDomain(), new Class[]{viewClass})) : view.createViewConfiguration(viewClass, configuration, new ProxyFactory(viewClass.getName() + "$$$view" + PROXY_ID.incrementAndGet(), viewClass, viewClass.getClassLoader(), viewClass.getProtectionDomain(), new Class[0]));
                for (ViewConfigurator configurator : view.getConfigurators()) {
                    configurator.configure(context, configuration, view, viewConfiguration);
                }
                configuration.getViews().add(viewConfiguration);
            }
            configuration.getStartDependencies().add(new DependencyConfigurator(){

                @Override
                public void configureDependency(ServiceBuilder<?> serviceBuilder) throws DeploymentUnitProcessingException {
                    for (Map.Entry<ServiceName, ServiceBuilder.DependencyType> entry : description.getDependencies().entrySet()) {
                        serviceBuilder.addDependency(entry.getValue(), entry.getKey());
                    }
                }
            });
        }

        private boolean isNotOverriden(EEModuleClassConfiguration configuration, Method method, ClassReflectionIndex<?> componentClassIndex, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
            return Modifier.isPrivate(method.getModifiers()) || ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, componentClassIndex, (Method)method).getDeclaringClass() == configuration.getModuleClass();
        }
    }
}

