/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;
import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.msc.value.ConstructedValue;

public final class EEModuleClassDescription {
    private static final DefaultConfigurator DEFAULT_CONFIGURATOR = new DefaultConfigurator();
    private final String className;
    private final Deque<ClassConfigurator> configurators = new LinkedBlockingDeque<ClassConfigurator>();
    private MethodIdentifier postConstructMethod;
    private MethodIdentifier preDestroyMethod;
    private MethodIdentifier aroundInvokeMethod;
    private boolean invalid;
    private StringBuilder invalidMessageBuilder;

    public EEModuleClassDescription(String className) {
        this.className = className;
        this.configurators.addFirst(DEFAULT_CONFIGURATOR);
    }

    public String getClassName() {
        return this.className;
    }

    public MethodIdentifier getAroundInvokeMethod() {
        return this.aroundInvokeMethod;
    }

    public void setAroundInvokeMethod(MethodIdentifier aroundInvokeMethod) {
        this.aroundInvokeMethod = aroundInvokeMethod;
    }

    public MethodIdentifier getPostConstructMethod() {
        return this.postConstructMethod;
    }

    public void setPostConstructMethod(MethodIdentifier postConstructMethod) {
        this.postConstructMethod = postConstructMethod;
    }

    public MethodIdentifier getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    public void setPreDestroyMethod(MethodIdentifier preDestroyMethod) {
        this.preDestroyMethod = preDestroyMethod;
    }

    public Deque<ClassConfigurator> getConfigurators() {
        return this.configurators;
    }

    public synchronized void setInvalid(String message) {
        if (!this.invalid) {
            this.invalid = true;
            this.invalidMessageBuilder = new StringBuilder();
        } else {
            this.invalidMessageBuilder.append('\n');
        }
        this.invalidMessageBuilder.append(message);
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public String getInvalidMessage() {
        if (this.invalidMessageBuilder == null) {
            return "";
        }
        return this.invalidMessageBuilder.toString();
    }

    private static class DefaultConfigurator
    implements ClassConfigurator {
        private static final Class<?>[] NO_CLASSES = new Class[0];

        private DefaultConfigurator() {
        }

        @Override
        public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
            Constructor constructor;
            DeploymentReflectionIndex index = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
            Class<?> moduleClass = configuration.getModuleClass();
            ClassReflectionIndex classIndex = index.getClassIndex(moduleClass);
            if (configuration.getInstantiator() == null && (constructor = classIndex.getConstructor((Class[])NO_CLASSES)) != null) {
                configuration.setInstantiator((ManagedReferenceFactory)new ValueManagedReferenceFactory(DefaultConfigurator.createConstructedValue(constructor)));
            }
        }

        private static <T> ConstructedValue<T> createConstructedValue(Constructor<T> constructor) {
            return new ConstructedValue(constructor, Collections.emptyList());
        }
    }
}

