/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.msc.inject.InjectionException;

public final class ViewManagedReferenceFactory
implements ManagedReferenceFactory {
    private final ComponentView view;

    public ViewManagedReferenceFactory(ComponentView view) {
        this.view = view;
    }

    public ManagedReference getReference() {
        ComponentViewInstance instance = this.view.createInstance();
        return new Instance(instance, instance.createProxy());
    }

    private static class Instance
    implements ManagedReference {
        private final ComponentViewInstance instance;
        private volatile Object proxy;
        private static final AtomicReferenceFieldUpdater<Instance, Object> proxyUpdater = AtomicReferenceFieldUpdater.newUpdater(Instance.class, Object.class, "proxy");

        public Instance(ComponentViewInstance instance, Object proxy) {
            this.instance = instance;
            this.proxy = proxy;
        }

        public void release() {
            if (proxyUpdater.getAndSet(this, null) != null) {
                this.instance.destroy();
            }
        }

        public Object getInstance() {
            Object proxy = this.proxy;
            if (proxy == null) {
                throw new IllegalStateException("Instance was destroyed");
            }
            return proxy;
        }
    }

    public static class Injector
    implements org.jboss.msc.inject.Injector<ComponentView> {
        private final org.jboss.msc.inject.Injector<ManagedReferenceFactory> referenceFactoryInjector;

        public Injector(org.jboss.msc.inject.Injector<ManagedReferenceFactory> referenceFactoryInjector) {
            this.referenceFactoryInjector = referenceFactoryInjector;
        }

        public void inject(ComponentView value) throws InjectionException {
            this.referenceFactoryInjector.inject((Object)new ViewManagedReferenceFactory(value));
        }

        public void uninject() {
            this.referenceFactoryInjector.uninject();
        }
    }
}

