/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.vfs.VirtualFile;

public final class EarLibManifestClassPathProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        List resourceRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit);
        if (!DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        DeploymentUnit parent = deploymentUnit.getParent();
        DeploymentUnit topLevelDeployment = parent == null ? deploymentUnit : parent;
        VirtualFile toplevelRoot = ((ResourceRoot)topLevelDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        ExternalModuleService externalModuleService = (ExternalModuleService)topLevelDeployment.getAttachment(Attachments.EXTERNAL_MODULE_SERVICE);
        HashMap<VirtualFile, ResourceRoot> files = new HashMap<VirtualFile, ResourceRoot>();
        for (ResourceRoot resourceRoot : resourceRoots) {
            files.put(resourceRoot.getRoot(), resourceRoot);
        }
        ArrayDeque<ResourceRoot> libResourceRoots = new ArrayDeque<ResourceRoot>();
        for (ResourceRoot resourceRoot : resourceRoots) {
            if (!ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot) || SubDeploymentMarker.isSubDeployment((ResourceRoot)resourceRoot)) continue;
            libResourceRoots.add(resourceRoot);
        }
        while (!libResourceRoots.isEmpty()) {
            String[] items;
            ResourceRoot resourceRoot;
            resourceRoot = (ResourceRoot)libResourceRoots.pop();
            for (String item : items = EarLibManifestClassPathProcessor.getClassPathEntries(resourceRoot)) {
                VirtualFile classPathFile = resourceRoot.getRoot().getParent().getChild(item);
                if (!classPathFile.exists()) {
                    log.warnf("Class Path entry %s in %s not found. ", (Object)item, (Object)resourceRoot.getRoot());
                    continue;
                }
                if (EarLibManifestClassPathProcessor.isInside(classPathFile, toplevelRoot)) {
                    if (!files.containsKey(classPathFile)) {
                        log.warnf("Class Path entry %s in %s does not point to a valid jar for a Class-Path reference.", (Object)item, (Object)resourceRoot.getRoot());
                        continue;
                    }
                    ResourceRoot target = (ResourceRoot)files.get(classPathFile);
                    if (SubDeploymentMarker.isSubDeployment((ResourceRoot)target)) {
                        log.warnf("Class Path entry  in " + resourceRoot.getRoot() + "  may not point to a sub deployment.", new Object[0]);
                        continue;
                    }
                    if (ModuleRootMarker.isModuleRoot((ResourceRoot)target)) continue;
                    ModuleRootMarker.mark((ResourceRoot)target);
                    libResourceRoots.push(target);
                    log.debugf("Resource %s added to logical lib directory due to Class-Path entry in %s", (Object)classPathFile, (Object)target.getRoot());
                    continue;
                }
                if (item.startsWith("/")) {
                    ModuleIdentifier moduleIdentifier = externalModuleService.addExternalModule(item);
                    deploymentUnit.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, (Object)moduleIdentifier);
                    log.debugf("Resource %s added as external jar %s", (Object)classPathFile, (Object)resourceRoot.getRoot());
                    continue;
                }
                log.warnf("Class Path entry %s in %s does not point to a valid jar for a Class-Path reference.", (Object)item, (Object)resourceRoot.getRoot());
            }
        }
    }

    private static boolean isInside(VirtualFile classPathFile, VirtualFile toplevelRoot) {
        VirtualFile[] parentPaths;
        for (VirtualFile path : parentPaths = classPathFile.getParentFiles()) {
            if (path != toplevelRoot) continue;
            return true;
        }
        return false;
    }

    private static String[] getClassPathEntries(ResourceRoot resourceRoot) {
        Manifest manifest = (Manifest)resourceRoot.getAttachment(Attachments.MANIFEST);
        if (manifest == null) {
            return EMPTY_STRING_ARRAY;
        }
        String classPathString = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (classPathString == null) {
            return EMPTY_STRING_ARRAY;
        }
        return classPathString.split("\\s+");
    }

    public void undeploy(DeploymentUnit context) {
    }
}

