/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jbc.cacheprovider;

import java.util.Properties;

public class CacheProperties {
    public static final String HIBERNATE_CACHE_OBJECT_NAME_PROPERTY = "hibernate.treecache.mbean.object_name";
    public static final String DEFAULT_CACHE_OBJECT_NAME = "jboss.cache:service=TreeCache";
    public static final String HIBERNATE_CACHE_REGION_PREFIX_PROPERTY = "hibernate.cache.region_prefix";
    public static final String HIBERNATE_CACHE_QUERYCACHE_LOCAL_WRITES_ONLY_PROPERTY = "hibernate.treecache.querycache.local_writes_only";
    public static final String LEGACY_HIBERNATE_CACHE_QUERYCACHE_LOCAL_WRITES_ONLY_PROPERTY = "hibernate.treecache.querycache.local.writes.only";
    public static final String DEFAULT_QUERYCACHE_LOCAL_WRITES_ONLY = "true";
    public static final String HIBERNATE_CACHE_LOCAL_PUTS_ONLY_PROPERTY = "hibernate.treecache.local_puts_only";
    public static final String LEGACY_HIBERNATE_CACHE_LOCAL_PUTS_ONLY_PROPERTY = "hibernate.treecache.local.puts.only";
    public static final String DEFAULT_LOCAL_PUTS_ONLY = "true";
    private final String cacheObjectName;
    private final String cacheRegionPrefix;
    private final boolean queryCacheLocalWritesOnly;
    private final boolean localPutsOnly;

    public CacheProperties(Properties properties) {
        String name = properties.getProperty(HIBERNATE_CACHE_OBJECT_NAME_PROPERTY);
        this.cacheObjectName = name != null ? name : DEFAULT_CACHE_OBJECT_NAME;
        this.cacheRegionPrefix = properties.getProperty(HIBERNATE_CACHE_REGION_PREFIX_PROPERTY);
        String prop = properties.getProperty(HIBERNATE_CACHE_QUERYCACHE_LOCAL_WRITES_ONLY_PROPERTY);
        this.queryCacheLocalWritesOnly = prop != null ? new Boolean(prop) : ((prop = properties.getProperty(LEGACY_HIBERNATE_CACHE_QUERYCACHE_LOCAL_WRITES_ONLY_PROPERTY)) != null ? new Boolean(prop).booleanValue() : new Boolean("true").booleanValue());
        prop = properties.getProperty(HIBERNATE_CACHE_LOCAL_PUTS_ONLY_PROPERTY);
        this.localPutsOnly = prop != null ? new Boolean(prop) : ((prop = properties.getProperty(LEGACY_HIBERNATE_CACHE_LOCAL_PUTS_ONLY_PROPERTY)) != null ? new Boolean(prop).booleanValue() : new Boolean("true").booleanValue());
    }

    public String getCacheObjectName() {
        return this.cacheObjectName;
    }

    public String getCacheRegionPrefix() {
        return this.cacheRegionPrefix;
    }

    public boolean isQueryCacheLocalWritesOnly() {
        return this.queryCacheLocalWritesOnly;
    }

    public boolean isLocalPutsOnly() {
        return this.localPutsOnly;
    }
}

