/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jbc.cacheprovider;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.hibernate.jbc.cacheprovider.CacheProperties;
import org.jboss.hibernate.jbc.cacheprovider.JBCCache;
import org.jboss.hibernate.jbc.cacheprovider.OptimisticJBCCache;
import org.jboss.logging.Logger;

public class TreeCacheProvider
implements CacheProvider {
    public static final String CONFIG_RESOURCE = "hibernate.cache.tree_cache.config";
    public static final String DEFAULT_CONFIG = "treecache.xml";
    public static final String LEGACY_DEFAULT_CONFIG = "treecache-optimistic.xml";
    private static final Logger log = Logger.getLogger(TreeCacheProvider.class);
    private TreeCache cache;
    private TransactionManager transactionManager;
    private boolean optimistic;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        CacheProperties cacheProperties = new CacheProperties(properties);
        if (this.optimistic) {
            return new OptimisticJBCCache(this.getUnderlyingCache(), regionName, cacheProperties);
        }
        return new JBCCache(this.getUnderlyingCache(), regionName, cacheProperties, this.transactionManager);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public boolean isOptimistic() {
        return this.optimistic;
    }

    public void start(Properties properties) {
        String resource = properties.getProperty("hibernate.cache.provider_configuration_file_resource_path");
        if (resource == null) {
            resource = properties.getProperty(CONFIG_RESOURCE);
        }
        if (resource == null) {
            String string = resource = this.configFileExists(DEFAULT_CONFIG) ? DEFAULT_CONFIG : null;
        }
        if (resource == null) {
            resource = this.configFileExists(LEGACY_DEFAULT_CONFIG) ? LEGACY_DEFAULT_CONFIG : DEFAULT_CONFIG;
        }
        log.debug((Object)("Configuring TreeCache from resource [" + resource + "]"));
        try {
            this.cache = new TreeCache();
            PropertyConfigurator config = new PropertyConfigurator();
            config.configure((Object)this.cache, resource);
            TransactionManagerLookup transactionManagerLookup = TransactionManagerLookupFactory.getTransactionManagerLookup((Properties)properties);
            if (transactionManagerLookup != null) {
                this.cache.setTransactionManagerLookup((org.jboss.cache.TransactionManagerLookup)new TransactionManagerLookupAdaptor(transactionManagerLookup, properties));
                this.transactionManager = transactionManagerLookup.getTransactionManager(properties);
            }
            this.cache.startService();
            if ("OPTIMISTIC".equals(this.cache.getNodeLockingScheme())) {
                this.optimistic = true;
                log.debug((Object)"JBoss Cache is configured for optimistic locking; provided Cache implementations will also implement OptimisticCache");
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void stop() {
        if (this.cache != null) {
            this.cache.stopService();
            this.cache = null;
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public TreeCache getUnderlyingCache() {
        return this.cache;
    }

    protected boolean configFileExists(String configFile) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(configFile);
        if (is == null) {
            try {
                is = new FileInputStream(configFile);
            }
            catch (FileNotFoundException e) {
                log.debug((Object)("Config file not found: " + configFile));
            }
        }
        if (is == null) {
            return false;
        }
        log.debug((Object)("Using configuration file: " + configFile));
        return true;
    }

    static final class TransactionManagerLookupAdaptor
    implements org.jboss.cache.TransactionManagerLookup {
        private final TransactionManagerLookup tml;
        private final Properties props;

        TransactionManagerLookupAdaptor(TransactionManagerLookup tml, Properties props) {
            this.tml = tml;
            this.props = props;
        }

        public TransactionManager getTransactionManager() throws Exception {
            return this.tml.getTransactionManager(this.props);
        }
    }
}

