/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.impl.interceptor;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.remoting.PojiProxy;
import org.jboss.ejb3.async.impl.AsyncInvocationIdUUIDImpl;
import org.jboss.ejb3.async.impl.ClientExecutorService;
import org.jboss.ejb3.async.impl.interceptor.CurrentAsyncInvocation;
import org.jboss.ejb3.async.impl.interceptor.SecurityActions;
import org.jboss.ejb3.async.impl.util.concurrent.ResultUnwrappingExecutorService;
import org.jboss.ejb3.async.spi.AsyncCancellableContext;
import org.jboss.ejb3.async.spi.AsyncInvocation;
import org.jboss.ejb3.async.spi.AsyncInvocationContext;
import org.jboss.ejb3.async.spi.AsyncInvocationId;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AsyncMethodMetaData;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.remoting.InvokerLocator;
import org.jboss.security.SecurityContext;

public class AsynchronousClientInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AsynchronousClientInterceptor.class);
    private static final String INVOCATION_METADATA_TAG = "ASYNC";
    private static final String INVOCATION_METADATA_ATTR = "BEEN_HERE";
    private static final String INVOCATION_METADATA_VALUE = Boolean.TRUE.toString();
    private final AsyncMethodsMetaData asyncMethods;

    public AsynchronousClientInterceptor(AsyncMethodsMetaData asyncMethods) {
        assert (asyncMethods != null) : "Async Methods must be supplied";
        this.asyncMethods = asyncMethods;
        log.debug((Object)("Created: " + this + " to handle " + asyncMethods));
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (this.isAsyncInvocation(invocation)) {
            return this.invokeAsync(invocation);
        }
        return invocation.invokeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<?> invokeAsync(Invocation invocation) {
        Future task;
        ExecutorService executorService = this.getAsyncExecutor(invocation);
        SecurityContext sc = SecurityActions.getSecurityContext();
        Invocation nextInvocation = invocation.copy();
        nextInvocation.getMetaData().addMetaData((Object)INVOCATION_METADATA_TAG, (Object)INVOCATION_METADATA_ATTR, (Object)INVOCATION_METADATA_VALUE);
        AsyncInvocationIdUUIDImpl id = new AsyncInvocationIdUUIDImpl();
        AsyncInvocationTask asyncTask = new AsyncInvocationTask(nextInvocation, sc, id);
        try {
            CurrentAsyncInvocation.markCurrentInvocation(id, nextInvocation);
            task = executorService.submit(asyncTask);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Submitting async invocation " + invocation + " via " + executorService));
            }
        }
        finally {
            CurrentAsyncInvocation.unmarkCurrentInvocationFromThread();
        }
        return task;
    }

    private boolean isAsyncInvocation(Invocation invocation) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Checking to see if async: " + invocation));
        }
        assert (invocation instanceof MethodInvocation) : this.getClass().getName() + " supports only " + MethodInvocation.class.getSimpleName() + ", but has been passed: " + invocation;
        MethodInvocation si = (MethodInvocation)invocation;
        String beenHere = (String)invocation.getMetaData().getMetaData((Object)INVOCATION_METADATA_TAG, (Object)INVOCATION_METADATA_ATTR);
        if (beenHere != null && beenHere.equals(INVOCATION_METADATA_VALUE)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Been here, not dispatching as async again");
            }
            return false;
        }
        Method actualMethod = si.getActualMethod();
        for (AsyncMethodMetaData asyncMethod : this.asyncMethods) {
            String invokedMethodName = actualMethod.getName();
            if (!invokedMethodName.equals(asyncMethod.getMethodName())) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Async method names match: " + invokedMethodName));
            }
            MethodParametersMetaData asyncParams = asyncMethod.getMethodParams();
            Class<?>[] invokedParams = actualMethod.getParameterTypes();
            int invokedParamsSize = invokedParams.length;
            if (asyncParams.size() != invokedParams.length) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Different async params size, no match");
                }
                return false;
            }
            for (int i = 0; i < invokedParamsSize; ++i) {
                String declaredName;
                String invokedParamTypeName = invokedParams[i].getName();
                if (invokedParamTypeName.equals(declaredName = (String)asyncParams.get(i))) continue;
                return false;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Dispatching as @Asynchronous: " + actualMethod));
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Not @Asynchronous: " + invocation));
        }
        return false;
    }

    private ExecutorService getAsyncExecutor(Invocation invocation) {
        assert (invocation != null) : "Invocation must be specified";
        if (invocation instanceof AsyncInvocation) {
            AsyncInvocation asyncInvocation = (AsyncInvocation)invocation;
            AsyncInvocationContext context = asyncInvocation.getAsyncInvocationContext();
            assert (context != null) : "async invocation context of " + invocation + " was null";
            ExecutorService es = context.getAsynchronousExecutor();
            assert (es != null) : ExecutorService.class.getSimpleName() + " associated with " + context + " was null";
            return es;
        }
        InvokerLocator locator = (InvokerLocator)invocation.getMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR");
        Object oid = invocation.getMetaData().getMetaData((Object)"DISPATCHER", (Object)"OID");
        PojiProxy proxy = new PojiProxy(oid, locator, new Interceptor[0]);
        AsyncCancellableContext container = (AsyncCancellableContext)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{AsyncCancellableContext.class}, (InvocationHandler)proxy);
        return new ResultUnwrappingExecutorService(ClientExecutorService.INSTANCE, container);
    }

    private class AsyncInvocationTask<V>
    implements Callable<V> {
        private final Invocation invocation;
        private final SecurityContext sc;
        private final AsyncInvocationId id;

        public AsyncInvocationTask(Invocation invocation, SecurityContext sc, AsyncInvocationId id) {
            assert (invocation != null) : "Invocation must be supplied";
            assert (id != null) : "Async Invocation ID must be supplied";
            this.invocation = invocation;
            this.sc = sc;
            this.id = id;
        }

        @Override
        public V call() throws Exception {
            SecurityContext oldSc = SecurityActions.getSecurityContext();
            try {
                SecurityActions.setSecurityContext(this.sc);
                CurrentAsyncInvocation.markCurrentInvocation(this.id, this.invocation);
                Object object = this.invocation.invokeNext();
                return (V)object;
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new Error(t);
            }
            finally {
                SecurityActions.setSecurityContext(oldSc);
                CurrentAsyncInvocation.unmarkCurrentInvocation(this.invocation);
            }
        }
    }
}

