/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.jndi;

import javax.naming.Context;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.ejb3.nointerface.impl.jndi.SessionAwareNoInterfaceViewJNDIBinder;
import org.jboss.ejb3.nointerface.impl.jndi.SessionlessNoInterfaceViewJNDIBinder;
import org.jboss.ejb3.nointerface.spi.jndi.NoInterfaceViewJNDIBinder;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;

public class NoInterfaceViewJNDIBinderFacade {
    private static Logger logger = Logger.getLogger(NoInterfaceViewJNDIBinderFacade.class);
    protected KernelControllerContext endpointContext;
    private Class<?> beanClass;
    private JBossSessionBean31MetaData sessionBeanMetadata;
    private Context jndiCtx;
    private NoInterfaceViewJNDIBinder binder;

    public NoInterfaceViewJNDIBinderFacade(Context ctx, Class<?> beanClass, JBossSessionBean31MetaData sessionBeanMetadata) {
        this.jndiCtx = ctx;
        this.beanClass = beanClass;
        this.sessionBeanMetadata = sessionBeanMetadata;
    }

    @Start
    public void onStart() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating no-interface view for endpoint " + this.endpointContext));
        }
        this.binder = this.sessionBeanMetadata.isStateful() ? new SessionAwareNoInterfaceViewJNDIBinder(this.endpointContext) : new SessionlessNoInterfaceViewJNDIBinder(this.endpointContext);
        this.binder.bindNoInterfaceView(this.jndiCtx, this.beanClass, this.sessionBeanMetadata);
    }

    @Stop
    public void onStop() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Unbinding no-interface view from JNDI, for endpoint " + this.endpointContext));
        }
        if (this.binder != null) {
            this.binder.unbindNoInterfaceView(this.jndiCtx, this.beanClass, this.sessionBeanMetadata);
        }
    }

    public void setEndpointContext(KernelControllerContext endpointContext) throws Exception {
        this.endpointContext = endpointContext;
    }
}

