/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.jndi;

import java.lang.reflect.InvocationHandler;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.nointerface.impl.invocationhandler.NoInterfaceViewInvocationHandler;
import org.jboss.ejb3.nointerface.impl.jndi.AbstractNoInterfaceViewJNDIBinder;
import org.jboss.ejb3.proxy.javassist.JavassistProxyFactory;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;
import org.jboss.util.naming.NonSerializableFactory;

public class SessionlessNoInterfaceViewJNDIBinder
extends AbstractNoInterfaceViewJNDIBinder {
    private static Logger logger = Logger.getLogger(SessionlessNoInterfaceViewJNDIBinder.class);

    public SessionlessNoInterfaceViewJNDIBinder(KernelControllerContext endPointCtx) {
        super(endPointCtx);
    }

    public String bindNoInterfaceView(Context jndiCtx, Class<?> beanClass, JBossSessionBean31MetaData beanMetaData) throws NamingException, IllegalStateException {
        Object noInterfaceView;
        this.ensureNoInterfaceViewExists(beanMetaData);
        AsyncMethodsMetaData asyncMethods = beanMetaData.getAsyncMethods();
        NoInterfaceViewInvocationHandler invocationHandler = new NoInterfaceViewInvocationHandler(this.endpointContext, null, beanClass, asyncMethods == null ? new AsyncMethodsMetaData() : asyncMethods);
        try {
            noInterfaceView = new JavassistProxyFactory().createProxy(new Class[]{beanClass}, (InvocationHandler)invocationHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create no-interface view for bean class: " + beanClass, e);
        }
        String noInterfaceJndiName = this.getJNDINameResolver(beanMetaData).resolveNoInterfaceJNDIName(beanMetaData);
        this.prettyPrintJNDIBindingInfo(beanMetaData, noInterfaceJndiName);
        NonSerializableFactory.rebind((Context)jndiCtx, (String)noInterfaceJndiName, (Object)noInterfaceView, (boolean)true);
        return noInterfaceJndiName;
    }

    public void unbindNoInterfaceView(Context jndiCtx, Class<?> beanClass, JBossSessionBean31MetaData beanMetaData) throws NamingException, IllegalStateException {
        this.ensureNoInterfaceViewExists(beanMetaData);
        String noInterfaceJndiName = this.getJNDINameResolver(beanMetaData).resolveNoInterfaceJNDIName(beanMetaData);
        jndiCtx.unbind(noInterfaceJndiName);
    }
}

