/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.integration.deployer;

import java.util.Collection;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public final class DeployersUtils {
    public static final String WEB_BEANS_FILES = "WEB_BEANS_FILES";
    public static final String WEB_BEANS_CLASSPATH = "WEB_BEANS_CLASSPATH";
    public static final String WEB_BEANS_DEPLOYMENT_FLAG = "WEB_BEANS_DEPLOYMENT_FLAG";
    public static final String WEB_BEANS_BOOTSTRAP_BEAN = "_WebBeansBootstrapBean";

    private DeployersUtils() {
    }

    public static String getBootstrapBeanName(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        DeploymentUnit top = unit.getTopLevel();
        return top.getName() + WEB_BEANS_BOOTSTRAP_BEAN;
    }

    public static boolean checkForWebBeansFiles(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        DeploymentUnit top = unit.getTopLevel();
        Boolean flag = (Boolean)top.getAttachment(WEB_BEANS_DEPLOYMENT_FLAG, Boolean.class);
        if (flag != null) {
            return flag;
        }
        flag = DeployersUtils.searchForWebBeans(top);
        top.addAttachment(WEB_BEANS_DEPLOYMENT_FLAG, (Object)flag, Boolean.class);
        return flag;
    }

    private static boolean searchForWebBeans(DeploymentUnit unit) {
        Collection files = (Collection)unit.getAttachment(WEB_BEANS_FILES, Collection.class);
        if (files != null && !files.isEmpty()) {
            return true;
        }
        List children = unit.getChildren();
        if (children != null && !children.isEmpty()) {
            for (DeploymentUnit child : children) {
                boolean result = DeployersUtils.searchForWebBeans(child);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }
}

