/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.impl.ha.client.acc;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.jboss.cache.Fqn;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Request;
import org.jdiameter.api.acc.ClientAccSession;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.client.impl.app.acc.IClientAccSessionData;
import org.jdiameter.common.api.app.acc.ClientAccSessionState;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.diameter.impl.ha.common.AppSessionDataReplicatedImpl;
import org.mobicents.diameter.impl.ha.data.ReplicatedSessionDatasource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientAccSessionDataReplicatedImpl
extends AppSessionDataReplicatedImpl
implements IClientAccSessionData {
    private static final Logger logger = LoggerFactory.getLogger(ClientAccSessionDataReplicatedImpl.class);
    private static final String STATE = "STATE";
    private static final String INTERIM_TIMERID = "INTERIM_TIMERID";
    private static final String DEST_HOST = "DEST_HOST";
    private static final String DEST_REALM = "DEST_REALM";
    private static final String BUFFER = "BUFFER";
    private IMessageParser messageParser;

    public ClientAccSessionDataReplicatedImpl(Fqn<?> nodeFqn, MobicentsCluster mobicentsCluster, IContainer container) {
        super(nodeFqn, mobicentsCluster);
        if (super.create()) {
            ClientAccSessionDataReplicatedImpl.setAppSessionIface(this, ClientAccSession.class);
            this.setClientAccSessionState(ClientAccSessionState.IDLE);
        }
        this.messageParser = (IMessageParser)container.getAssemblerFacility().getComponentInstance(IMessageParser.class);
    }

    public ClientAccSessionDataReplicatedImpl(String sessionId, MobicentsCluster mobicentsCluster, IContainer container) {
        this(Fqn.fromRelativeElements((Fqn)ReplicatedSessionDatasource.SESSIONS_FQN, (Object[])new String[]{sessionId}), mobicentsCluster, container);
    }

    public void setClientAccSessionState(ClientAccSessionState state) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)STATE, (Object)state);
    }

    public ClientAccSessionState getClientAccSessionState() {
        if (this.exists()) {
            return (ClientAccSessionState)this.getNode().get((Object)STATE);
        }
        throw new IllegalStateException();
    }

    public void setInterimTimerId(Serializable tid) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)INTERIM_TIMERID, (Object)tid);
    }

    public Serializable getInterimTimerId() {
        if (this.exists()) {
            return (Serializable)this.getNode().get((Object)INTERIM_TIMERID);
        }
        throw new IllegalStateException();
    }

    public void setDestinationHost(String destHost) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)DEST_HOST, (Object)destHost);
    }

    public String getDestinationHost() {
        if (this.exists()) {
            return (String)this.getNode().get((Object)DEST_HOST);
        }
        throw new IllegalStateException();
    }

    public void setDestinationRealm(String destRealm) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)DEST_REALM, (Object)destRealm);
    }

    public String getDestinationRealm() {
        if (this.exists()) {
            return (String)this.getNode().get((Object)DEST_REALM);
        }
        throw new IllegalStateException();
    }

    public Request getBuffer() {
        byte[] data = (byte[])this.getNode().get((Object)BUFFER);
        if (data != null) {
            try {
                return this.messageParser.createMessage(ByteBuffer.wrap(data));
            }
            catch (AvpDataException e) {
                logger.error("Unable to recreate message from buffer.");
                return null;
            }
        }
        return null;
    }

    public void setBuffer(Request buffer) {
        if (buffer != null) {
            try {
                byte[] data = this.messageParser.encodeMessage((IMessage)buffer).array();
                this.getNode().put((Object)BUFFER, (Object)data);
            }
            catch (ParseException e) {
                logger.error("Unable to encode message to buffer.");
            }
        } else {
            this.getNode().remove((Object)BUFFER);
        }
    }
}

