/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.impl.ha.client.ro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.jboss.cache.Fqn;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Request;
import org.jdiameter.api.ro.ClientRoSession;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.client.impl.app.ro.IClientRoSessionData;
import org.jdiameter.common.api.app.ro.ClientRoSessionState;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.diameter.impl.ha.common.AppSessionDataReplicatedImpl;
import org.mobicents.diameter.impl.ha.data.ReplicatedSessionDatasource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRoSessionDataReplicatedImpl
extends AppSessionDataReplicatedImpl
implements IClientRoSessionData {
    private static final Logger logger = LoggerFactory.getLogger(ClientRoSessionDataReplicatedImpl.class);
    private static final String EVENT_BASED = "EVENT_BASED";
    private static final String REQUEST_TYPE = "REQUEST_TYPE";
    private static final String STATE = "STATE";
    private static final String TXTIMER_ID = "TXTIMER_ID";
    private static final String TXTIMER_REQUEST = "TXTIMER_REQUEST";
    private static final String BUFFER = "BUFFER";
    private static final String GRA = "GRA";
    private static final String GDDFH = "GDDFH";
    private static final String GCCFH = "GCCFH";
    private IMessageParser messageParser;

    public ClientRoSessionDataReplicatedImpl(Fqn<?> nodeFqn, MobicentsCluster mobicentsCluster, IContainer container) {
        super(nodeFqn, mobicentsCluster);
        if (super.create()) {
            ClientRoSessionDataReplicatedImpl.setAppSessionIface(this, ClientRoSession.class);
            this.setClientRoSessionState(ClientRoSessionState.IDLE);
        }
        this.messageParser = (IMessageParser)container.getAssemblerFacility().getComponentInstance(IMessageParser.class);
    }

    public ClientRoSessionDataReplicatedImpl(String sessionId, MobicentsCluster mobicentsCluster, IContainer container) {
        this(Fqn.fromRelativeElements((Fqn)ReplicatedSessionDatasource.SESSIONS_FQN, (Object[])new String[]{sessionId}), mobicentsCluster, container);
    }

    public boolean isEventBased() {
        if (this.exists()) {
            return (Boolean)this.getNode().get((Object)EVENT_BASED);
        }
        throw new IllegalStateException();
    }

    public void setEventBased(boolean isEventBased) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)EVENT_BASED, (Object)isEventBased);
    }

    public boolean isRequestTypeSet() {
        if (this.exists()) {
            return (Boolean)this.getNode().get((Object)REQUEST_TYPE);
        }
        throw new IllegalStateException();
    }

    public void setRequestTypeSet(boolean requestTypeSet) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)REQUEST_TYPE, (Object)requestTypeSet);
    }

    public ClientRoSessionState getClientRoSessionState() {
        if (this.exists()) {
            return (ClientRoSessionState)this.getNode().get((Object)STATE);
        }
        throw new IllegalStateException();
    }

    public void setClientRoSessionState(ClientRoSessionState state) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)STATE, (Object)state);
    }

    public Serializable getTxTimerId() {
        if (this.exists()) {
            return (Serializable)this.getNode().get((Object)TXTIMER_ID);
        }
        throw new IllegalStateException();
    }

    public void setTxTimerId(Serializable txTimerId) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)TXTIMER_ID, (Object)txTimerId);
    }

    public Request getTxTimerRequest() {
        if (this.exists()) {
            byte[] data = (byte[])this.getNode().get((Object)TXTIMER_REQUEST);
            if (data != null) {
                try {
                    return this.messageParser.createMessage(ByteBuffer.wrap(data));
                }
                catch (AvpDataException e) {
                    logger.error("Unable to recreate Tx Timer Request from buffer.");
                    return null;
                }
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public void setTxTimerRequest(Request txTimerRequest) {
        if (this.exists()) {
            if (txTimerRequest != null) {
                try {
                    byte[] data = this.messageParser.encodeMessage((IMessage)txTimerRequest).array();
                    this.getNode().put((Object)TXTIMER_REQUEST, (Object)data);
                }
                catch (ParseException e) {
                    logger.error("Unable to encode Tx Timer Request to buffer.");
                }
            } else {
                this.getNode().remove((Object)TXTIMER_REQUEST);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public Request getBuffer() {
        byte[] data = (byte[])this.getNode().get((Object)BUFFER);
        if (data != null) {
            try {
                return this.messageParser.createMessage(ByteBuffer.wrap(data));
            }
            catch (AvpDataException e) {
                logger.error("Unable to recreate message from buffer.");
                return null;
            }
        }
        return null;
    }

    public void setBuffer(Request buffer) {
        if (buffer != null) {
            try {
                byte[] data = this.messageParser.encodeMessage((IMessage)buffer).array();
                this.getNode().put((Object)BUFFER, (Object)data);
            }
            catch (ParseException e) {
                logger.error("Unable to encode message to buffer.");
            }
        } else {
            this.getNode().remove((Object)BUFFER);
        }
    }

    public int getGatheredRequestedAction() {
        if (this.exists()) {
            return (Integer)this.getNode().get((Object)GRA);
        }
        throw new IllegalStateException();
    }

    public void setGatheredRequestedAction(int gatheredRequestedAction) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)GRA, (Object)gatheredRequestedAction);
    }

    public int getGatheredCCFH() {
        if (this.exists()) {
            return (Integer)this.getNode().get((Object)GCCFH);
        }
        throw new IllegalStateException();
    }

    public void setGatheredCCFH(int gatheredCCFH) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)GCCFH, (Object)gatheredCCFH);
    }

    public int getGatheredDDFH() {
        if (this.exists()) {
            return (Integer)this.getNode().get((Object)GDDFH);
        }
        throw new IllegalStateException();
    }

    public void setGatheredDDFH(int gatheredDDFH) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)GDDFH, (Object)gatheredDDFH);
    }
}

