/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.ApplicationProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ApplicationPropertySet {
    private Map<ApplicationProperty, Boolean> _attributesBool = null;
    private Map<ApplicationProperty, CharSequence> _attributesString = null;

    public ApplicationPropertySet() {
    }

    public ApplicationPropertySet(String jsonString) throws ClassCastException {
        try {
            JSONObject mappings = (JSONObject)JSONValue.parse((String)jsonString);
            Set entries = mappings.entrySet();
            for (Map.Entry entry : entries) {
                String propName = (String)entry.getKey();
                ApplicationProperty prop = ApplicationProperty.getProperty((String)propName);
                if (null == prop) {
                    throw new IllegalArgumentException("Unrecognized application property name: " + propName);
                }
                Object value = entry.getValue();
                if (prop.isBooleanProperty()) {
                    if (null == value) {
                        this.setBoolProperty(prop, Boolean.FALSE.booleanValue());
                        continue;
                    }
                    if (value instanceof Boolean) {
                        this.setBoolProperty(prop, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (value instanceof Number) {
                        this.setBoolProperty(prop, !new Long(0L).equals(value));
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    this.setBoolProperty(prop, !"".equals(value));
                    continue;
                }
                if (!prop.isStringProperty()) continue;
                this.setStringProperty(prop, (CharSequence)((String)entry.getValue()));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void setBoolProperty(ApplicationProperty prop, boolean value) {
        if (null == prop || !prop.isBooleanProperty()) {
            throw new IllegalArgumentException("Boolean property expected");
        }
        if (null == this._attributesBool) {
            this._attributesBool = new HashMap();
        }
        this._attributesBool.put(prop, value);
    }

    public Boolean getBoolProperty(ApplicationProperty prop) {
        if (null == prop || !prop.isBooleanProperty()) {
            throw new IllegalArgumentException("Boolean property expected");
        }
        return null == this._attributesBool ? null : (Boolean)this._attributesBool.get(prop);
    }

    public void setStringProperty(ApplicationProperty prop, CharSequence value) {
        if (null == prop || !prop.isStringProperty()) {
            throw new IllegalArgumentException("String property expected");
        }
        if (null == this._attributesString) {
            this._attributesString = new HashMap();
        }
        this._attributesString.put(prop, value);
    }

    public CharSequence getStringProperty(ApplicationProperty prop) {
        if (null == prop || !prop.isStringProperty()) {
            throw new IllegalArgumentException("String property expected");
        }
        return null == this._attributesString ? null : (CharSequence)this._attributesString.get(prop);
    }

    public void removeProperty(ApplicationProperty prop) {
        if (prop.isBooleanProperty()) {
            this._attributesBool.remove(prop);
        } else if (prop.isStringProperty()) {
            this._attributesString.remove(prop);
        }
    }

    public boolean isEmpty() {
        return !(null != this._attributesString && !this._attributesString.isEmpty() || null != this._attributesBool && !this._attributesBool.isEmpty());
    }

    public JSONObject jsonify() {
        JSONObject ret = new JSONObject();
        if (null != this._attributesString) {
            for (Map.Entry entry : this._attributesString.entrySet()) {
                ret.put((Object)((ApplicationProperty)entry.getKey()).propertyName(), (Object)((Object)((CharSequence)entry.getValue())).toString());
            }
        }
        if (null != this._attributesBool) {
            for (Map.Entry entry : this._attributesBool.entrySet()) {
                ret.put((Object)((ApplicationProperty)entry.getKey()).propertyName(), entry.getValue());
            }
        }
        return ret;
    }

    public String toJsonString() {
        return this.jsonify().toString();
    }
}

