/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.ApplicationProperty;
import com.facebook.api.ApplicationPropertySet;
import com.facebook.api.FacebookException;
import com.facebook.api.FacebookMethod;
import com.facebook.api.FacebookSignatureUtil;
import com.facebook.api.IFacebookMethod;
import com.facebook.api.IFacebookRestClient;
import com.facebook.api.IFeedImage;
import com.facebook.api.MarketplaceListing;
import com.facebook.api.PageProfileField;
import com.facebook.api.Pair;
import com.facebook.api.PhotoTag;
import com.facebook.api.ProfileField;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class FacebookRestClient<T>
implements IFacebookRestClient<T> {
    public static URL SERVER_URL = null;
    public static URL HTTPS_SERVER_URL = null;
    protected final String _secret;
    protected final String _apiKey;
    protected final URL _serverUrl;
    protected String _sessionKey;
    protected boolean _isDesktop = false;
    protected int _userId = -1;
    protected String _sessionSecret;
    public static int NUM_AUTOAPPENDED_PARAMS;
    private static boolean DEBUG;
    protected Boolean _debug = null;
    protected File _uploadFile = null;
    protected static final String CRLF = "\r\n";
    protected static final String PREF = "--";
    protected static final int UPLOAD_BUFFER_SIZE = 512;
    public static final String MARKETPLACE_STATUS_DEFAULT = "DEFAULT";
    public static final String MARKETPLACE_STATUS_NOT_SUCCESS = "NOT_SUCCESS";
    public static final String MARKETPLACE_STATUS_SUCCESS = "SUCCESS";

    protected FacebookRestClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        this._sessionKey = sessionKey;
        this._apiKey = apiKey;
        this._secret = secret;
        this._serverUrl = null != serverUrl ? serverUrl : SERVER_URL;
    }

    public String getResponseFormat() {
        return null;
    }

    public T friends_areFriends(int userId1, int userId2) throws FacebookException, IOException {
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, new Pair[]{new Pair((Object)"uids1", (Object)Integer.toString(userId1)), new Pair((Object)"uids2", (Object)Integer.toString(userId2))});
    }

    public T friends_areFriends(Collection<Integer> userIds1, Collection<Integer> userIds2) throws FacebookException, IOException {
        if (userIds1 == null || userIds2 == null || userIds1.isEmpty() || userIds2.isEmpty()) {
            throw new IllegalArgumentException("Collections passed to friends_areFriends should not be null or empty");
        }
        if (userIds1.size() != userIds2.size()) {
            throw new IllegalArgumentException(String.format("Collections should be same size: got userIds1: %d elts; userIds2: %d elts", userIds1.size(), userIds2.size()));
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, new Pair[]{new Pair((Object)"uids1", (Object)FacebookRestClient.delimit(userIds1)), new Pair((Object)"uids2", (Object)FacebookRestClient.delimit(userIds2))});
    }

    public T profile_getFBML(Integer userId) throws FacebookException, IOException {
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, new Pair[]{new Pair((Object)"uid", (Object)Integer.toString(userId))});
    }

    public boolean fbml_refreshRefUrl(String url) throws FacebookException, IOException {
        return this.fbml_refreshRefUrl(new URL(url));
    }

    protected boolean feedHandler(IFacebookMethod feedMethod, CharSequence title, CharSequence body, Collection<IFeedImage> images, Integer priority) throws FacebookException, IOException {
        ArrayList<Pair> params = new ArrayList<Pair>(feedMethod.numParams());
        params.add(new Pair((Object)"title", (Object)title));
        if (null != body) {
            params.add(new Pair((Object)"body", (Object)body));
        }
        if (null != priority) {
            params.add(new Pair((Object)"priority", (Object)priority.toString()));
        }
        this.handleFeedImages(params, images);
        return this.extractBoolean(this.callMethod(feedMethod, params));
    }

    protected void handleFeedImages(List<Pair<String, CharSequence>> params, Collection<IFeedImage> images) {
        if (images != null && images.size() > 4) {
            throw new IllegalArgumentException("At most four images are allowed, got " + Integer.toString(images.size()));
        }
        if (null != images && !images.isEmpty()) {
            int image_count = 0;
            for (IFeedImage image : images) {
                ++image_count;
                String imageUrl = image.getImageUrlString();
                assert (null != imageUrl && "".equals(imageUrl)) : "Image URL must be provided";
                params.add((Pair<String, CharSequence>)new Pair((Object)String.format("image_%d", image_count), (Object)image.getImageUrlString()));
                assert (null != image.getLinkUrl()) : "Image link URL must be provided";
                params.add((Pair<String, CharSequence>)new Pair((Object)String.format("image_%d_link", image_count), (Object)image.getLinkUrl().toString()));
            }
        }
    }

    public boolean feed_publishActionOfUser(CharSequence title, CharSequence body, Collection<IFeedImage> images) throws FacebookException, IOException {
        return this.feedHandler((IFacebookMethod)FacebookMethod.FEED_PUBLISH_ACTION_OF_USER, title, body, images, null);
    }

    public boolean feed_publishActionOfUser(CharSequence title, CharSequence body) throws FacebookException, IOException {
        return this.feed_publishActionOfUser(title, body, null);
    }

    public abstract String auth_getSession(String var1) throws FacebookException, IOException;

    public boolean feed_publishStoryToUser(CharSequence title, CharSequence body) throws FacebookException, IOException {
        return this.feed_publishStoryToUser(title, body, null, null);
    }

    public boolean feed_publishStoryToUser(CharSequence title, CharSequence body, Collection<IFeedImage> images) throws FacebookException, IOException {
        return this.feed_publishStoryToUser(title, body, images, null);
    }

    public boolean feed_publishStoryToUser(CharSequence title, CharSequence body, Integer priority) throws FacebookException, IOException {
        return this.feed_publishStoryToUser(title, body, null, priority);
    }

    public boolean feed_publishStoryToUser(CharSequence title, CharSequence body, Collection<IFeedImage> images, Integer priority) throws FacebookException, IOException {
        return this.feedHandler((IFacebookMethod)FacebookMethod.FEED_PUBLISH_STORY_TO_USER, title, body, images, priority);
    }

    public boolean feed_publishTemplatizedAction(Integer actorId, CharSequence titleTemplate) throws FacebookException, IOException {
        if (null != actorId && actorId != this._userId) {
            throw new IllegalArgumentException("Actor ID parameter is deprecated");
        }
        return this.feed_publishTemplatizedAction(titleTemplate, null, null, null, null, null, null, null);
    }

    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(titleTemplate, null, null, null, null, null, null, null);
    }

    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Long pageActorId) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(titleTemplate, null, null, null, null, null, null, pageActorId);
    }

    public boolean feed_publishTemplatizedAction(Integer actorId, CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Integer> targetIds, Collection<IFeedImage> images) throws FacebookException, IOException {
        return this.feed_publishTemplatizedAction(titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, targetIds, images, null);
    }

    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Integer> targetIds, Collection<IFeedImage> images, Long pageActorId) throws FacebookException, IOException {
        assert (null != titleTemplate && !"".equals(titleTemplate));
        FacebookMethod method = FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION;
        ArrayList<Pair> params = new ArrayList<Pair>(method.numParams());
        params.add(new Pair((Object)"title_template", (Object)titleTemplate));
        if (null != titleData && !titleData.isEmpty()) {
            JSONObject titleDataJson = new JSONObject();
            titleDataJson.putAll(titleData);
            params.add(new Pair((Object)"title_data", (Object)titleDataJson.toString()));
        }
        if (null != bodyTemplate && !"".equals(bodyTemplate)) {
            params.add(new Pair((Object)"body_template", (Object)bodyTemplate));
            if (null != bodyData && !bodyData.isEmpty()) {
                JSONObject bodyDataJson = new JSONObject();
                bodyDataJson.putAll(bodyData);
                params.add(new Pair((Object)"body_data", (Object)bodyDataJson.toString()));
            }
        }
        if (null != bodyGeneral && !"".equals(bodyGeneral)) {
            params.add(new Pair((Object)"body_general", (Object)bodyGeneral));
        }
        if (null != targetIds && !targetIds.isEmpty()) {
            params.add(new Pair((Object)"target_ids", (Object)FacebookRestClient.delimit(targetIds)));
        }
        if (null != pageActorId) {
            params.add(new Pair((Object)"page_actor_id", (Object)pageActorId.toString()));
        }
        this.handleFeedImages(params, images);
        return this.extractBoolean(this.callMethod((IFacebookMethod)method, params));
    }

    public T groups_getMembers(Number groupId) throws FacebookException, IOException {
        assert (null != groupId);
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET_MEMBERS, new Pair[]{new Pair((Object)"gid", (Object)groupId.toString())});
    }

    private static String encode(CharSequence target) {
        String result = ((Object)target).toString();
        try {
            result = URLEncoder.encode(result, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.printf("Unsuccessful attempt to encode '%s' into UTF8", result);
        }
        return result;
    }

    public T events_getMembers(Number eventId) throws FacebookException, IOException {
        assert (null != eventId);
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_MEMBERS, new Pair[]{new Pair((Object)"eid", (Object)eventId.toString())});
    }

    public T friends_getAppUsers() throws FacebookException, IOException {
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_APP_USERS, new Pair[0]);
    }

    public T fql_query(CharSequence query) throws FacebookException, IOException {
        assert (null != query);
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.FQL_QUERY, new Pair[]{new Pair((Object)"query", (Object)query)});
    }

    private String generateSignature(List<String> params, boolean requiresSession) {
        String secret = this.isDesktop() && requiresSession ? this._sessionSecret : this._secret;
        return FacebookSignatureUtil.generateSignature(params, (String)secret);
    }

    public static void setDebugAll(boolean isDebug) {
        DEBUG = isDebug;
    }

    private static CharSequence delimit(Collection iterable) {
        if (iterable == null || iterable.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirst = false;
        for (Object item : iterable) {
            if (notFirst) {
                buffer.append(",");
            } else {
                notFirst = true;
            }
            buffer.append(item.toString());
        }
        return buffer;
    }

    protected T callMethod(IFacebookMethod method, Pair<String, CharSequence> ... paramPairs) throws FacebookException, IOException {
        return (T)this.callMethod(method, Arrays.asList(paramPairs));
    }

    public T photos_get(Long albumId, Collection<Long> photoIds) throws FacebookException, IOException {
        return (T)this.photos_get(null, albumId, photoIds);
    }

    public T photos_get(Collection<Long> photoIds) throws FacebookException, IOException {
        return (T)this.photos_get(null, null, photoIds);
    }

    public T photos_get(Integer subjId, Long albumId) throws FacebookException, IOException {
        return (T)this.photos_get(subjId, albumId, null);
    }

    public T photos_get(Integer subjId, Collection<Long> photoIds) throws FacebookException, IOException {
        return (T)this.photos_get(subjId, null, photoIds);
    }

    public T photos_get(Integer subjId) throws FacebookException, IOException {
        return (T)this.photos_get(subjId, null, null);
    }

    public T photos_get(Long albumId) throws FacebookException, IOException {
        return (T)this.photos_get(null, albumId, null);
    }

    public T photos_get(Integer subjId, Long albumId, Collection<Long> photoIds) throws FacebookException, IOException {
        boolean hasPhotoIds;
        ArrayList<Pair> params = new ArrayList<Pair>(FacebookMethod.PHOTOS_GET.numParams());
        boolean hasUserId = null != subjId && 0 != subjId;
        boolean hasAlbumId = null != albumId && 0L != albumId;
        boolean bl = hasPhotoIds = null != photoIds && !photoIds.isEmpty();
        if (!(hasUserId || hasAlbumId || hasPhotoIds)) {
            throw new IllegalArgumentException("At least one of photoIds, albumId, or subjId must be provided");
        }
        if (hasUserId) {
            params.add(new Pair((Object)"subj_id", (Object)Integer.toString(subjId)));
        }
        if (hasAlbumId) {
            params.add(new Pair((Object)"aid", (Object)Long.toString(albumId)));
        }
        if (hasPhotoIds) {
            params.add(new Pair((Object)"pids", (Object)FacebookRestClient.delimit(photoIds)));
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET, params);
    }

    public T users_getInfo(Collection<Integer> userIds, Set<CharSequence> fields) throws FacebookException, IOException {
        if (null == userIds) {
            throw new IllegalArgumentException("userIds cannot be null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields should not be empty");
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, new Pair[]{new Pair((Object)"uids", (Object)FacebookRestClient.delimit(userIds)), new Pair((Object)"fields", (Object)FacebookRestClient.delimit(fields))});
    }

    public T photos_getTags(Collection<Long> photoIds) throws FacebookException, IOException {
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_TAGS, new Pair[]{new Pair((Object)"pids", (Object)FacebookRestClient.delimit(photoIds))});
    }

    public T groups_get(Integer userId, Collection<Long> groupIds) throws FacebookException, IOException {
        boolean hasGroups;
        boolean bl = hasGroups = null != groupIds && !groupIds.isEmpty();
        if (null != userId) {
            return (T)(hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair[]{new Pair((Object)"uid", (Object)userId.toString()), new Pair((Object)"gids", (Object)FacebookRestClient.delimit(groupIds))}) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair[]{new Pair((Object)"uid", (Object)userId.toString())}));
        }
        return (T)(hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair[]{new Pair((Object)"gids", (Object)FacebookRestClient.delimit(groupIds))}) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair[0]));
    }

    protected T callMethod(IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException, IOException {
        HashMap<Object, Object> params = new HashMap<Object, Object>(2 * method.numTotalParams());
        params.put("method", method.methodName());
        params.put("api_key", this._apiKey);
        params.put("v", "1.0");
        String format = this.getResponseFormat();
        if (null != format) {
            params.put("format", format);
        }
        if (method.requiresSession()) {
            params.put("call_id", Long.toString(System.currentTimeMillis()));
            params.put("session_key", this._sessionKey);
        }
        for (Pair<String, CharSequence> p : paramPairs) {
            CharSequence oldVal = (CharSequence)params.put(p.first, p.second);
            if (oldVal == null) continue;
            System.err.printf("For parameter %s, overwrote old value %s with new value %s.", p.first, oldVal, p.second);
        }
        assert (!params.containsKey("sig"));
        String signature = this.generateSignature(FacebookSignatureUtil.convert(params.entrySet()), method.requiresSession());
        params.put("sig", signature);
        boolean doHttps = this.isDesktop() && FacebookMethod.AUTH_GET_SESSION.equals((Object)method);
        InputStream data = method.takesFile() ? this.postFileRequest(method.methodName(), params) : this.postRequest((CharSequence)method.methodName(), params, doHttps, true);
        return (T)this.parseCallResult(data, method);
    }

    protected abstract T parseCallResult(InputStream var1, IFacebookMethod var2) throws FacebookException, IOException;

    public boolean fbml_refreshRefUrl(URL url) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_REF_URL, new Pair[]{new Pair((Object)"url", (Object)url.toString())}));
    }

    public T notifications_get() throws FacebookException, IOException {
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_GET, new Pair[0]);
    }

    public T users_getInfo(Collection<Integer> userIds, EnumSet<ProfileField> fields) throws FacebookException, IOException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, new Pair[]{new Pair((Object)"uids", (Object)FacebookRestClient.delimit(userIds)), new Pair((Object)"fields", (Object)FacebookRestClient.delimit(fields))});
    }

    public int users_getLoggedInUser() throws FacebookException, IOException {
        Object result = this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_LOGGED_IN_USER, new Pair[0]);
        return this.extractInt(result);
    }

    public int auth_getUserId(String authToken) throws FacebookException, IOException {
        if (null == this._sessionKey) {
            this.auth_getSession(authToken);
        }
        return this._userId;
    }

    public boolean isDesktop() {
        return this._isDesktop;
    }

    private boolean photos_addTag(Long photoId, Double xPct, Double yPct, Integer taggedUserId, CharSequence tagText) throws FacebookException, IOException {
        assert (null != photoId && !photoId.equals(0));
        assert (null != taggedUserId || null != tagText);
        assert (null != xPct && xPct >= 0.0 && xPct <= 100.0);
        assert (null != yPct && yPct >= 0.0 && yPct <= 100.0);
        Object d = this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG, new Pair[]{new Pair((Object)"pid", (Object)photoId.toString()), new Pair((Object)"tag_uid", (Object)taggedUserId.toString()), new Pair((Object)"x", (Object)xPct.toString()), new Pair((Object)"y", (Object)yPct.toString())});
        return this.extractBoolean(d);
    }

    public boolean users_isAppAdded() throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_ADDED, new Pair[0]));
    }

    public boolean users_hasAppPermission(CharSequence permission) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_HAS_APP_PERMISSION, new Pair[]{new Pair((Object)"ext_perm", (Object)permission)}));
    }

    public boolean users_setStatus(String status) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS, new Pair[]{new Pair((Object)"status", (Object)status)}));
    }

    public boolean users_clearStatus() throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS, new Pair[]{new Pair((Object)"clear", (Object)"1")}));
    }

    public boolean photos_addTag(Long photoId, CharSequence tagText, Double xPct, Double yPct) throws FacebookException, IOException {
        return this.photos_addTag(photoId, xPct, yPct, null, tagText);
    }

    protected InputStream postFileRequest(String methodName, Map<String, CharSequence> params) throws IOException {
        assert (null != this._uploadFile);
        try {
            int i;
            BufferedInputStream bufin = new BufferedInputStream(new FileInputStream(this._uploadFile));
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            URLConnection con = SERVER_URL.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "multipart/form-data; charset=UTF-8; boundary=" + boundary);
            con.setRequestProperty("MIME-version", "1.0");
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            for (Map.Entry<String, CharSequence> entry : params.entrySet()) {
                out.writeBytes("--" + boundary + "\r\n");
                out.writeBytes("Content-disposition: form-data; name=\"" + entry.getKey() + "\"");
                out.writeBytes("\r\n\r\n");
                byte[] bytes = ((Object)entry.getValue()).toString().getBytes("UTF-8");
                out.write(bytes);
                out.writeBytes("\r\n");
            }
            out.writeBytes("--" + boundary + "\r\n");
            out.writeBytes("Content-disposition: form-data; filename=\"" + this._uploadFile.getName() + "\"" + "\r\n");
            out.writeBytes("Content-Type: image/jpeg\r\n");
            out.writeBytes("\r\n");
            byte[] b = new byte[512];
            int byteCounter = 0;
            while (-1 != (i = bufin.read(b))) {
                byteCounter += i;
                out.write(b, 0, i);
            }
            out.writeBytes("\r\n--" + boundary + "--" + "\r\n");
            out.flush();
            out.close();
            InputStream is = con.getInputStream();
            return is;
        }
        catch (Exception e) {
            this.logException(e);
            return null;
        }
    }

    protected final void logException(Exception e) {
        this.logException((CharSequence)"exception", e);
    }

    protected void logException(CharSequence msg, Exception e) {
        System.err.println(msg + ":" + e.getMessage());
        e.printStackTrace();
    }

    protected void log(CharSequence message) {
        System.out.println(message);
    }

    public boolean isDebug() {
        return null == this._debug ? DEBUG : this._debug;
    }

    public void notifications_send(Collection<Integer> recipientIds, CharSequence notification) throws FacebookException, IOException {
        assert (null != notification);
        ArrayList<Pair> args = new ArrayList<Pair>(3);
        if (null != recipientIds && !recipientIds.isEmpty()) {
            args.add(new Pair((Object)"to_ids", (Object)FacebookRestClient.delimit(recipientIds)));
        }
        args.add(new Pair((Object)"notification", (Object)notification));
        this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_SEND, args);
    }

    public void notifications_send(CharSequence notification) throws FacebookException, IOException {
        this.notifications_send(null, notification);
    }

    public String notifications_sendEmail(Collection<Integer> recipientIds, CharSequence subject, CharSequence fbml, CharSequence text) throws FacebookException, IOException {
        boolean hasFbml;
        if (null == recipientIds || recipientIds.isEmpty()) {
            throw new IllegalArgumentException("List of email recipients cannot be empty");
        }
        boolean hasText = null != text && 0 != text.length();
        boolean bl = hasFbml = null != fbml && 0 != fbml.length();
        if (!hasText && !hasFbml) {
            throw new IllegalArgumentException("Text and/or fbml must not be empty");
        }
        ArrayList<Pair> args = new ArrayList<Pair>(4);
        args.add(new Pair((Object)"recipients", (Object)FacebookRestClient.delimit(recipientIds)));
        args.add(new Pair((Object)"subject", (Object)subject));
        if (hasText) {
            args.add(new Pair((Object)"text", (Object)text));
        }
        if (hasFbml) {
            args.add(new Pair((Object)"fbml", (Object)fbml));
        }
        Object result = this.callMethod((IFacebookMethod)(this.isDesktop() ? FacebookMethod.NOTIFICATIONS_SEND_EMAIL : FacebookMethod.NOTIFICATIONS_SEND_EMAIL), args);
        return this.extractString(result);
    }

    public String notifications_sendEmail(Collection<Integer> recipientIds, CharSequence subject, CharSequence fbml) throws FacebookException, IOException {
        return this.notifications_sendEmail(recipientIds, subject, fbml, null);
    }

    public String notifications_sendEmailPlain(Collection<Integer> recipientIds, CharSequence subject, CharSequence text) throws FacebookException, IOException {
        return this.notifications_sendEmail(recipientIds, subject, null, text);
    }

    protected abstract URL extractURL(T var1) throws IOException;

    public boolean fbml_refreshImgSrc(String imageUrl) throws FacebookException, IOException {
        return this.fbml_refreshImgSrc(new URL(imageUrl));
    }

    public T photos_upload(File photo) throws FacebookException, IOException {
        return (T)this.photos_upload(photo, null, null);
    }

    public T photos_upload(File photo, String caption) throws FacebookException, IOException {
        return (T)this.photos_upload(photo, caption, null);
    }

    public T photos_upload(File photo, Long albumId) throws FacebookException, IOException {
        return (T)this.photos_upload(photo, null, albumId);
    }

    public T photos_upload(File photo, String caption, Long albumId) throws FacebookException, IOException {
        ArrayList<Pair> params = new ArrayList<Pair>(FacebookMethod.PHOTOS_UPLOAD.numParams());
        assert (photo.exists() && photo.canRead());
        this._uploadFile = photo;
        if (null != albumId) {
            params.add(new Pair((Object)"aid", (Object)Long.toString(albumId)));
        }
        if (null != caption) {
            params.add(new Pair((Object)"caption", (Object)caption));
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_UPLOAD, params);
    }

    public T photos_createAlbum(String albumName) throws FacebookException, IOException {
        return (T)this.photos_createAlbum(albumName, null, null);
    }

    public boolean photos_addTag(Long photoId, Integer taggedUserId, Double xPct, Double yPct) throws FacebookException, IOException {
        return this.photos_addTag(photoId, xPct, yPct, taggedUserId, null);
    }

    public T photos_addTags(Long photoId, Collection<PhotoTag> tags) throws FacebookException, IOException {
        assert (photoId > 0L);
        assert (null != tags && !tags.isEmpty());
        JSONArray jsonTags = new JSONArray();
        for (PhotoTag tag : tags) {
            jsonTags.add((Object)tag.jsonify());
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG, new Pair[]{new Pair((Object)"pid", (Object)photoId.toString()), new Pair((Object)"tags", (Object)jsonTags.toString())});
    }

    public void setIsDesktop(boolean isDesktop) {
        this._isDesktop = isDesktop;
    }

    public T events_get(Integer userId, Collection<Long> eventIds, Long startTime, Long endTime) throws FacebookException, IOException {
        boolean hasEnd;
        ArrayList<Pair> params = new ArrayList<Pair>(FacebookMethod.EVENTS_GET.numParams());
        boolean hasUserId = null != userId && 0 != userId;
        boolean hasEventIds = null != eventIds && !eventIds.isEmpty();
        boolean hasStart = null != startTime && 0L != startTime;
        boolean bl = hasEnd = null != endTime && 0L != endTime;
        if (hasUserId) {
            params.add(new Pair((Object)"uid", (Object)Integer.toString(userId)));
        }
        if (hasEventIds) {
            params.add(new Pair((Object)"eids", (Object)FacebookRestClient.delimit(eventIds)));
        }
        if (hasStart) {
            params.add(new Pair((Object)"start_time", (Object)startTime.toString()));
        }
        if (hasEnd) {
            params.add(new Pair((Object)"end_time", (Object)endTime.toString()));
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET, params);
    }

    public boolean profile_setFBML(CharSequence fbmlMarkup, Integer userId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_SET_FBML, new Pair[]{new Pair((Object)"uid", (Object)Integer.toString(userId)), new Pair((Object)"markup", (Object)fbmlMarkup)}));
    }

    public boolean profile_setProfileFBML(CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(fbmlMarkup, null, null, null);
    }

    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, fbmlMarkup, null, null);
    }

    public boolean profile_setMobileFBML(CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(null, null, fbmlMarkup, null);
    }

    public boolean profile_setProfileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(fbmlMarkup, null, null, profileId);
    }

    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(null, fbmlMarkup, null, profileId);
    }

    public boolean profile_setMobileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(null, null, fbmlMarkup, profileId);
    }

    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(profileFbmlMarkup, profileActionFbmlMarkup, null, null);
    }

    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, Long profileId) throws FacebookException, IOException {
        return this.profile_setFBML(profileFbmlMarkup, profileActionFbmlMarkup, null, profileId);
    }

    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup) throws FacebookException, IOException {
        return this.profile_setFBML(profileFbmlMarkup, profileActionFbmlMarkup, mobileFbmlMarkup, null);
    }

    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup, Long profileId) throws FacebookException, IOException {
        if (null == profileFbmlMarkup && null == profileActionFbmlMarkup && null == mobileFbmlMarkup) {
            throw new IllegalArgumentException("At least one of the FBML parameters must be provided");
        }
        if (this.isDesktop() && null != profileId && (long)this._userId != profileId) {
            throw new IllegalArgumentException("Can't set FBML for another user from desktop app");
        }
        FacebookMethod method = FacebookMethod.PROFILE_SET_FBML;
        ArrayList<Pair> params = new ArrayList<Pair>(method.numParams());
        if (null != profileId && !this.isDesktop()) {
            params.add(new Pair((Object)"uid", (Object)profileId.toString()));
        }
        if (null != profileFbmlMarkup) {
            params.add(new Pair((Object)"profile", (Object)profileFbmlMarkup));
        }
        if (null != profileActionFbmlMarkup) {
            params.add(new Pair((Object)"profile_action", (Object)profileActionFbmlMarkup));
        }
        if (null != mobileFbmlMarkup) {
            params.add(new Pair((Object)"mobile_fbml", (Object)mobileFbmlMarkup));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)method, params));
    }

    public boolean fbml_setRefHandle(CharSequence handle, CharSequence fbmlMarkup) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_SET_REF_HANDLE, new Pair[]{new Pair((Object)"handle", (Object)handle), new Pair((Object)"fbml", (Object)fbmlMarkup)}));
    }

    public boolean sms_canSend(Integer userId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.SMS_CAN_SEND, new Pair[]{new Pair((Object)"uid", (Object)userId.toString())}));
    }

    public void sms_sendResponse(Integer userId, CharSequence response, Integer mobileSessionId) throws FacebookException, IOException {
        this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, new Pair[]{new Pair((Object)"uid", (Object)userId.toString()), new Pair((Object)"message", (Object)response), new Pair((Object)"session_id", (Object)mobileSessionId.toString())});
    }

    public void sms_sendMessage(Integer userId, CharSequence message) throws FacebookException, IOException {
        this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, new Pair[]{new Pair((Object)"uid", (Object)userId.toString()), new Pair((Object)"message", (Object)message), new Pair((Object)"req_session", (Object)"0")});
    }

    public int sms_sendMessageWithSession(Integer userId, CharSequence message) throws FacebookException, IOException {
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, new Pair[]{new Pair((Object)"uid", (Object)userId.toString()), new Pair((Object)"message", (Object)message), new Pair((Object)"req_session", (Object)"1")}));
    }

    protected static CharSequence delimit(Collection<Map.Entry<String, CharSequence>> entries, CharSequence delimiter, CharSequence equals, boolean doEncode) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirst = false;
        for (Map.Entry<String, CharSequence> entry : entries) {
            if (notFirst) {
                buffer.append(delimiter);
            } else {
                notFirst = true;
            }
            CharSequence value = entry.getValue();
            buffer.append(entry.getKey()).append(equals).append(doEncode ? FacebookRestClient.encode((CharSequence)value) : value);
        }
        return buffer;
    }

    public T photos_createAlbum(String name, String description, String location) throws FacebookException, IOException {
        assert (null != name && !"".equals(name));
        ArrayList<Pair> params = new ArrayList<Pair>(FacebookMethod.PHOTOS_CREATE_ALBUM.numParams());
        params.add(new Pair((Object)"name", (Object)name));
        if (null != description) {
            params.add(new Pair((Object)"description", (Object)description));
        }
        if (null != location) {
            params.add(new Pair((Object)"location", (Object)location));
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_CREATE_ALBUM, params);
    }

    public void setDebug(boolean isDebug) {
        this._debug = isDebug;
    }

    protected boolean extractBoolean(T result) {
        return 1 == this.extractInt(result);
    }

    protected abstract int extractInt(T var1);

    protected abstract Long extractLong(T var1);

    public T photos_getAlbums(Collection<Long> albumIds) throws FacebookException, IOException {
        return (T)this.photos_getAlbums(null, albumIds);
    }

    public T photos_getAlbums(Integer userId) throws FacebookException, IOException {
        return (T)this.photos_getAlbums(userId, null);
    }

    public T photos_getAlbums(Integer userId, Collection<Long> albumIds) throws FacebookException, IOException {
        boolean hasAlbumIds;
        boolean hasUserId = null != userId && userId != 0;
        boolean bl = hasAlbumIds = null != albumIds && !albumIds.isEmpty();
        assert (hasUserId || hasAlbumIds);
        if (hasUserId) {
            return (T)(hasAlbumIds ? this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, new Pair[]{new Pair((Object)"uid", (Object)Integer.toString(userId)), new Pair((Object)"aids", (Object)FacebookRestClient.delimit(albumIds))}) : this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, new Pair[]{new Pair((Object)"uid", (Object)Integer.toString(userId))}));
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, new Pair[]{new Pair((Object)"aids", (Object)FacebookRestClient.delimit(albumIds))});
    }

    public boolean fbml_refreshImgSrc(URL imageUrl) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_IMG_SRC, new Pair[]{new Pair((Object)"url", (Object)imageUrl.toString())}));
    }

    public T friends_get() throws FacebookException, IOException {
        return (T)this.friends_get(null);
    }

    public T friends_get(Long friendListId) throws FacebookException, IOException {
        FacebookMethod method = FacebookMethod.FRIENDS_GET;
        ArrayList<Pair> params = new ArrayList<Pair>(method.numParams());
        if (null != friendListId) {
            if (0L >= friendListId) {
                throw new IllegalArgumentException("given invalid friendListId " + friendListId.toString());
            }
            params.add(new Pair((Object)"flid", (Object)friendListId.toString()));
        }
        return (T)this.callMethod((IFacebookMethod)method, params);
    }

    public T friends_getLists() throws FacebookException, IOException {
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_LISTS, new Pair[0]);
    }

    private InputStream postRequest(CharSequence method, Map<String, CharSequence> params, boolean doHttps, boolean doEncode) throws IOException {
        URL serverUrl;
        String buffer = null == params ? "" : FacebookRestClient.delimit(params.entrySet(), (CharSequence)"&", (CharSequence)"=", (boolean)doEncode);
        URL uRL = serverUrl = doHttps ? HTTPS_SERVER_URL : this._serverUrl;
        if (this.isDebug()) {
            StringBuilder debugMsg = new StringBuilder().append(method).append(" POST: ").append(serverUrl.toString()).append("?");
            debugMsg.append((CharSequence)buffer);
            this.log((CharSequence)debugMsg);
        }
        HttpURLConnection conn = (HttpURLConnection)serverUrl.openConnection();
        try {
            conn.setRequestMethod("POST");
        }
        catch (ProtocolException ex) {
            this.logException((Exception)ex);
        }
        conn.setDoOutput(true);
        conn.connect();
        conn.getOutputStream().write(buffer.toString().getBytes());
        return conn.getInputStream();
    }

    public String auth_createToken() throws FacebookException, IOException {
        Object d = this.callMethod((IFacebookMethod)FacebookMethod.AUTH_CREATE_TOKEN, new Pair[0]);
        return this.extractString(d);
    }

    protected abstract String extractString(T var1);

    public Long marketplace_createListing(Boolean showOnProfile, MarketplaceListing attrs) throws FacebookException, IOException {
        Object result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, new Pair[]{new Pair((Object)"show_on_profile", (Object)(showOnProfile != false ? "1" : "0")), new Pair((Object)"listing_id", (Object)"0"), new Pair((Object)"listing_attrs", (Object)attrs.jsonify().toString())});
        return this.extractLong(result);
    }

    public Long marketplace_editListing(Long listingId, Boolean showOnProfile, MarketplaceListing attrs) throws FacebookException, IOException {
        Object result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, new Pair[]{new Pair((Object)"show_on_profile", (Object)(showOnProfile != false ? "1" : "0")), new Pair((Object)"listing_id", (Object)listingId.toString()), new Pair((Object)"listing_attrs", (Object)attrs.jsonify().toString())});
        return this.extractLong(result);
    }

    public boolean marketplace_removeListing(Long listingId) throws FacebookException, IOException {
        return this.marketplace_removeListing(listingId, (CharSequence)"DEFAULT");
    }

    public boolean marketplace_removeListing(Long listingId, CharSequence status) throws FacebookException, IOException {
        assert ("DEFAULT".equals(status) || "SUCCESS".equals(status) || "NOT_SUCCESS".equals(status)) : "Invalid status: " + status;
        Object result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_REMOVE_LISTING, new Pair[]{new Pair((Object)"listing_id", (Object)listingId.toString()), new Pair((Object)"status", (Object)status)});
        return this.extractBoolean(result);
    }

    public T marketplace_getCategories() throws FacebookException, IOException {
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_CATEGORIES, new Pair[0]);
    }

    public T marketplace_getSubCategories(CharSequence category) throws FacebookException, IOException {
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_SUBCATEGORIES, new Pair[]{new Pair((Object)"category", (Object)category)});
    }

    public T marketplace_getListings(Collection<Long> listingIds, Collection<Integer> userIds) throws FacebookException, IOException {
        ArrayList<Pair> params = new ArrayList<Pair>(FacebookMethod.MARKETPLACE_GET_LISTINGS.numParams());
        if (null != listingIds && !listingIds.isEmpty()) {
            params.add(new Pair((Object)"listing_ids", (Object)FacebookRestClient.delimit(listingIds)));
        }
        if (null != userIds && !userIds.isEmpty()) {
            params.add(new Pair((Object)"uids", (Object)FacebookRestClient.delimit(userIds)));
        }
        assert (!params.isEmpty()) : "Either listingIds or userIds should be provided";
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_LISTINGS, params);
    }

    public T marketplace_search(CharSequence category, CharSequence subCategory, CharSequence query) throws FacebookException, IOException {
        ArrayList<Pair> params = new ArrayList<Pair>(FacebookMethod.MARKETPLACE_SEARCH.numParams());
        if (null != category && !"".equals(category)) {
            params.add(new Pair((Object)"category", (Object)category));
            if (null != subCategory && !"".equals(subCategory)) {
                params.add(new Pair((Object)"subcategory", (Object)subCategory));
            }
        }
        if (null != query && !"".equals(query)) {
            params.add(new Pair((Object)"query", (Object)category));
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_SEARCH, params);
    }

    public T pages_getInfo(Collection<Long> pageIds, EnumSet<PageProfileField> fields) throws FacebookException, IOException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        FacebookMethod method = null == this._sessionKey ? FacebookMethod.PAGES_GET_INFO_NO_SESSION : FacebookMethod.PAGES_GET_INFO;
        return (T)this.callMethod((IFacebookMethod)method, new Pair[]{new Pair((Object)"page_ids", (Object)FacebookRestClient.delimit(pageIds)), new Pair((Object)"fields", (Object)FacebookRestClient.delimit(fields))});
    }

    public T pages_getInfo(Collection<Long> pageIds, Set<CharSequence> fields) throws FacebookException, IOException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        FacebookMethod method = null == this._sessionKey ? FacebookMethod.PAGES_GET_INFO_NO_SESSION : FacebookMethod.PAGES_GET_INFO;
        return (T)this.callMethod((IFacebookMethod)method, new Pair[]{new Pair((Object)"page_ids", (Object)FacebookRestClient.delimit(pageIds)), new Pair((Object)"fields", (Object)FacebookRestClient.delimit(fields))});
    }

    public T pages_getInfo(Integer userId, EnumSet<PageProfileField> fields) throws FacebookException, IOException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this._userId;
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, new Pair[]{new Pair((Object)"uid", (Object)userId.toString()), new Pair((Object)"fields", (Object)FacebookRestClient.delimit(fields))});
    }

    public T pages_getInfo(Integer userId, Set<CharSequence> fields) throws FacebookException, IOException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this._userId;
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, new Pair[]{new Pair((Object)"uid", (Object)userId.toString()), new Pair((Object)"fields", (Object)FacebookRestClient.delimit(fields))});
    }

    public boolean pages_isAppAdded(Long pageId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_APP_ADDED, new Pair[]{new Pair((Object)"page_id", (Object)pageId.toString())}));
    }

    public boolean pages_isFan(Long pageId, Integer userId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, new Pair[]{new Pair((Object)"page_id", (Object)pageId.toString()), new Pair((Object)"uid", (Object)userId.toString())}));
    }

    public boolean pages_isFan(Long pageId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, new Pair[]{new Pair((Object)"page_id", (Object)pageId.toString())}));
    }

    public boolean pages_isAdmin(Long pageId) throws FacebookException, IOException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_ADMIN, new Pair[]{new Pair((Object)"page_id", (Object)pageId.toString())}));
    }

    public boolean admin_setAppProperties(ApplicationPropertySet properties) throws FacebookException, IOException {
        if (null == properties || properties.isEmpty()) {
            throw new IllegalArgumentException("expecting a non-empty set of application properties");
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, new Pair[]{new Pair((Object)"properties", (Object)properties.toJsonString())}));
    }

    public ApplicationPropertySet admin_getAppProperties(EnumSet<ApplicationProperty> properties) throws FacebookException, IOException {
        if (null == properties || properties.isEmpty()) {
            throw new IllegalArgumentException("expecting a non-empty set of application properties");
        }
        JSONArray propList = new JSONArray();
        for (ApplicationProperty prop : properties) {
            propList.add((Object)prop.propertyName());
        }
        String propJson = this.extractString(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_APP_PROPERTIES, new Pair[]{new Pair((Object)"properties", (Object)propList.toString())}));
        return new ApplicationPropertySet(propJson);
    }

    public T data_getCookies(Integer userId, CharSequence cookieName) throws FacebookException, IOException {
        ArrayList<Pair> params = new ArrayList<Pair>(FacebookMethod.DATA_GET_COOKIES.numParams());
        params.add(new Pair((Object)"uid", (Object)userId.toString()));
        if (null != cookieName) {
            params.add(new Pair((Object)"name", (Object)((Object)cookieName).toString()));
        }
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_COOKIES, params);
    }

    public T data_getCookies(Integer userId) throws FacebookException, IOException {
        return (T)this.data_getCookies(userId, null);
    }

    public boolean data_setCookie(Integer userId, CharSequence cookieName, CharSequence cookieValue) throws FacebookException, IOException {
        return this.data_setCookie(userId, cookieName, cookieValue, null, null);
    }

    public boolean data_setCookie(Integer userId, CharSequence cookieName, CharSequence cookieValue, CharSequence path) throws FacebookException, IOException {
        return this.data_setCookie(userId, cookieName, cookieValue, null, path);
    }

    public boolean data_setCookie(Integer userId, CharSequence cookieName, CharSequence cookieValue, Long expiresTimestamp) throws FacebookException, IOException {
        return this.data_setCookie(userId, cookieName, cookieValue, expiresTimestamp, null);
    }

    public boolean data_setCookie(Integer userId, CharSequence cookieName, CharSequence cookieValue, Long expiresTimestamp, CharSequence path) throws FacebookException, IOException {
        if (null == userId || 0 >= userId) {
            throw new IllegalArgumentException("userId should be provided.");
        }
        if (null == cookieName || null == cookieValue) {
            throw new IllegalArgumentException("cookieName and cookieValue should be provided.");
        }
        ArrayList<Pair> params = new ArrayList<Pair>(FacebookMethod.DATA_GET_COOKIES.numParams());
        params.add(new Pair((Object)"uid", (Object)userId.toString()));
        params.add(new Pair((Object)"name", (Object)cookieName));
        params.add(new Pair((Object)"value", (Object)cookieValue));
        if (null != expiresTimestamp && expiresTimestamp >= 0L) {
            params.add(new Pair((Object)"expires", (Object)expiresTimestamp.toString()));
        }
        if (null != path) {
            params.add(new Pair((Object)"path", (Object)path));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_COOKIES, params));
    }

    public boolean data_setUserPreference(Integer did, String value) throws FacebookException, IOException {
        ArrayList<Pair> params = new ArrayList<Pair>(2);
        params.add(new Pair((Object)"pref_id", (Object)did.toString()));
        params.add(new Pair((Object)"value", (Object)value));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_USERPREF, params));
    }

    public T data_getUserPreference(Integer did) throws FacebookException, IOException {
        ArrayList<Pair> params = new ArrayList<Pair>(1);
        params.add(new Pair((Object)"pref_id", (Object)did.toString()));
        return (T)this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_USERPREF, params);
    }

    static {
        try {
            SERVER_URL = new URL("http://api.facebook.com/restserver.php");
            HTTPS_SERVER_URL = new URL("https://api.facebook.com/restserver.php");
        }
        catch (MalformedURLException e) {
            System.err.println("MalformedURLException: " + e.getMessage());
            System.exit(1);
        }
        NUM_AUTOAPPENDED_PARAMS = 6;
        DEBUG = false;
    }
}

