/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.FacebookException;
import com.facebook.api.FacebookMethod;
import com.facebook.api.FacebookRestClient;
import com.facebook.api.IFacebookMethod;
import com.facebook.api.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FacebookXmlRestClient
extends FacebookRestClient<Document> {
    public FacebookXmlRestClient(String apiKey, String secret) {
        this(SERVER_URL, apiKey, secret, null);
    }

    public FacebookXmlRestClient(String apiKey, String secret, String sessionKey) {
        this(SERVER_URL, apiKey, secret, sessionKey);
    }

    public FacebookXmlRestClient(String serverAddr, String apiKey, String secret, String sessionKey) throws MalformedURLException {
        this(new URL(serverAddr), apiKey, secret, sessionKey);
    }

    public FacebookXmlRestClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        super(serverUrl, apiKey, secret, sessionKey);
    }

    public String getResponseFormat() {
        return "xml";
    }

    public String extractString(Document d) {
        return d.getFirstChild().getTextContent();
    }

    public String auth_getSession(String authToken) throws FacebookException, IOException {
        if (null != this._sessionKey) {
            return this._sessionKey;
        }
        Document d = (Document)this.callMethod((IFacebookMethod)FacebookMethod.AUTH_GET_SESSION, new Pair[]{new Pair((Object)"auth_token", (Object)authToken.toString())});
        this._sessionKey = d.getElementsByTagName("session_key").item(0).getFirstChild().getTextContent();
        this._userId = Integer.parseInt(d.getElementsByTagName("uid").item(0).getFirstChild().getTextContent());
        if (this._isDesktop) {
            this._sessionSecret = d.getElementsByTagName("secret").item(0).getFirstChild().getTextContent();
        }
        return this._sessionKey;
    }

    protected Document parseCallResult(InputStream data, IFacebookMethod method) throws FacebookException, IOException {
        try {
            NodeList errors;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(data);
            doc.normalizeDocument();
            FacebookXmlRestClient.stripEmptyTextNodes((Node)doc);
            if (this.isDebug()) {
                FacebookXmlRestClient.printDom((Node)doc, (String)(method.methodName() + "| "));
            }
            if ((errors = doc.getElementsByTagName("error_response")).getLength() > 0) {
                int errorCode = Integer.parseInt(errors.item(0).getFirstChild().getFirstChild().getTextContent());
                String message = errors.item(0).getFirstChild().getNextSibling().getTextContent();
                throw new FacebookException(errorCode, message);
            }
            return doc;
        }
        catch (ParserConfigurationException ex) {
            System.err.println("huh?" + ex);
        }
        catch (SAXException ex) {
            throw new IOException("error parsing xml");
        }
        return null;
    }

    protected URL extractURL(Document doc) throws IOException {
        String url = doc.getFirstChild().getTextContent();
        return null == url || "".equals(url) ? null : new URL(url);
    }

    protected int extractInt(Document doc) {
        return Integer.parseInt(doc.getFirstChild().getTextContent());
    }

    protected Long extractLong(Document doc) {
        return Long.parseLong(doc.getFirstChild().getTextContent());
    }

    private static void stripEmptyTextNodes(Node n) {
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node c = children.item(i);
            if (!c.hasChildNodes() && c.getNodeType() == 3 && c.getTextContent().trim().length() == 0) {
                n.removeChild(c);
                --i;
                --length;
                children = n.getChildNodes();
                continue;
            }
            FacebookXmlRestClient.stripEmptyTextNodes((Node)c);
        }
    }

    public static void printDom(Node n, String prefix) {
        String outString = prefix;
        outString = n.getNodeType() == 3 ? outString + "'" + n.getTextContent().trim() + "'" : outString + n.getNodeName();
        System.out.println(outString);
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            FacebookXmlRestClient.printDom((Node)children.item(i), (String)(prefix + "  "));
        }
    }
}

