/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.FacebookException;
import com.facebook.api.FacebookMethod;
import com.facebook.api.FacebookRestClient;
import com.facebook.api.IFacebookMethod;
import com.facebook.api.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookJsonRestClient
extends FacebookRestClient<Object> {
    public FacebookJsonRestClient(String apiKey, String secret) {
        this(SERVER_URL, apiKey, secret, null);
    }

    public FacebookJsonRestClient(String apiKey, String secret, String sessionKey) {
        this(SERVER_URL, apiKey, secret, sessionKey);
    }

    public FacebookJsonRestClient(String serverAddr, String apiKey, String secret, String sessionKey) throws MalformedURLException {
        this(new URL(serverAddr), apiKey, secret, sessionKey);
    }

    public FacebookJsonRestClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        super(serverUrl, apiKey, secret, sessionKey);
    }

    public String getResponseFormat() {
        return "json";
    }

    public String extractString(Object val) {
        try {
            return (String)val;
        }
        catch (ClassCastException cce) {
            this.logException((Exception)cce);
            return null;
        }
    }

    public String auth_getSession(String authToken) throws FacebookException, IOException {
        if (null != this._sessionKey) {
            return this._sessionKey;
        }
        JSONObject d = (JSONObject)this.callMethod((IFacebookMethod)FacebookMethod.AUTH_GET_SESSION, new Pair[]{new Pair((Object)"auth_token", (Object)authToken.toString())});
        this._sessionKey = (String)d.get((Object)"session_key");
        Object uid = d.get((Object)"uid");
        try {
            this._userId = ((Long)uid).intValue();
        }
        catch (ClassCastException cce) {
            this._userId = Integer.parseInt((String)uid);
        }
        if (this.isDesktop()) {
            this._sessionSecret = (String)d.get((Object)"secret");
        }
        return this._sessionKey;
    }

    protected Object parseCallResult(InputStream data, IFacebookMethod method) throws FacebookException, IOException {
        JSONObject jsonObj;
        Object json = JSONValue.parse((Reader)new InputStreamReader(data));
        if (this.isDebug()) {
            this.log((CharSequence)(method.methodName() + ": " + (null != json ? json.toString() : "null")));
        }
        if (json instanceof JSONObject && (jsonObj = (JSONObject)json).containsKey((Object)"error_code")) {
            Long errorCode = (Long)jsonObj.get((Object)"error_code");
            String message = (String)jsonObj.get((Object)"error_msg");
            throw new FacebookException(errorCode.intValue(), message);
        }
        return json;
    }

    protected URL extractURL(Object url) throws IOException {
        if (!(url instanceof String)) {
            return null;
        }
        return null == url || "".equals(url) ? null : new URL((String)url);
    }

    protected int extractInt(Object val) {
        try {
            return (Integer)val;
        }
        catch (ClassCastException cce) {
            this.logException((Exception)cce);
            return 0;
        }
    }

    protected boolean extractBoolean(Object val) {
        try {
            return (Boolean)val;
        }
        catch (ClassCastException cce) {
            this.logException((Exception)cce);
            return false;
        }
    }

    protected Long extractLong(Object val) {
        try {
            return (Long)val;
        }
        catch (ClassCastException cce) {
            this.logException((Exception)cce);
            return null;
        }
    }
}

