/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public enum FacebookParam implements CharSequence
{
    SIGNATURE,
    USER("user"),
    SESSION_KEY("session_key"),
    EXPIRES("expires"),
    IN_CANVAS("in_canvas"),
    IN_IFRAME("in_iframe"),
    IN_PROFILE("profile"),
    TIME("time"),
    FRIENDS("friends"),
    ADDED("added"),
    PROFILE_UPDATE_TIME("profile_update_time"),
    API_KEY("api_key");

    private static Map<String, FacebookParam> _lookupTable;
    private String _paramName;
    private String _signatureName;

    public static FacebookParam get(String key) {
        return FacebookParam.isInNamespace((String)key) ? (FacebookParam)_lookupTable.get(key) : null;
    }

    public static boolean isInNamespace(String key) {
        return null != key && key.startsWith(SIGNATURE.toString());
    }

    public static boolean isSignature(String key) {
        return SIGNATURE.equals((Object)FacebookParam.get((String)key));
    }

    private FacebookParam() {
        this._paramName = "fb_sig";
    }

    private FacebookParam(String name) {
        this._signatureName = name;
        this._paramName = "fb_sig_" + name;
    }

    @Override
    public char charAt(int index) {
        return this._paramName.charAt(index);
    }

    @Override
    public int length() {
        return this._paramName.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this._paramName.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this._paramName;
    }

    public String getSignatureName() {
        return this._signatureName;
    }

    public static String stripSignaturePrefix(String paramName) {
        if (paramName != null && paramName.startsWith("fb_sig_")) {
            return paramName.substring(7);
        }
        return paramName;
    }

    static {
        _lookupTable = new HashMap(FacebookParam.values().length);
        for (FacebookParam param : FacebookParam.values()) {
            _lookupTable.put(param.toString(), param);
        }
    }
}

