/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.example;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;

public class HttpCallInitiationServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger(HttpCallInitiationServlet.class);
    private SipFactory sipFactory;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.info((Object)"the servlet has been started");
        try {
            Properties jndiProps = new Properties();
            InitialContext initCtx = new InitialContext(jndiProps);
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            this.sipFactory = (SipFactory)envCtx.lookup("sip/FacebookClickToCallSip/SipFactory");
            logger.info((Object)("Sip Factory ref from JNDI : " + this.sipFactory));
        }
        catch (NamingException e) {
            throw new ServletException("Uh oh -- JNDI problem !", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String access = request.getParameter("access");
        String callAuthCode = this.getServletContext().getInitParameter("call.code");
        if (callAuthCode.equals(access)) {
            String toAddr = "sip:+" + request.getParameter("to").trim() + "@" + this.getServletContext().getInitParameter("domain.name");
            String fromAddr = "sip:" + this.getServletContext().getInitParameter("user1") + "@" + this.getServletContext().getInitParameter("domain.name");
            String secondParty = "sip:+" + request.getParameter("from").trim() + "@" + this.getServletContext().getInitParameter("domain.name");
            URI to = toAddr == null ? null : this.sipFactory.createAddress(toAddr).getURI();
            URI from = fromAddr == null ? null : this.sipFactory.createAddress(fromAddr).getURI();
            SipApplicationSession appSession = this.sipFactory.createApplicationSession();
            SipServletRequest req = this.sipFactory.createRequest(appSession, "INVITE", from, to);
            req.getSession().setAttribute("SecondPartyAddress", (Object)this.sipFactory.createAddress(secondParty));
            req.getSession().setAttribute("FromAddr", (Object)this.sipFactory.createAddress(fromAddr));
            req.getSession().setAttribute("user", (Object)this.getServletContext().getInitParameter("user1"));
            req.getSession().setAttribute("pass", (Object)this.getServletContext().getInitParameter("pass1"));
            logger.info((Object)("Sending request" + req));
            req.send();
        }
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<HTML><META HTTP-EQUIV=\"Refresh\"CONTENT=\"0; URL=index.jsp\"><HEAD><TITLE></HTML>");
        out.close();
    }
}

