/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.example;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import org.apache.log4j.Logger;

public class Sip3pccHandlerServlet
extends SipServlet
implements SipErrorListener,
Servlet {
    private static Logger logger = Logger.getLogger(Sip3pccHandlerServlet.class);
    private static final String CONTACT_HEADER = "Contact";
    private SipFactory sipFactory;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        logger.info((Object)"the simple sip servlet has been started");
        try {
            Properties jndiProps = new Properties();
            InitialContext initCtx = new InitialContext(jndiProps);
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            this.sipFactory = (SipFactory)envCtx.lookup("sip/FacebookClickToCallSip/SipFactory");
            logger.info((Object)("Sip Factory ref from JNDI : " + this.sipFactory));
        }
        catch (NamingException e) {
            throw new ServletException("Uh oh -- JNDI problem !", (Throwable)e);
        }
    }

    protected void doInvite(SipServletRequest req) throws ServletException, IOException {
        logger.info((Object)("Click2Dial don't handle INVITE. Here's the one we got :  " + req.toString()));
    }

    protected void doOptions(SipServletRequest req) throws ServletException, IOException {
        logger.info((Object)("Got :  " + req.toString()));
        req.createResponse(200).send();
    }

    protected void doSuccessResponse(SipServletResponse resp) throws ServletException, IOException {
        logger.info((Object)"Got OK");
        SipSession session = resp.getSession();
        if (resp.getStatus() == 200) {
            Boolean inviteSent = (Boolean)session.getAttribute("InviteSent");
            if (inviteSent != null && inviteSent.booleanValue()) {
                return;
            }
            if (resp.getSession().getAttribute("OK") != null) {
                return;
            }
            resp.getSession().setAttribute("OK", (Object)new Boolean(true));
            Address secondPartyAddress = (Address)resp.getSession().getAttribute("SecondPartyAddress");
            String fromAddr = "sip:" + this.getServletContext().getInitParameter("user2") + "@" + this.getServletContext().getInitParameter("domain.name");
            Address fromAddress = this.sipFactory.createAddress(fromAddr);
            if (secondPartyAddress != null) {
                SipApplicationSession newCallId = this.sipFactory.createApplicationSession();
                SipServletRequest invite = this.sipFactory.createRequest(newCallId, "INVITE", fromAddress, secondPartyAddress);
                logger.info((Object)("Found second party -- sending INVITE to " + secondPartyAddress));
                String contentType = resp.getContentType();
                if (contentType.trim().equals("application/sdp")) {
                    invite.setContent(resp.getContent(), "application/sdp");
                }
                invite.getSession().setAttribute("user", (Object)this.getServletContext().getInitParameter("user2"));
                invite.getSession().setAttribute("pass", (Object)this.getServletContext().getInitParameter("pass2"));
                session.setAttribute("LinkedSession", (Object)invite.getSession());
                invite.getSession().setAttribute("LinkedSession", (Object)session);
                SipServletRequest ack = resp.createAck();
                invite.getSession().setAttribute("FirstPartyAck", (Object)ack);
                invite.getSession().setAttribute("FirstPartyContent", resp.getContent());
                invite.send();
                session.setAttribute("InviteSent", (Object)Boolean.TRUE);
            } else {
                System.out.println("DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD");
                String cSeqValue = resp.getHeader("CSeq");
                if (cSeqValue.indexOf("INVITE") != -1) {
                    logger.info((Object)"Got OK from second party -- sending ACK");
                    SipServletRequest secondPartyAck = resp.createAck();
                    SipServletRequest firstPartyAck = (SipServletRequest)resp.getSession().getAttribute("FirstPartyAck");
                    firstPartyAck.setContent(resp.getContent(), "application/sdp");
                    secondPartyAck.setContent(resp.getSession().getAttribute("FirstPartyContent"), "application/sdp");
                    firstPartyAck.send();
                    secondPartyAck.send();
                }
            }
        }
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)"Got bye");
        SipSession session = request.getSession();
        SipSession linkedSession = (SipSession)session.getAttribute("LinkedSession");
        if (linkedSession != null) {
            SipServletRequest bye = linkedSession.createRequest("BYE");
            logger.info((Object)("Sending bye to " + linkedSession.getRemoteParty()));
            bye.send();
        }
        SipServletResponse ok = request.createResponse(200);
        ok.send();
    }

    protected void doResponse(SipServletResponse response) throws ServletException, IOException {
        logger.info((Object)("SimpleProxyServlet: Got response:\n" + response));
        super.doResponse(response);
    }

    protected void doErrorResponse(SipServletResponse response) throws ServletException, IOException {
        logger.info((Object)("Got response: " + response));
        SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        if (!(response.getStatus() != 401 && response.getStatus() != 407 || "true".equals(response.getApplicationSession().getAttribute("FirstResponseRecieved")))) {
            SipApplicationSession sipApplicationSession = response.getApplicationSession();
            sipApplicationSession.setAttribute("FirstResponseRecieved", (Object)"true");
            AuthInfo authInfo = sipFactory.createAuthInfo();
            authInfo.addAuthInfo(response.getStatus(), (String)response.getChallengeRealms().next(), (String)response.getSession().getAttribute("user"), (String)response.getSession().getAttribute("pass"));
            SipServletRequest challengeRequest = response.getSession().createRequest(response.getRequest().getMethod());
            challengeRequest.addAuthHeader(response, authInfo);
            logger.info((Object)("Sending the challenge request " + challengeRequest));
            try {
                logger.info((Object)("sending challenge request " + challengeRequest));
                challengeRequest.send();
            }
            catch (IOException e) {
                logger.error((Object)"An unexpected exception occured while sending the request", (Throwable)e);
            }
        }
    }

    public void noAckReceived(SipErrorEvent ee) {
        logger.info((Object)"SimpleProxyServlet: Error: noAckReceived.");
    }

    public void noPrackReceived(SipErrorEvent ee) {
        logger.info((Object)"SimpleProxyServlet: Error: noPrackReceived.");
    }

    protected void doRegister(SipServletRequest req) throws ServletException, IOException {
        logger.info((Object)("Received register request: " + req.getTo()));
        int response = 200;
        SipServletResponse resp = req.createResponse(response);
        HashMap<String, String> users = (HashMap<String, String>)this.getServletContext().getAttribute("registeredUsersMap");
        if (users == null) {
            users = new HashMap<String, String>();
        }
        this.getServletContext().setAttribute("registeredUsersMap", users);
        Address address = req.getAddressHeader(CONTACT_HEADER);
        String fromURI = req.getFrom().getURI().toString();
        int expires = address.getExpires();
        if (expires < 0) {
            expires = req.getExpires();
        }
        if (expires == 0) {
            users.remove(fromURI);
            logger.info((Object)("User " + fromURI + " unregistered"));
        } else {
            resp.setAddressHeader(CONTACT_HEADER, address);
            users.put(fromURI, address.getURI().toString());
            logger.info((Object)("User " + fromURI + " registered with an Expire time of " + expires));
        }
        resp.send();
    }
}

