/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShootistSipServlet
extends SipServlet
implements SipServletListener {
    private static Log logger = LogFactory.getLog(ShootistSipServlet.class);

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the shootist has been started");
        super.init(servletConfig);
    }

    protected void doSuccessResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
        logger.info((Object)("Got : " + sipServletResponse.getStatus() + " " + sipServletResponse.getMethod()));
        int status = sipServletResponse.getStatus();
        if (status == 200 && "INVITE".equalsIgnoreCase(sipServletResponse.getMethod())) {
            SipServletRequest ackRequest = sipServletResponse.createAck();
            ackRequest.send();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"unexpected exception", (Throwable)e);
            }
            SipServletRequest sipServletRequest = sipServletResponse.getSession().createRequest("BYE");
            sipServletRequest.send();
        }
    }

    public void servletInitialized(SipServletContextEvent ce) {
        SipFactory sipFactory = (SipFactory)ce.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        SipApplicationSession sipApplicationSession = sipFactory.createApplicationSession();
        SipURI fromURI = sipFactory.createSipURI("BigGuy", "here.com");
        SipURI toURI = null;
        if (ce.getServletContext().getInitParameter("urlType") != null && ce.getServletContext().getInitParameter("urlType").equalsIgnoreCase("tel")) {
            try {
                toURI = sipFactory.createURI("tel:+358-555-1234567");
            }
            catch (ServletParseException e) {
                logger.error((Object)"Impossible to create the tel URL", (Throwable)e);
            }
        } else {
            toURI = sipFactory.createSipURI("LittleGuy", "there.com");
        }
        SipServletRequest sipServletRequest = sipFactory.createRequest(sipApplicationSession, "INVITE", (URI)fromURI, (URI)toURI);
        SipURI requestURI = sipFactory.createSipURI("LittleGuy", "127.0.0.1:5080");
        sipServletRequest.setRequestURI((URI)requestURI);
        try {
            sipServletRequest.send();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }
}

