/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.jca.impl;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.activemq.jca.impl.JCADtdResolver;
import org.codehaus.activemq.spring.ConfigurationParseException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class JCABeanDefinitionReader
extends XmlBeanDefinitionReader {
    public JCABeanDefinitionReader(BeanDefinitionRegistry beanDefinitionRegistry) {
        super(beanDefinitionRegistry);
        this.setEntityResolver(this.createEntityResolver());
    }

    public int registerBeanDefinitions(Document document, Resource resource) throws BeansException {
        try {
            Document newDocument = this.transformDocument(document);
            return super.registerBeanDefinitions(newDocument, resource);
        }
        catch (Exception e) {
            throw new ConfigurationParseException(resource, (Throwable)e);
        }
    }

    public static Transformer createTransformer(Source source) throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(source);
        transformer.setURIResolver(new URIResolver(){

            public Source resolve(String href, String base) {
                System.out.println("Called with href:  " + href + " base: " + base);
                return null;
            }
        });
        return transformer;
    }

    protected Document transformDocument(Document document) throws IOException, TransformerException {
        Transformer transformer = JCABeanDefinitionReader.createTransformer(this.createXslSource());
        DOMResult result = new DOMResult();
        transformer.transform(new DOMSource(document), result);
        return (Document)result.getNode();
    }

    protected Source createXslSource() throws IOException {
        return new StreamSource(this.getXslResource().getInputStream(), this.getXslResource().getURL().toString());
    }

    protected ClassPathResource getXslResource() {
        return new ClassPathResource("org/codehaus/activemq/mdo/mdo-to-spring.xsl");
    }

    protected EntityResolver createEntityResolver() {
        return new JCADtdResolver();
    }
}

