/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.broker;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.message.BrokerInfo;
import org.codehaus.activemq.message.ConnectionInfo;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.DurableUnsubscribe;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.ProducerInfo;
import org.codehaus.activemq.message.SessionInfo;
import org.codehaus.activemq.service.Service;
import org.codehaus.activemq.transport.TransportServerChannel;

public interface BrokerConnector
extends Service {
    public BrokerInfo getBrokerInfo();

    public TransportServerChannel getServerChannel();

    public int getBrokerCapacity();

    public void registerClient(BrokerClient var1, ConnectionInfo var2) throws JMSException;

    public void deregisterClient(BrokerClient var1, ConnectionInfo var2) throws JMSException;

    public void registerMessageConsumer(BrokerClient var1, ConsumerInfo var2) throws JMSException;

    public void deregisterMessageConsumer(BrokerClient var1, ConsumerInfo var2) throws JMSException;

    public void registerMessageProducer(BrokerClient var1, ProducerInfo var2) throws JMSException;

    public void deregisterMessageProducer(BrokerClient var1, ProducerInfo var2) throws JMSException;

    public void registerSession(BrokerClient var1, SessionInfo var2) throws JMSException;

    public void deregisterSession(BrokerClient var1, SessionInfo var2) throws JMSException;

    public void startTransaction(BrokerClient var1, String var2) throws JMSException;

    public void rollbackTransaction(BrokerClient var1, String var2) throws JMSException;

    public void commitTransaction(BrokerClient var1, String var2) throws JMSException;

    public void startTransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public ActiveMQXid[] getPreparedTransactions(BrokerClient var1) throws XAException;

    public int prepareTransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public void rollbackTransaction(BrokerClient var1, ActiveMQXid var2) throws XAException;

    public void commitTransaction(BrokerClient var1, ActiveMQXid var2, boolean var3) throws XAException;

    public void sendMessage(BrokerClient var1, ActiveMQMessage var2) throws JMSException;

    public void acknowledgeMessage(BrokerClient var1, MessageAck var2) throws JMSException;

    public void durableUnsubscribe(BrokerClient var1, DurableUnsubscribe var2) throws JMSException;

    public String getResourceManagerId(BrokerClient var1);

    public BrokerContainer getBrokerContainer();
}

