/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.broker.impl;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.ThreadedExecutor;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerAdmin;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.broker.BrokerConnector;
import org.codehaus.activemq.message.AbstractPacket;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.message.BrokerAdminCommand;
import org.codehaus.activemq.message.BrokerInfo;
import org.codehaus.activemq.message.CapacityInfo;
import org.codehaus.activemq.message.CleanupConnectionInfo;
import org.codehaus.activemq.message.ConnectionInfo;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.DurableUnsubscribe;
import org.codehaus.activemq.message.IntResponseReceipt;
import org.codehaus.activemq.message.KeepAlive;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.PacketListener;
import org.codehaus.activemq.message.ProducerInfo;
import org.codehaus.activemq.message.Receipt;
import org.codehaus.activemq.message.ResponseReceipt;
import org.codehaus.activemq.message.SessionInfo;
import org.codehaus.activemq.message.TransactionInfo;
import org.codehaus.activemq.message.XATransactionInfo;
import org.codehaus.activemq.message.util.SpooledBoundedActiveMQMessageQueue;
import org.codehaus.activemq.transport.NetworkChannel;
import org.codehaus.activemq.transport.NetworkConnector;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.util.IdGenerator;

public class BrokerClientImpl
implements BrokerClient,
ExceptionListener,
PacketListener {
    private static final Log log = LogFactory.getLog((Class)BrokerClientImpl.class);
    private BrokerConnector brokerConnector;
    private TransportChannel channel;
    private ConnectionInfo connectionInfo;
    private IdGenerator packetIdGenerator;
    private SynchronizedBoolean closed;
    private Set activeConsumers;
    private CopyOnWriteArrayList consumers;
    private CopyOnWriteArrayList producers;
    private CopyOnWriteArrayList transactions;
    private CopyOnWriteArrayList sessions;
    private SynchronizedBoolean started;
    private boolean brokerConnection;
    private boolean clusteredConnection;
    private String remoteBrokerName;
    private int capacity = 100;
    private SpooledBoundedActiveMQMessageQueue spoolQueue;
    private boolean cleanedUp;
    private boolean registered;
    private ArrayList dispatchQueue = new ArrayList();
    private Subject subject;
    private boolean remoteNetworkConnector;

    public BrokerClientImpl() {
        this.packetIdGenerator = new IdGenerator();
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
        this.activeConsumers = new HashSet();
        this.consumers = new CopyOnWriteArrayList();
        this.producers = new CopyOnWriteArrayList();
        this.transactions = new CopyOnWriteArrayList();
        this.sessions = new CopyOnWriteArrayList();
    }

    public void initialize(BrokerConnector brokerConnector, TransportChannel channel) {
        this.brokerConnector = brokerConnector;
        this.channel = channel;
        this.channel.setPacketListener(this);
        this.channel.setExceptionListener(this);
        log.trace((Object)"brokerConnectorConnector client initialized");
    }

    public BrokerConnector getBrokerConnector() {
        return this.brokerConnector;
    }

    public void onException(JMSException jmsEx) {
        log.info((Object)("Client disconnected: " + this));
        log.debug((Object)"Disconnect cuase: ", (Throwable)jmsEx);
        this.close();
    }

    public String toString() {
        String str = "brokerConnector-client:(" + this.hashCode() + ") ";
        str = str + (this.connectionInfo == null ? "" : this.connectionInfo.getClientId());
        str = str + ": " + this.channel;
        return str;
    }

    public void dispatch(ActiveMQMessage message) {
        if (!this.isSlowConsumer()) {
            this.dispatchToClient(message);
        } else {
            if (this.spoolQueue == null) {
                log.warn((Object)("Connection: " + this.connectionInfo.getClientId() + " is a slow consumer"));
                String spoolName = this.brokerConnector.getBrokerInfo().getBrokerName() + "_" + this.connectionInfo.getClientId();
                try {
                    final SpooledBoundedActiveMQMessageQueue bpq = this.spoolQueue = new SpooledBoundedActiveMQMessageQueue(this.brokerConnector.getBrokerContainer().getBroker().getTempDir(), spoolName);
                    ThreadedExecutor exec = new ThreadedExecutor();
                    exec.execute(new Runnable(){

                        public void run() {
                            while (!BrokerClientImpl.this.closed.get()) {
                                try {
                                    ActiveMQMessage packet = bpq.dequeue();
                                    if (packet == null) continue;
                                    BrokerClientImpl.this.dispatchToClient(packet);
                                }
                                catch (InterruptedException e) {
                                    log.warn((Object)"async dispatch got an interupt", (Throwable)e);
                                }
                                catch (JMSException e) {
                                    log.error((Object)"async dispatch got an problem", (Throwable)e);
                                }
                            }
                        }
                    });
                }
                catch (IOException e) {
                    log.error((Object)"Could not create SpooledBoundedQueue for this slow consumer", (Throwable)e);
                    this.close();
                }
                catch (InterruptedException e) {
                    log.error((Object)"Could not create SpooledBoundedQueue for this slow consumer", (Throwable)e);
                    this.close();
                }
            }
            if (this.spoolQueue != null) {
                try {
                    this.spoolQueue.enqueue(message);
                }
                catch (JMSException e) {
                    log.error((Object)("Could not enqueue message " + message + " to SpooledBoundedQueue for this slow consumer"), (Throwable)e);
                    this.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchToClient(Packet message) {
        if (this.started.get()) {
            this.send(message);
        } else {
            SynchronizedBoolean synchronizedBoolean = this.started;
            synchronized (synchronizedBoolean) {
                this.dispatchQueue.add(message);
            }
        }
    }

    public boolean isBrokerConnection() {
        return this.brokerConnection;
    }

    public boolean isClusteredConnection() {
        return this.clusteredConnection;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public String getClientID() {
        if (this.connectionInfo != null) {
            return this.connectionInfo.getClientId();
        }
        return null;
    }

    public TransportChannel getChannel() {
        return this.channel;
    }

    public boolean isSlowConsumer() {
        return this.capacity <= 20;
    }

    public void consume(Packet packet) {
        if (packet != null) {
            Throwable requestEx = null;
            boolean failed = false;
            boolean receiptRequired = packet.isReceiptRequired();
            short correlationId = packet.getId();
            String brokerName = this.brokerConnector.getBrokerInfo().getBrokerName();
            String clusterName = this.brokerConnector.getBrokerInfo().getClusterName();
            try {
                if (this.brokerConnection) {
                    packet.addBrokerVisited(this.remoteBrokerName);
                    packet.addBrokerVisited(brokerName);
                }
                if (packet.isJMSMessage()) {
                    ActiveMQMessage message = (ActiveMQMessage)packet;
                    if (!this.brokerConnection) {
                        message.setEntryBrokerName(brokerName);
                        message.setEntryClusterName(clusterName);
                    }
                    this.consumeActiveMQMessage(message);
                } else {
                    switch (packet.getPacketType()) {
                        case 15: {
                            MessageAck ack = (MessageAck)packet;
                            this.consumeMessageAck(ack);
                            break;
                        }
                        case 20: {
                            XATransactionInfo info = (XATransactionInfo)packet;
                            this.consumeXATransactionInfo(info);
                            break;
                        }
                        case 19: {
                            TransactionInfo info = (TransactionInfo)packet;
                            this.consumeTransactionInfo(info);
                            break;
                        }
                        case 17: {
                            ConsumerInfo info = (ConsumerInfo)packet;
                            this.consumeConsumerInfo(info);
                            break;
                        }
                        case 18: {
                            ProducerInfo info = (ProducerInfo)packet;
                            this.consumeProducerInfo(info);
                            break;
                        }
                        case 23: {
                            SessionInfo info = (SessionInfo)packet;
                            this.consumeSessionInfo(info);
                            break;
                        }
                        case 22: {
                            ConnectionInfo info = (ConnectionInfo)packet;
                            this.consumeConnectionInfo(info);
                            break;
                        }
                        case 24: {
                            DurableUnsubscribe ds = (DurableUnsubscribe)packet;
                            this.brokerConnector.durableUnsubscribe(this, ds);
                            break;
                        }
                        case 27: {
                            CapacityInfo info = (CapacityInfo)packet;
                            this.consumeCapacityInfo(info);
                            break;
                        }
                        case 28: {
                            this.updateCapacityInfo(packet.getId());
                            break;
                        }
                        case 21: {
                            this.consumeBrokerInfo((BrokerInfo)packet);
                            break;
                        }
                        case 30: {
                            break;
                        }
                        case 31: {
                            this.consumeBrokerAdminCommand((BrokerAdminCommand)packet);
                            break;
                        }
                        case 33: {
                            this.consumeCleanupConnectionInfo((CleanupConnectionInfo)packet);
                            break;
                        }
                        default: {
                            log.warn((Object)("Unknown Packet received: " + packet));
                        }
                    }
                }
            }
            catch (Throwable e) {
                requestEx = e;
                log.warn((Object)("caught exception consuming packet: " + packet), e);
                failed = true;
            }
            if (receiptRequired) {
                this.sendReceipt(correlationId, requestEx, failed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeCleanupConnectionInfo(CleanupConnectionInfo cleanupInfo) throws JMSException {
        try {
            AbstractPacket info;
            Iterator i = this.consumers.iterator();
            while (i.hasNext()) {
                info = (ConsumerInfo)i.next();
                ((ConsumerInfo)info).setStarted(false);
                this.brokerConnector.deregisterMessageConsumer(this, (ConsumerInfo)info);
            }
            i = this.producers.iterator();
            while (i.hasNext()) {
                info = (ProducerInfo)i.next();
                ((ProducerInfo)info).setStarted(false);
                this.brokerConnector.deregisterMessageProducer(this, (ProducerInfo)info);
            }
            i = this.sessions.iterator();
            while (i.hasNext()) {
                info = (SessionInfo)i.next();
                ((SessionInfo)info).setStarted(false);
                this.brokerConnector.deregisterSession(this, (SessionInfo)info);
            }
            i = this.transactions.iterator();
            while (i.hasNext()) {
                this.brokerConnector.rollbackTransaction((BrokerClient)this, i.next().toString());
            }
            this.brokerConnector.deregisterClient(this, this.connectionInfo);
            this.registered = false;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " has stopped"));
            }
            this.consumers.clear();
            this.producers.clear();
            this.transactions.clear();
            this.sessions.clear();
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " has stopped"));
        }
        this.consumers.clear();
        this.producers.clear();
        this.transactions.clear();
        this.sessions.clear();
    }

    private void consumeBrokerAdminCommand(BrokerAdminCommand command) throws JMSException {
        BrokerAdmin brokerAdmin = this.brokerConnector.getBrokerContainer().getBroker().getBrokerAdmin();
        if ("CREATE_DESTINATION".equals(command.getCommand())) {
            brokerAdmin.createMessageContainer(command.getDestination());
        } else if ("DESTROY_DESTINATION".equals(command.getCommand())) {
            brokerAdmin.destoryMessageContainer(command.getDestination());
        } else if ("EMPTY_DESTINATION".equals(command.getCommand())) {
            brokerAdmin.getMessageContainerAdmin(command.getDestination()).empty();
        } else {
            throw new JMSException("Broker Admin Command type: " + command.getCommand() + " not recognized.");
        }
    }

    public void consumeConsumerInfo(ConsumerInfo info) throws JMSException {
        String localBrokerName = this.brokerConnector.getBrokerInfo().getBrokerName();
        if (info.isStarted()) {
            this.consumers.add((Object)info);
            if (this.activeConsumers.add(info)) {
                this.brokerConnector.registerMessageConsumer(this, info);
            }
        } else {
            this.consumers.remove((Object)info);
            if (this.activeConsumers.remove(info)) {
                this.brokerConnector.deregisterMessageConsumer(this, info);
            }
        }
    }

    public void updateBrokerCapacity(int capacity) {
        CapacityInfo info = new CapacityInfo();
        info.setResourceName(this.brokerConnector.getBrokerInfo().getBrokerName());
        info.setCapacity(capacity);
        info.setFlowControlTimeout(this.getFlowControlTimeout(capacity));
        this.send(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeConnectionInfo(ConnectionInfo info) throws JMSException {
        this.connectionInfo = info;
        if (info.isClosed()) {
            try {
                this.cleanUp();
                if (info.isReceiptRequired()) {
                    this.sendReceipt(info.getId(), null, false);
                }
                info.setReceiptRequired(false);
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                this.close();
            }
        } else {
            if (!this.registered) {
                this.brokerConnector.registerClient(this, info);
                this.registered = true;
            }
            SynchronizedBoolean synchronizedBoolean = this.started;
            synchronized (synchronizedBoolean) {
                if (info.getProperties() != null && info.getProperties().getProperty(ConnectionInfo.NO_DELAY_PROPERTY) != null) {
                    boolean noDelay = new Boolean(info.getProperties().getProperty(ConnectionInfo.NO_DELAY_PROPERTY));
                    this.channel.setNoDelay(noDelay);
                }
                if (!this.started.get() && info.isStarted()) {
                    this.started.set(true);
                    log.debug((Object)(this + " has started running client version " + info.getClientVersion() + " , wire format = " + info.getWireFormatVersion()));
                    Iterator i = this.consumers.iterator();
                    while (i.hasNext()) {
                        ConsumerInfo ci = (ConsumerInfo)i.next();
                        ci.setClientId(info.getClientId());
                    }
                    i = this.producers.iterator();
                    while (i.hasNext()) {
                        ProducerInfo pi = (ProducerInfo)i.next();
                        pi.setClientId(info.getClientId());
                    }
                    i = this.sessions.iterator();
                    while (i.hasNext()) {
                        SessionInfo si = (SessionInfo)i.next();
                        si.setClientId(info.getClientId());
                    }
                    for (int i2 = 0; i2 < this.dispatchQueue.size(); ++i2) {
                        ActiveMQMessage msg = (ActiveMQMessage)this.dispatchQueue.get(i2);
                        this.dispatch(msg);
                    }
                    this.dispatchQueue.clear();
                }
                if (this.started.get() && !info.isStarted()) {
                    this.started.set(false);
                    log.debug((Object)(this + " has stopped"));
                }
            }
        }
    }

    public void start() throws JMSException {
        this.channel.start();
    }

    public void stop() throws JMSException {
        log.trace((Object)("Stopping channel: " + this.channel));
        this.channel.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanUp() {
        if (!this.cleanedUp) {
            this.cleanedUp = true;
            try {
                try {
                    AbstractPacket info;
                    Iterator i = this.consumers.iterator();
                    while (i.hasNext()) {
                        info = (ConsumerInfo)i.next();
                        ((ConsumerInfo)info).setStarted(false);
                        this.brokerConnector.deregisterMessageConsumer(this, (ConsumerInfo)info);
                    }
                    i = this.producers.iterator();
                    while (i.hasNext()) {
                        info = (ProducerInfo)i.next();
                        ((ProducerInfo)info).setStarted(false);
                        this.brokerConnector.deregisterMessageProducer(this, (ProducerInfo)info);
                    }
                    i = this.sessions.iterator();
                    while (i.hasNext()) {
                        info = (SessionInfo)i.next();
                        ((SessionInfo)info).setStarted(false);
                        this.brokerConnector.deregisterSession(this, (SessionInfo)info);
                    }
                    i = this.transactions.iterator();
                    while (i.hasNext()) {
                        this.brokerConnector.rollbackTransaction((BrokerClient)this, i.next().toString());
                    }
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this + " has stopped"));
                    }
                    this.consumers.clear();
                    this.producers.clear();
                    this.transactions.clear();
                    this.sessions.clear();
                    this.brokerConnector.deregisterClient(this, this.connectionInfo);
                    this.registered = false;
                    throw throwable;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + " has stopped"));
                }
                this.consumers.clear();
                this.producers.clear();
                this.transactions.clear();
                this.sessions.clear();
                this.brokerConnector.deregisterClient(this, this.connectionInfo);
                this.registered = false;
                {
                }
            }
            catch (JMSException e) {
                log.warn((Object)("failed to de-register Broker client: " + (Object)((Object)e)), (Throwable)e);
            }
        } else {
            log.debug((Object)("We are ignoring a duplicate cleanup() method called for: " + this));
        }
    }

    protected void send(Packet packet) {
        if (!this.closed.get()) {
            try {
                if (this.brokerConnection) {
                    String brokerName = this.brokerConnector.getBrokerContainer().getBroker().getBrokerName();
                    packet.addBrokerVisited(brokerName);
                    if (packet.hasVisited(this.remoteBrokerName)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Not Forwarding: " + this.remoteBrokerName + " has already been visited by packet: " + packet));
                        }
                        return;
                    }
                }
                packet.setId(this.packetIdGenerator.getNextShortSequence());
                this.channel.asyncSend(packet);
            }
            catch (JMSException e) {
                log.warn((Object)(this + " caught exception "), (Throwable)e);
                this.close();
            }
        }
    }

    public void validateConnection(int timeout) throws JMSException {
        KeepAlive packet = new KeepAlive();
        packet.setReceiptRequired(true);
        packet.setId(this.packetIdGenerator.getNextShortSequence());
        Receipt r = this.getChannel().send(packet, timeout);
        if (r == null) {
            throw new JMSException("Client did not respond in time");
        }
    }

    protected void close() {
        if (this.closed.commit(false, true)) {
            this.channel.stop();
            log.debug((Object)(this + " has closed"));
        }
    }

    private void consumeActiveMQMessage(ActiveMQMessage message) throws JMSException {
        this.brokerConnector.sendMessage(this, message);
    }

    private void consumeMessageAck(MessageAck ack) throws JMSException {
        this.brokerConnector.acknowledgeMessage(this, ack);
    }

    private void consumeTransactionInfo(TransactionInfo info) throws JMSException {
        if (info.getType() == 101) {
            this.transactions.add((Object)info.getTransactionId());
            this.brokerConnector.startTransaction((BrokerClient)this, info.getTransactionId());
        } else {
            if (info.getType() == 105) {
                this.brokerConnector.rollbackTransaction((BrokerClient)this, info.getTransactionId());
            } else if (info.getType() == 103) {
                this.brokerConnector.commitTransaction(this, info.getTransactionId());
            }
            this.transactions.remove((Object)info.getTransactionId());
        }
    }

    private void consumeXATransactionInfo(XATransactionInfo info) throws JMSException, XAException {
        if (info.getType() == 101) {
            this.brokerConnector.startTransaction((BrokerClient)this, info.getXid());
        } else if (info.getType() == 110) {
            ActiveMQXid[] rc = this.brokerConnector.getPreparedTransactions(this);
            info.setReceiptRequired(false);
            ResponseReceipt receipt = new ResponseReceipt();
            receipt.setCorrelationId(info.getId());
            receipt.setResult((Serializable)rc);
            this.send(receipt);
        } else if (info.getType() == 113) {
            String rc = this.brokerConnector.getResourceManagerId(this);
            info.setReceiptRequired(false);
            ResponseReceipt receipt = new ResponseReceipt();
            receipt.setId(this.packetIdGenerator.getNextShortSequence());
            receipt.setCorrelationId(info.getId());
            receipt.setResult((Serializable)((Object)rc));
            this.send(receipt);
        } else if (info.getType() != 106) {
            if (info.getType() == 102) {
                int rc = this.brokerConnector.prepareTransaction(this, info.getXid());
                info.setReceiptRequired(false);
                IntResponseReceipt receipt = new IntResponseReceipt();
                receipt.setId(this.packetIdGenerator.getNextShortSequence());
                receipt.setCorrelationId(info.getId());
                receipt.setResult(rc);
                this.send(receipt);
            } else if (info.getType() == 105) {
                this.brokerConnector.rollbackTransaction((BrokerClient)this, info.getXid());
            } else if (info.getType() == 109) {
                this.brokerConnector.commitTransaction(this, info.getXid(), true);
            } else if (info.getType() == 103) {
                this.brokerConnector.commitTransaction(this, info.getXid(), false);
            } else {
                throw new JMSException("Packet type: " + info.getType() + " not recognized.");
            }
        }
    }

    private void consumeProducerInfo(ProducerInfo info) throws JMSException {
        if (info.isStarted()) {
            this.producers.add((Object)info);
            this.brokerConnector.registerMessageProducer(this, info);
        } else {
            this.producers.remove((Object)info);
            this.brokerConnector.deregisterMessageProducer(this, info);
        }
    }

    private void consumeSessionInfo(SessionInfo info) throws JMSException {
        if (info.isStarted()) {
            this.sessions.add((Object)info);
            this.brokerConnector.registerSession(this, info);
        } else {
            this.sessions.remove((Object)info);
            this.brokerConnector.deregisterSession(this, info);
        }
    }

    private void consumeCapacityInfo(CapacityInfo info) {
        this.capacity = info.getCapacity();
    }

    private void updateCapacityInfo(short correlationId) {
        CapacityInfo info = new CapacityInfo();
        info.setResourceName(this.brokerConnector.getBrokerInfo().getBrokerName());
        info.setCorrelationId(correlationId);
        info.setCapacity(this.brokerConnector.getBrokerCapacity());
        info.setFlowControlTimeout(this.getFlowControlTimeout(info.getCapacity()));
        this.send(info);
    }

    private long getFlowControlTimeout(int capacity) {
        long result = -1L;
        if (capacity <= 0) {
            result = 10000L;
        } else if (capacity <= 10) {
            result = 1000L;
        } else if (capacity <= 20) {
            result = 10L;
        }
        return result;
    }

    private void consumeBrokerInfo(final BrokerInfo info) {
        this.brokerConnection = true;
        this.started.set(true);
        this.remoteBrokerName = info.getBrokerName();
        String localBrokerName = this.brokerConnector.getBrokerInfo().getBrokerName();
        String clusterName = this.getBrokerConnector().getBrokerContainer().getBroker().getBrokerClusterName();
        if (clusterName.equals(info.getClusterName())) {
            this.clusteredConnection = true;
        }
        if (!this.remoteNetworkConnector && info.isRemote()) {
            try {
                final NetworkConnector networkConnector = new NetworkConnector(this.brokerConnector.getBrokerContainer());
                networkConnector.getThreadPool().execute(new Runnable(){

                    public void run() {
                        try {
                            NetworkChannel networkChannel = new NetworkChannel(networkConnector, BrokerClientImpl.this.brokerConnector.getBrokerContainer(), BrokerClientImpl.this.channel, info.getBrokerName(), info.getClusterName());
                            networkConnector.addNetworkChannel(networkChannel);
                            BrokerClientImpl.this.brokerConnector.getBrokerContainer().addNetworkConnector(networkConnector);
                            networkConnector.start();
                        }
                        catch (JMSException e) {
                            log.error((Object)"Failed to create reverse remote channel", (Throwable)e);
                        }
                    }
                });
                log.info((Object)("Started reverse remote channel to " + this.remoteBrokerName));
                this.remoteNetworkConnector = true;
            }
            catch (InterruptedException e) {
                log.error((Object)"Failed to create reverse remote channel", (Throwable)e);
            }
        }
    }

    private void sendReceipt(short correlationId, Throwable requestEx, boolean failed) {
        Receipt receipt = new Receipt();
        receipt.setCorrelationId(correlationId);
        receipt.setBrokerName(this.brokerConnector.getBrokerInfo().getBrokerName());
        receipt.setClusterName(this.brokerConnector.getBrokerInfo().getClusterName());
        receipt.setException(requestEx);
        receipt.setFailed(failed);
        this.send(receipt);
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }
}

