/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io;

import java.io.DataInputStream;
import java.io.IOException;
import javax.jms.JMSException;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.util.FactoryFinder;

public class WireFormatLoader {
    private static FactoryFinder finder = new FactoryFinder("META-INF/services/org/codehaus/activemq/io/");
    private WireFormat preferedWireFormat;

    public WireFormatLoader() {
        this(new DefaultWireFormat());
    }

    public WireFormatLoader(WireFormat prefered) {
        this.preferedWireFormat = prefered;
    }

    public WireFormat getWireFormat(DataInputStream dataIn) throws JMSException, IOException {
        WireFormat result = this.preferedWireFormat;
        dataIn.mark(10);
        int protocol = dataIn.read();
        if (protocol == 128) {
            result = WireFormatLoader.getWireFormat("amqpfast");
        }
        dataIn.reset();
        return result;
    }

    public WireFormat getPreferedWireFormat() {
        return this.preferedWireFormat;
    }

    public void setPreferedWireFormat(WireFormat preferedWireFormat) {
        this.preferedWireFormat = preferedWireFormat;
    }

    public static WireFormat getWireFormat(String format) throws JMSException {
        try {
            Object value = finder.newInstance(format);
            if (value instanceof WireFormat) {
                return (WireFormat)value;
            }
            throw new JMSException(format + " is not a WireFormat: " + value);
        }
        catch (IllegalAccessException e) {
            throw WireFormatLoader.createJMSexception(format, e);
        }
        catch (InstantiationException e) {
            throw WireFormatLoader.createJMSexception(format, e);
        }
        catch (IOException e) {
            throw WireFormatLoader.createJMSexception(format, e);
        }
        catch (ClassNotFoundException e) {
            throw WireFormatLoader.createJMSexception(format, e);
        }
    }

    protected static JMSException createJMSexception(String protocol, Exception e) {
        JMSException answer = new JMSException("Could not load protocol: " + protocol + ". Reason: " + e);
        answer.setLinkedException(e);
        return answer;
    }
}

