/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io.impl;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.impl.AbstractPacketWriter;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.util.ByteArray;
import org.codehaus.activemq.util.BitArray;

public class ActiveMQMessageWriter
extends AbstractPacketWriter {
    private static final Log log = LogFactory.getLog((Class)ActiveMQMessageWriter.class);
    private DefaultWireFormat wireFormat;

    ActiveMQMessageWriter(DefaultWireFormat wf) {
        this.wireFormat = wf;
    }

    public int getPacketType() {
        return 6;
    }

    public void writePacket(Packet packet, DataOutput dataOut) throws IOException {
        ActiveMQMessage msg = (ActiveMQMessage)packet;
        boolean externalMessageId = msg.isExternalMessageId() || msg.getProducerKey() == null || msg.getProducerKey().length() == 0;
        msg.setExternalMessageId(externalMessageId);
        ActiveMQDestination destination = msg.getJMSActiveMQDestination();
        ByteArray payload = msg.getBodyAsBytes();
        BitArray ba = msg.getBitArray();
        ba.reset();
        boolean cachingEnabled = this.wireFormat.isCachingEnabled();
        boolean cachingDestination = cachingEnabled && destination != null && !destination.isOrdered() && !destination.isExclusive();
        boolean longSequence = msg.getSequenceNumber() > Integer.MAX_VALUE;
        ba.set(0, packet.isReceiptRequired());
        Object[] visited = msg.getBrokersVisited();
        boolean writeVisited = visited != null && visited.length > 0;
        ba.set(1, writeVisited);
        ba.set(2, msg.getJMSCorrelationID() != null);
        ba.set(3, msg.getJMSType() != null);
        ba.set(4, msg.getEntryBrokerName() != null);
        ba.set(5, msg.getEntryClusterName() != null);
        ba.set(6, msg.getTransactionId() != null);
        ba.set(7, msg.getJMSReplyTo() != null);
        ba.set(8, msg.getJMSTimestamp() > 0L);
        ba.set(9, msg.getJMSExpiration() > 0L);
        ba.set(10, msg.getJMSRedelivered());
        ba.set(11, msg.isXaTransacted());
        ba.set(12, msg.getConsumerNos() != null);
        ba.set(13, msg.getProperties() != null && msg.getProperties().size() > 0);
        ba.set(14, msg.isDispatchedFromDLQ());
        ba.set(15, payload != null);
        ba.set(16, msg.isExternalMessageId());
        ba.set(17, msg.isMessagePart());
        ba.set(18, cachingEnabled);
        ba.set(19, cachingDestination);
        ba.set(20, longSequence);
        ba.writeToStream(dataOut);
        if (msg.isReceiptRequired()) {
            dataOut.writeShort(msg.getId());
        }
        if (msg.isExternalMessageId()) {
            this.writeUTF(msg.getJMSMessageID(), dataOut);
        }
        if (msg.isMessagePart()) {
            this.writeUTF(msg.getParentMessageID(), dataOut);
            dataOut.writeShort(msg.getNumberOfParts());
            dataOut.writeShort(msg.getPartNumber());
        }
        if (writeVisited) {
            dataOut.writeShort(visited.length);
            for (int i = 0; i < visited.length; ++i) {
                String brokerName = visited[i].toString();
                if (brokerName != null) {
                    dataOut.writeUTF(brokerName);
                    continue;
                }
                log.warn((Object)"The brokerVisited name is null");
            }
        }
        if (cachingEnabled) {
            dataOut.writeShort(this.wireFormat.getWriteCachedKey(msg.getJMSClientID()));
            dataOut.writeShort(this.wireFormat.getWriteCachedKey(msg.getProducerKey()));
            if (cachingDestination) {
                dataOut.writeShort(this.wireFormat.getWriteCachedKey(destination));
            } else {
                ActiveMQDestination.writeToStream(destination, dataOut);
            }
            if (msg.getJMSReplyTo() != null) {
                dataOut.writeShort(this.wireFormat.getWriteCachedKey(msg.getJMSReplyTo()));
            }
        } else {
            super.writeUTF(msg.getJMSClientID(), dataOut);
            this.writeUTF(msg.getProducerKey(), dataOut);
            ActiveMQDestination.writeToStream(destination, dataOut);
            if (ba.get(7)) {
                ActiveMQDestination.writeToStream((ActiveMQDestination)msg.getJMSReplyTo(), dataOut);
            }
        }
        dataOut.writeByte(msg.getJMSDeliveryMode());
        dataOut.writeByte(msg.getJMSPriority());
        if (ba.get(2)) {
            super.writeUTF(msg.getJMSCorrelationID(), dataOut);
        }
        if (ba.get(3)) {
            super.writeUTF(msg.getJMSType(), dataOut);
        }
        if (ba.get(4)) {
            super.writeUTF(msg.getEntryBrokerName(), dataOut);
        }
        if (ba.get(5)) {
            super.writeUTF(msg.getEntryClusterName(), dataOut);
        }
        if (ba.get(6)) {
            if (ba.get(11)) {
                ActiveMQXid xid = (ActiveMQXid)msg.getTransactionId();
                xid.write(dataOut);
            } else {
                super.writeUTF((String)msg.getTransactionId(), dataOut);
            }
        }
        if (ba.get(8)) {
            dataOut.writeLong(msg.getJMSTimestamp());
        }
        if (ba.get(9)) {
            dataOut.writeLong(msg.getJMSExpiration());
        }
        if (ba.get(12)) {
            int[] cids = msg.getConsumerNos();
            dataOut.writeShort(cids.length);
            for (int i = 0; i < cids.length; ++i) {
                dataOut.writeShort(cids[i]);
            }
        }
        if (ba.get(13)) {
            msg.writeMapProperties(msg.getProperties(), dataOut);
        }
        if (ba.get(15)) {
            dataOut.writeInt(payload.getLength());
            dataOut.write(payload.getBuf(), payload.getOffset(), payload.getLength());
        }
        if (longSequence) {
            dataOut.writeLong(msg.getSequenceNumber());
        } else {
            dataOut.writeInt((int)msg.getSequenceNumber());
        }
        dataOut.writeByte(msg.getDeliveryCount());
    }
}

