/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.io.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedShort;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.AbstractWireFormat;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.impl.ActiveMQBytesMessageReader;
import org.codehaus.activemq.io.impl.ActiveMQBytesMessageWriter;
import org.codehaus.activemq.io.impl.ActiveMQMapMessageReader;
import org.codehaus.activemq.io.impl.ActiveMQMapMessageWriter;
import org.codehaus.activemq.io.impl.ActiveMQMessageReader;
import org.codehaus.activemq.io.impl.ActiveMQMessageWriter;
import org.codehaus.activemq.io.impl.ActiveMQObjectMessageReader;
import org.codehaus.activemq.io.impl.ActiveMQObjectMessageWriter;
import org.codehaus.activemq.io.impl.ActiveMQStreamMessageReader;
import org.codehaus.activemq.io.impl.ActiveMQStreamMessageWriter;
import org.codehaus.activemq.io.impl.ActiveMQTextMessageReader;
import org.codehaus.activemq.io.impl.ActiveMQTextMessageWriter;
import org.codehaus.activemq.io.impl.BrokerAdminCommandReader;
import org.codehaus.activemq.io.impl.BrokerAdminCommandWriter;
import org.codehaus.activemq.io.impl.BrokerInfoReader;
import org.codehaus.activemq.io.impl.BrokerInfoWriter;
import org.codehaus.activemq.io.impl.CachedValueReader;
import org.codehaus.activemq.io.impl.CachedValueWriter;
import org.codehaus.activemq.io.impl.CapacityInfoReader;
import org.codehaus.activemq.io.impl.CapacityInfoRequestReader;
import org.codehaus.activemq.io.impl.CapacityInfoRequestWriter;
import org.codehaus.activemq.io.impl.CapacityInfoWriter;
import org.codehaus.activemq.io.impl.CleanupConnectionInfoReader;
import org.codehaus.activemq.io.impl.CleanupConnectionInfoWriter;
import org.codehaus.activemq.io.impl.ConnectionInfoReader;
import org.codehaus.activemq.io.impl.ConnectionInfoWriter;
import org.codehaus.activemq.io.impl.ConsumerInfoReader;
import org.codehaus.activemq.io.impl.ConsumerInfoWriter;
import org.codehaus.activemq.io.impl.DurableUnsubscribeReader;
import org.codehaus.activemq.io.impl.DurableUnsubscribeWriter;
import org.codehaus.activemq.io.impl.IntResponseReceiptReader;
import org.codehaus.activemq.io.impl.IntResponseReceiptWriter;
import org.codehaus.activemq.io.impl.KeepAliveReader;
import org.codehaus.activemq.io.impl.KeepAliveWriter;
import org.codehaus.activemq.io.impl.MessageAckReader;
import org.codehaus.activemq.io.impl.MessageAckWriter;
import org.codehaus.activemq.io.impl.PacketReader;
import org.codehaus.activemq.io.impl.PacketWriter;
import org.codehaus.activemq.io.impl.ProducerInfoReader;
import org.codehaus.activemq.io.impl.ProducerInfoWriter;
import org.codehaus.activemq.io.impl.ReceiptReader;
import org.codehaus.activemq.io.impl.ReceiptWriter;
import org.codehaus.activemq.io.impl.ResponseReceiptReader;
import org.codehaus.activemq.io.impl.ResponseReceiptWriter;
import org.codehaus.activemq.io.impl.SessionInfoReader;
import org.codehaus.activemq.io.impl.SessionInfoWriter;
import org.codehaus.activemq.io.impl.TransactionInfoReader;
import org.codehaus.activemq.io.impl.TransactionInfoWriter;
import org.codehaus.activemq.io.impl.WireFormatInfoReader;
import org.codehaus.activemq.io.impl.WireFormatInfoWriter;
import org.codehaus.activemq.io.impl.XATransactionInfoReader;
import org.codehaus.activemq.io.impl.XATransactionInfoWriter;
import org.codehaus.activemq.message.AbstractPacket;
import org.codehaus.activemq.message.CachedValue;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.message.WireFormatInfo;
import org.codehaus.activemq.message.util.WireByteArrayInputStream;
import org.codehaus.activemq.message.util.WireByteArrayOutputStream;

public class DefaultWireFormat
extends AbstractWireFormat
implements Serializable {
    public static final int WIRE_FORMAT_VERSION = 3;
    private static final int MAX_CACHE_SIZE = 16383;
    private static final Log log = LogFactory.getLog((Class)DefaultWireFormat.class);
    static final short NULL_VALUE = -1;
    static final short CLEAR_CACHE = -2;
    private transient PacketReader messageReader;
    private transient PacketReader textMessageReader;
    private transient PacketReader objectMessageReader;
    private transient PacketReader bytesMessageReader;
    private transient PacketReader streamMessageReader;
    private transient PacketReader mapMessageReader;
    private transient PacketReader messageAckReader;
    private transient PacketReader receiptReader;
    private transient PacketReader consumerInfoReader;
    private transient PacketReader producerInfoReader;
    private transient PacketReader transactionInfoReader;
    private transient PacketReader xaTransactionInfoReader;
    private transient PacketReader brokerInfoReader;
    private transient PacketReader connectionInfoReader;
    private transient PacketReader sessionInfoReader;
    private transient PacketReader durableUnsubscribeReader;
    private transient PacketReader reponseReceiptReader;
    private transient PacketReader intReponseReceiptReader;
    private transient PacketReader capacityInfoReader;
    private transient PacketReader capacityInfoRequestReader;
    private transient PacketReader wireFormatInfoReader;
    private transient PacketReader keepAliveReader;
    private transient PacketReader brokerAdminCommandReader;
    private transient PacketReader cachedValueReader;
    private transient PacketReader cleanupConnectionAndSessionInfoReader;
    private transient PacketWriter messageWriter;
    private transient PacketWriter textMessageWriter;
    private transient PacketWriter objectMessageWriter;
    private transient PacketWriter bytesMessageWriter;
    private transient PacketWriter streamMessageWriter;
    private transient PacketWriter mapMessageWriter;
    private transient PacketWriter messageAckWriter;
    private transient PacketWriter receiptWriter;
    private transient PacketWriter consumerInfoWriter;
    private transient PacketWriter producerInfoWriter;
    private transient PacketWriter transactionInfoWriter;
    private transient PacketWriter xaTransactionInfoWriter;
    private transient PacketWriter brokerInfoWriter;
    private transient PacketWriter connectionInfoWriter;
    private transient PacketWriter sessionInfoWriter;
    private transient PacketWriter durableUnsubscribeWriter;
    private transient PacketWriter reponseReceiptWriter;
    private transient PacketWriter intReponseReceiptWriter;
    private transient PacketWriter capacityInfoWriter;
    private transient PacketWriter capacityInfoRequestWriter;
    private transient PacketWriter wireFormatInfoWriter;
    private transient PacketWriter keepAliveWriter;
    private transient PacketWriter brokerAdminCommandWriter;
    private transient PacketWriter cachedValueWriter;
    private transient PacketWriter cleanupConnectionAndSessionInfoWriter;
    private transient WireByteArrayOutputStream internalBytesOut;
    private transient DataOutputStream internalDataOut;
    private transient WireByteArrayInputStream internalBytesIn;
    private transient DataInputStream internalDataIn;
    private transient int currentWireFormatVersion = 3;
    private transient SynchronizedShort cachedKeyGenerator;
    private transient WireByteArrayOutputStream cachedBytesOut;
    private transient DataOutputStream cachedDataOut;
    private List readers = new ArrayList();
    private List writers = new ArrayList();
    private Map readValueCache = new ConcurrentHashMap();
    private Map writeValueCache = new ConcurrentHashMap();

    public DefaultWireFormat() {
        this.internalBytesOut = new WireByteArrayOutputStream();
        this.internalDataOut = new DataOutputStream(this.internalBytesOut);
        this.internalBytesIn = new WireByteArrayInputStream();
        this.internalDataIn = new DataInputStream(this.internalBytesIn);
        this.cachedKeyGenerator = new SynchronizedShort(0);
        this.cachedBytesOut = new WireByteArrayOutputStream();
        this.cachedDataOut = new DataOutputStream(this.cachedBytesOut);
        this.initializeReaders();
        this.initializeWriters();
    }

    public void initiateClientSideProtocol(DataOutputStream dataOut, DataInputStream dataIn) throws JMSException {
        WireFormatInfo info = new WireFormatInfo();
        info.setVersion(this.getCurrentWireFormatVersion());
        try {
            this.writePacket(info, dataOut);
            dataOut.flush();
        }
        catch (IOException e) {
            throw new JMSException("Failed to intiate protocol");
        }
    }

    public void initiateServerSideProtocol(DataOutputStream dataOut, DataInputStream dataIn) throws JMSException {
    }

    public WireFormat copy() {
        return new DefaultWireFormat();
    }

    public Packet readPacket(DataInput dataIn) throws IOException {
        byte by;
        int type = -1;
        do {
            by = dataIn.readByte();
            type = by;
        } while (by == 0);
        if (type == -1) {
            throw new IOException("InputStream now closed");
        }
        return this.readPacket(type, dataIn);
    }

    public Packet readPacket(int firstByte, DataInput dataIn) throws IOException {
        switch (firstByte) {
            case 6: {
                return this.readPacket(dataIn, this.messageReader);
            }
            case 7: {
                return this.readPacket(dataIn, this.textMessageReader);
            }
            case 8: {
                return this.readPacket(dataIn, this.objectMessageReader);
            }
            case 9: {
                return this.readPacket(dataIn, this.bytesMessageReader);
            }
            case 10: {
                return this.readPacket(dataIn, this.streamMessageReader);
            }
            case 11: {
                return this.readPacket(dataIn, this.mapMessageReader);
            }
            case 15: {
                return this.readPacket(dataIn, this.messageAckReader);
            }
            case 16: {
                return this.readPacket(dataIn, this.receiptReader);
            }
            case 17: {
                return this.readPacket(dataIn, this.consumerInfoReader);
            }
            case 18: {
                return this.readPacket(dataIn, this.producerInfoReader);
            }
            case 19: {
                return this.readPacket(dataIn, this.transactionInfoReader);
            }
            case 20: {
                return this.readPacket(dataIn, this.xaTransactionInfoReader);
            }
            case 21: {
                return this.readPacket(dataIn, this.brokerInfoReader);
            }
            case 22: {
                return this.readPacket(dataIn, this.connectionInfoReader);
            }
            case 23: {
                return this.readPacket(dataIn, this.sessionInfoReader);
            }
            case 24: {
                return this.readPacket(dataIn, this.durableUnsubscribeReader);
            }
            case 25: {
                return this.readPacket(dataIn, this.reponseReceiptReader);
            }
            case 26: {
                return this.readPacket(dataIn, this.intReponseReceiptReader);
            }
            case 27: {
                return this.readPacket(dataIn, this.capacityInfoReader);
            }
            case 28: {
                return this.readPacket(dataIn, this.capacityInfoRequestReader);
            }
            case 29: {
                WireFormatInfo info = (WireFormatInfo)this.readPacket(dataIn, this.wireFormatInfoReader);
                if (info != null && info.getVersion() < 3) {
                    throw new IOException("Cannot support wire format version: " + info.getVersion());
                }
                return info;
            }
            case 30: {
                return this.readPacket(dataIn, this.keepAliveReader);
            }
            case 31: {
                return this.readPacket(dataIn, this.brokerAdminCommandReader);
            }
            case 32: {
                CachedValue cv = (CachedValue)this.readPacket(dataIn, this.cachedValueReader);
                this.handleCachedValue(cv);
                return null;
            }
            case 33: {
                return this.readPacket(dataIn, this.cleanupConnectionAndSessionInfoReader);
            }
        }
        log.error((Object)("Could not find PacketReader for packet type: " + AbstractPacket.getPacketTypeAsString(firstByte)));
        return null;
    }

    public Packet writePacket(Packet packet, DataOutput dataOut) throws IOException {
        PacketWriter writer = this.getWriter(packet);
        if (writer != null) {
            this.validateWriteCache();
            this.writePacket(packet, dataOut, writer);
        }
        return null;
    }

    public byte[] toBytes(Packet packet) throws IOException {
        byte[] data = null;
        PacketWriter writer = this.getWriter(packet);
        if (writer != null) {
            this.internalBytesOut.reset();
            this.internalDataOut.writeByte(packet.getPacketType());
            this.internalDataOut.writeInt(-1);
            writer.writePacket(packet, this.internalDataOut);
            this.internalDataOut.flush();
            data = this.internalBytesOut.toByteArray();
            int length = data.length - 5;
            packet.setMemoryUsage(length);
            data[1] = (byte)(length >>> 24 & 0xFF);
            data[2] = (byte)(length >>> 16 & 0xFF);
            data[3] = (byte)(length >>> 8 & 0xFF);
            data[4] = (byte)(length >>> 0 & 0xFF);
        }
        return data;
    }

    public boolean canProcessWireFormatVersion(int version) {
        return version <= 3;
    }

    public int getCurrentWireFormatVersion() {
        return this.currentWireFormatVersion;
    }

    public void setCurrentWireFormatVersion(int version) {
        int i;
        this.currentWireFormatVersion = version;
        for (i = 0; i < this.readers.size(); ++i) {
            PacketReader reader = (PacketReader)this.readers.get(i);
            reader.setWireFormatVersion(version);
        }
        for (i = 0; i < this.writers.size(); ++i) {
            PacketWriter writer = (PacketWriter)this.writers.get(i);
            writer.setWireFormatVersion(version);
        }
    }

    protected final synchronized void writePacket(Packet packet, DataOutput dataOut, PacketWriter writer) throws IOException {
        this.internalBytesOut.reset();
        writer.writePacket(packet, this.internalDataOut);
        this.internalDataOut.flush();
        byte[] data = this.internalBytesOut.getData();
        int count = this.internalBytesOut.size();
        dataOut.writeByte(packet.getPacketType());
        dataOut.writeInt(count);
        packet.setMemoryUsage(count);
        dataOut.write(data, 0, count);
    }

    protected final synchronized Packet readPacket(DataInput dataIn, PacketReader reader) throws IOException {
        Packet packet = reader.createPacket();
        int length = dataIn.readInt();
        packet.setMemoryUsage(length);
        byte[] data = new byte[length];
        dataIn.readFully(data);
        this.internalBytesIn.restart(data);
        reader.buildPacket(packet, this.internalDataIn);
        return packet;
    }

    protected Object getValueFromReadCache(short key) {
        return this.readValueCache.get(new Short(key));
    }

    protected short getWriteCachedKey(Object key) throws IOException {
        if (key != null) {
            Short result = null;
            result = (Short)this.writeValueCache.get(key);
            if (result == null) {
                result = new Short(this.cachedKeyGenerator.increment());
                this.writeValueCache.put(key, result);
                this.updateCachedValue(result, key);
            }
            return result;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateWriteCache() throws IOException {
        if (this.cachingEnabled) {
            DefaultWireFormat defaultWireFormat = this;
            synchronized (defaultWireFormat) {
                if (this.writeValueCache.size() >= 16383) {
                    this.writeValueCache.clear();
                    this.cachedKeyGenerator.set((short)0);
                    this.updateCachedValue((short)-1, null);
                }
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return new DefaultWireFormat();
    }

    private PacketWriter getWriter(Packet packet) throws IOException {
        PacketWriter answer = null;
        switch (packet.getPacketType()) {
            case 6: {
                answer = this.messageWriter;
                break;
            }
            case 7: {
                answer = this.textMessageWriter;
                break;
            }
            case 8: {
                answer = this.objectMessageWriter;
                break;
            }
            case 9: {
                answer = this.bytesMessageWriter;
                break;
            }
            case 10: {
                answer = this.streamMessageWriter;
                break;
            }
            case 11: {
                answer = this.mapMessageWriter;
                break;
            }
            case 15: {
                answer = this.messageAckWriter;
                break;
            }
            case 16: {
                answer = this.receiptWriter;
                break;
            }
            case 17: {
                answer = this.consumerInfoWriter;
                break;
            }
            case 18: {
                answer = this.producerInfoWriter;
                break;
            }
            case 19: {
                answer = this.transactionInfoWriter;
                break;
            }
            case 20: {
                answer = this.xaTransactionInfoWriter;
                break;
            }
            case 21: {
                answer = this.brokerInfoWriter;
                break;
            }
            case 22: {
                answer = this.connectionInfoWriter;
                break;
            }
            case 23: {
                answer = this.sessionInfoWriter;
                break;
            }
            case 24: {
                answer = this.durableUnsubscribeWriter;
                break;
            }
            case 25: {
                answer = this.reponseReceiptWriter;
                break;
            }
            case 26: {
                answer = this.intReponseReceiptWriter;
                break;
            }
            case 27: {
                answer = this.capacityInfoWriter;
                break;
            }
            case 28: {
                answer = this.capacityInfoRequestWriter;
                break;
            }
            case 29: {
                answer = this.wireFormatInfoWriter;
                break;
            }
            case 30: {
                answer = this.keepAliveWriter;
                break;
            }
            case 31: {
                answer = this.brokerAdminCommandWriter;
                break;
            }
            case 32: {
                answer = this.cachedValueWriter;
                break;
            }
            case 33: {
                answer = this.cleanupConnectionAndSessionInfoWriter;
                break;
            }
            default: {
                log.error((Object)("no PacketWriter for packet: " + packet));
            }
        }
        return answer;
    }

    private void handleCachedValue(CachedValue cv) {
        if (cv != null) {
            if (cv.getId() == -2) {
                this.readValueCache.clear();
            } else if (cv.getId() != -1) {
                this.readValueCache.put(new Short(cv.getId()), cv.getValue());
            }
        }
    }

    private void initializeReaders() {
        this.messageReader = new ActiveMQMessageReader(this);
        this.readers.add(this.messageReader);
        this.textMessageReader = new ActiveMQTextMessageReader(this);
        this.readers.add(this.textMessageReader);
        this.objectMessageReader = new ActiveMQObjectMessageReader(this);
        this.readers.add(this.objectMessageReader);
        this.bytesMessageReader = new ActiveMQBytesMessageReader(this);
        this.readers.add(this.bytesMessageReader);
        this.streamMessageReader = new ActiveMQStreamMessageReader(this);
        this.readers.add(this.streamMessageReader);
        this.mapMessageReader = new ActiveMQMapMessageReader(this);
        this.readers.add(this.mapMessageReader);
        this.messageAckReader = new MessageAckReader(this);
        this.readers.add(this.messageAckReader);
        this.receiptReader = new ReceiptReader();
        this.readers.add(this.receiptReader);
        this.consumerInfoReader = new ConsumerInfoReader();
        this.readers.add(this.consumerInfoReader);
        this.producerInfoReader = new ProducerInfoReader();
        this.readers.add(this.producerInfoReader);
        this.transactionInfoReader = new TransactionInfoReader();
        this.readers.add(this.transactionInfoReader);
        this.xaTransactionInfoReader = new XATransactionInfoReader();
        this.readers.add(this.xaTransactionInfoReader);
        this.brokerInfoReader = new BrokerInfoReader();
        this.readers.add(this.brokerInfoReader);
        this.connectionInfoReader = new ConnectionInfoReader();
        this.readers.add(this.connectionInfoReader);
        this.sessionInfoReader = new SessionInfoReader();
        this.readers.add(this.sessionInfoReader);
        this.durableUnsubscribeReader = new DurableUnsubscribeReader();
        this.readers.add(this.durableUnsubscribeReader);
        this.reponseReceiptReader = new ResponseReceiptReader();
        this.readers.add(this.reponseReceiptReader);
        this.intReponseReceiptReader = new IntResponseReceiptReader();
        this.readers.add(this.intReponseReceiptReader);
        this.capacityInfoReader = new CapacityInfoReader();
        this.readers.add(this.capacityInfoReader);
        this.capacityInfoRequestReader = new CapacityInfoRequestReader();
        this.readers.add(this.capacityInfoReader);
        this.wireFormatInfoReader = new WireFormatInfoReader(this);
        this.readers.add(this.wireFormatInfoReader);
        this.keepAliveReader = new KeepAliveReader();
        this.readers.add(this.keepAliveReader);
        this.brokerAdminCommandReader = new BrokerAdminCommandReader();
        this.readers.add(this.brokerAdminCommandReader);
        this.cachedValueReader = new CachedValueReader();
        this.readers.add(this.cachedValueReader);
        this.cleanupConnectionAndSessionInfoReader = new CleanupConnectionInfoReader();
        this.readers.add(this.cleanupConnectionAndSessionInfoReader);
    }

    private void initializeWriters() {
        this.messageWriter = new ActiveMQMessageWriter(this);
        this.writers.add(this.messageWriter);
        this.textMessageWriter = new ActiveMQTextMessageWriter(this);
        this.writers.add(this.textMessageWriter);
        this.objectMessageWriter = new ActiveMQObjectMessageWriter(this);
        this.writers.add(this.objectMessageWriter);
        this.bytesMessageWriter = new ActiveMQBytesMessageWriter(this);
        this.writers.add(this.bytesMessageWriter);
        this.streamMessageWriter = new ActiveMQStreamMessageWriter(this);
        this.writers.add(this.streamMessageWriter);
        this.mapMessageWriter = new ActiveMQMapMessageWriter(this);
        this.writers.add(this.mapMessageWriter);
        this.messageAckWriter = new MessageAckWriter(this);
        this.writers.add(this.messageAckWriter);
        this.receiptWriter = new ReceiptWriter();
        this.writers.add(this.receiptWriter);
        this.consumerInfoWriter = new ConsumerInfoWriter();
        this.writers.add(this.consumerInfoWriter);
        this.producerInfoWriter = new ProducerInfoWriter();
        this.writers.add(this.producerInfoWriter);
        this.transactionInfoWriter = new TransactionInfoWriter();
        this.writers.add(this.transactionInfoWriter);
        this.xaTransactionInfoWriter = new XATransactionInfoWriter();
        this.writers.add(this.xaTransactionInfoWriter);
        this.brokerInfoWriter = new BrokerInfoWriter();
        this.writers.add(this.brokerInfoWriter);
        this.connectionInfoWriter = new ConnectionInfoWriter();
        this.writers.add(this.connectionInfoWriter);
        this.sessionInfoWriter = new SessionInfoWriter();
        this.writers.add(this.sessionInfoWriter);
        this.durableUnsubscribeWriter = new DurableUnsubscribeWriter();
        this.writers.add(this.durableUnsubscribeWriter);
        this.reponseReceiptWriter = new ResponseReceiptWriter();
        this.writers.add(this.reponseReceiptWriter);
        this.intReponseReceiptWriter = new IntResponseReceiptWriter();
        this.writers.add(this.intReponseReceiptWriter);
        this.capacityInfoWriter = new CapacityInfoWriter();
        this.writers.add(this.capacityInfoWriter);
        this.capacityInfoRequestWriter = new CapacityInfoRequestWriter();
        this.writers.add(this.capacityInfoWriter);
        this.wireFormatInfoWriter = new WireFormatInfoWriter();
        this.writers.add(this.wireFormatInfoWriter);
        this.keepAliveWriter = new KeepAliveWriter();
        this.writers.add(this.keepAliveWriter);
        this.brokerAdminCommandWriter = new BrokerAdminCommandWriter();
        this.writers.add(this.brokerAdminCommandWriter);
        this.cachedValueWriter = new CachedValueWriter();
        this.writers.add(this.cachedValueWriter);
        this.cleanupConnectionAndSessionInfoWriter = new CleanupConnectionInfoWriter();
        this.writers.add(this.cleanupConnectionAndSessionInfoWriter);
    }

    private synchronized void updateCachedValue(short key, Object value) throws IOException {
        if (this.cachedValueWriter == null) {
            this.cachedValueWriter = new CachedValueWriter();
        }
        CachedValue cv = new CachedValue();
        cv.setId(key);
        cv.setValue(value);
        this.cachedBytesOut.reset();
        this.cachedValueWriter.writePacket(cv, this.cachedDataOut);
        this.cachedDataOut.flush();
        byte[] data = this.cachedBytesOut.getData();
        int count = this.cachedBytesOut.size();
        this.getTransportDataOut().writeByte(cv.getPacketType());
        this.getTransportDataOut().writeInt(count);
        this.getTransportDataOut().write(data, 0, count);
    }
}

