/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.message.util;

import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.codehaus.activemq.message.util.ByteArray;
import org.codehaus.activemq.message.util.WireByteArrayInputStream;
import org.codehaus.activemq.message.util.WireByteArrayOutputStream;
import org.codehaus.activemq.message.util.WireGZIPOutputStream;

public class ByteArrayCompression {
    public static final int DEFAULT_COMPRESSION_LIMIT = 32768;
    public static final int DEFAULT_COMPRESSION_LEVEL = 1;
    public static final int DEFAULT_COMPRESSION_STRATEGY = 0;
    private int compressionLimit = 32768;
    private int compressionLevel = 1;
    private int compressionStrategy = 0;

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public int getCompressionLimit() {
        return this.compressionLimit;
    }

    public void setCompressionLimit(int compressionLimit) {
        this.compressionLimit = compressionLimit;
    }

    public int getCompressionStrategy() {
        return this.compressionStrategy;
    }

    public void setCompressionStrategy(int compressionStrategy) {
        this.compressionStrategy = compressionStrategy;
    }

    public static boolean isCompressed(ByteArray ba) {
        boolean answer = false;
        if (ba != null && ba.getLength() > 2) {
            answer = (ba.get(0) & 0xFF | (ba.get(1) & 0xFF) << 8) == 35615;
        }
        return answer;
    }

    public ByteArray deflate(ByteArray ba) throws IOException {
        ByteArray answer = ba;
        if (ba != null && ba.getLength() > this.compressionLimit && !ByteArrayCompression.isCompressed(ba)) {
            WireByteArrayOutputStream bytesOut = new WireByteArrayOutputStream();
            WireGZIPOutputStream gzipOut = new WireGZIPOutputStream(bytesOut);
            gzipOut.getDeflater().setStrategy(this.compressionStrategy);
            gzipOut.getDeflater().setLevel(this.compressionLevel);
            gzipOut.write(ba.getBuf(), ba.getOffset(), ba.getLength());
            gzipOut.close();
            bytesOut.close();
            answer = new ByteArray(bytesOut.getData(), 0, bytesOut.size());
        }
        return answer;
    }

    public ByteArray inflate(ByteArray ba) throws IOException {
        ByteArray answer = ba;
        if (ba != null && ByteArrayCompression.isCompressed(ba)) {
            WireByteArrayInputStream bytesIn = new WireByteArrayInputStream(ba);
            GZIPInputStream gzipIn = new GZIPInputStream(bytesIn);
            WireByteArrayOutputStream bytesOut = new WireByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = gzipIn.read(buffer)) > 0) {
                bytesOut.write(buffer, 0, count);
            }
            bytesOut.close();
            answer = new ByteArray(bytesOut.getData(), 0, bytesOut.size());
        }
        return answer;
    }
}

