/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.boundedvm;

import java.util.List;
import javax.jms.JMSException;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.filter.Filter;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.util.MemoryBoundedQueue;
import org.codehaus.activemq.service.boundedvm.TransientSubscription;

public class TransientQueueSubscription
extends TransientSubscription {
    private MemoryBoundedQueue dispatchedQueue;

    public TransientQueueSubscription(BrokerClient client, MemoryBoundedQueue dispatchedQueue, Filter filter, ConsumerInfo info) {
        super(filter, info, client);
        this.dispatchedQueue = dispatchedQueue;
    }

    public boolean isTarget(ActiveMQMessage message) throws JMSException {
        boolean result = false;
        if (!(message == null || this.client.isClusteredConnection() && message.isEntryCluster(this.clusterName) && !message.isEntryBroker(this.brokerName))) {
            result = this.filter.matches(message) && (message.getJMSDeliveryMode() == 1 || this.consumerInfo.getDestination().isTemporary());
        }
        return result;
    }

    public boolean canAcceptMessages() {
        return this.dispatchedQueue.size() <= this.consumerInfo.getPrefetchNumber();
    }

    public void doDispatch(ActiveMQMessage message) throws JMSException {
        this.addDispatchedMessage(message);
        message = message.shallowCopy();
        message.setConsumerNos(new int[]{this.consumerInfo.getConsumerNo()});
        this.client.dispatch(message);
    }

    private void addDispatchedMessage(ActiveMQMessage message) {
        this.dispatchedQueue.enqueue(message);
    }

    public ActiveMQMessage acknowledgeMessage(String id) {
        ActiveMQMessage msg = this.dispatchedQueue.remove(id);
        return msg;
    }

    public List getUndeliveredMessages() {
        return this.dispatchedQueue.getContents();
    }

    public void close() {
        super.close();
        this.dispatchedQueue.close();
    }
}

