/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.impl;

import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.filter.FilterFactory;
import org.codehaus.activemq.filter.FilterFactoryImpl;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.service.DeadLetterPolicy;
import org.codehaus.activemq.service.Dispatcher;
import org.codehaus.activemq.service.MessageContainer;
import org.codehaus.activemq.service.RedeliveryPolicy;
import org.codehaus.activemq.service.Subscription;
import org.codehaus.activemq.service.SubscriptionContainer;
import org.codehaus.activemq.service.TransactionManager;
import org.codehaus.activemq.service.TransactionTask;
import org.codehaus.activemq.service.impl.DispatcherImpl;
import org.codehaus.activemq.service.impl.DurableTopicMessageContainerManager;
import org.codehaus.activemq.service.impl.SubscriptionContainerImpl;
import org.codehaus.activemq.store.PersistenceAdapter;

public class TransientTopicMessageContainerManager
extends DurableTopicMessageContainerManager {
    private static final Log log = LogFactory.getLog((Class)TransientTopicMessageContainerManager.class);

    public TransientTopicMessageContainerManager(PersistenceAdapter persistenceAdapter) {
        this(persistenceAdapter, new SubscriptionContainerImpl(new RedeliveryPolicy(), new DeadLetterPolicy()), new FilterFactoryImpl(), new DispatcherImpl());
    }

    public TransientTopicMessageContainerManager(PersistenceAdapter persistenceAdapter, SubscriptionContainer subscriptionContainer, FilterFactory filterFactory, Dispatcher dispatcher) {
        super(persistenceAdapter, subscriptionContainer, filterFactory, dispatcher);
    }

    public void addMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        if (info.getDestination().isTopic()) {
            this.doAddMessageConsumer(client, info);
        }
    }

    public void removeMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        Subscription sub = (Subscription)this.activeSubscriptions.remove(info.getConsumerId());
        if (sub != null) {
            sub.setActive(false);
            this.dispatcher.removeActiveSubscription(client, sub);
            this.subscriptionContainer.removeSubscription(info.getConsumerId());
            sub.clear();
        }
    }

    public void sendMessage(final BrokerClient client, final ActiveMQMessage message) throws JMSException {
        final ActiveMQDestination destination = message.getJMSActiveMQDestination();
        if (destination == null || !destination.isTopic()) {
            return;
        }
        TransactionManager.getContexTransaction().addPostCommitTask(new TransactionTask(){

            public void execute() throws Throwable {
                TransientTopicMessageContainerManager.this.doSendMessage(client, message, destination);
            }
        });
    }

    private void doSendMessage(BrokerClient client, ActiveMQMessage message, ActiveMQDestination destination) throws JMSException {
        MessageContainer container = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dispaching to " + this.subscriptionContainer + " subscriptions with message: " + message));
        }
        Set subscriptions = this.subscriptionContainer.getSubscriptions(destination);
        Iterator i = subscriptions.iterator();
        while (i.hasNext()) {
            Subscription sub = (Subscription)i.next();
            if (!sub.isTarget(message) || sub.isDurableTopic() && message.getJMSDeliveryMode() != 1) continue;
            if (container == null) {
                container = this.getContainer(message.getJMSDestination().toString());
                container.addMessage(message);
            }
            sub.addMessage(container, message);
        }
        this.updateSendStats(client, message);
    }

    public void deleteSubscription(String clientId, String subscriberName) throws JMSException {
    }
}

