/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.vm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.ProxyMessageStore;
import org.codehaus.activemq.store.ProxyTopicMessageStore;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.TransactionStore;

public class VMTransactionStore
implements TransactionStore {
    ConcurrentHashMap inflightTransactions = new ConcurrentHashMap();
    ConcurrentHashMap preparedTransactions = new ConcurrentHashMap();
    private boolean doingRecover;

    public MessageStore proxy(MessageStore messageStore) {
        return new ProxyMessageStore(messageStore){

            public void addMessage(ActiveMQMessage message) throws JMSException {
                VMTransactionStore.this.addMessage(this.getDelegate(), message);
            }

            public void removeMessage(MessageAck ack) throws JMSException {
                VMTransactionStore.this.removeMessage(this.getDelegate(), ack);
            }
        };
    }

    public TopicMessageStore proxy(TopicMessageStore messageStore) {
        return new ProxyTopicMessageStore(messageStore){

            public void addMessage(ActiveMQMessage message) throws JMSException {
                VMTransactionStore.this.addMessage(this.getDelegate(), message);
            }

            public void removeMessage(MessageAck ack) throws JMSException {
                VMTransactionStore.this.removeMessage(this.getDelegate(), ack);
            }
        };
    }

    public void prepare(Object txid) {
        Tx tx = (Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        this.preparedTransactions.put(txid, (Object)tx);
    }

    public Tx getTx(Object txid) {
        Tx tx = (Tx)this.inflightTransactions.get(txid);
        if (tx == null) {
            tx = new Tx();
            this.inflightTransactions.put(txid, (Object)tx);
        }
        return tx;
    }

    public void commit(Object txid, boolean wasPrepared) throws XAException {
        Tx tx = wasPrepared ? (Tx)this.preparedTransactions.remove(txid) : (Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        tx.commit();
    }

    public void rollback(Object txid) {
        this.preparedTransactions.remove(txid);
        this.inflightTransactions.remove(txid);
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void recover(TransactionStore.RecoveryListener listener) throws XAException {
        this.inflightTransactions.clear();
        this.doingRecover = true;
        try {
            Iterator iter = this.preparedTransactions.keySet().iterator();
            while (iter.hasNext()) {
                Object txid = iter.next();
                try {
                    Tx tx = (Tx)this.preparedTransactions.get(txid);
                    listener.recover((ActiveMQXid)txid, tx.getMessages(), tx.getAcks());
                }
                catch (JMSException e) {
                    throw (XAException)new XAException("Recovery of a transaction failed:").initCause(e);
                    return;
                }
            }
        }
        finally {
            this.doingRecover = false;
        }
    }

    void addMessage(final MessageStore destination, final ActiveMQMessage message) throws JMSException {
        if (this.doingRecover) {
            return;
        }
        if (message.isPartOfTransaction()) {
            Tx tx = this.getTx(message.getTransactionId());
            tx.add(new AddMessageCommand(){

                public ActiveMQMessage getMessage() {
                    return message;
                }

                public void run() throws JMSException {
                    destination.addMessage(message);
                }
            });
        } else {
            destination.addMessage(message);
        }
    }

    private void removeMessage(final MessageStore destination, final MessageAck ack) throws JMSException {
        if (this.doingRecover) {
            return;
        }
        if (ack.isPartOfTransaction()) {
            Tx tx = this.getTx(ack.getTransactionId());
            tx.add(new RemoveMessageCommand(){

                public MessageAck getMessageAck() {
                    return ack;
                }

                public void run() throws JMSException {
                    destination.removeMessage(ack);
                }
            });
        } else {
            destination.removeMessage(ack);
        }
    }

    public static interface RemoveMessageCommand {
        public MessageAck getMessageAck();

        public void run() throws JMSException;
    }

    public static interface AddMessageCommand {
        public ActiveMQMessage getMessage();

        public void run() throws JMSException;
    }

    public static class Tx {
        private ArrayList messages = new ArrayList();
        private ArrayList acks = new ArrayList();

        public void add(AddMessageCommand msg) {
            this.messages.add(msg);
        }

        public void add(RemoveMessageCommand ack) {
            this.acks.add(ack);
        }

        public ActiveMQMessage[] getMessages() {
            ActiveMQMessage[] rc = new ActiveMQMessage[this.messages.size()];
            int count = 0;
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                AddMessageCommand cmd = (AddMessageCommand)iter.next();
                rc[count++] = cmd.getMessage();
            }
            return rc;
        }

        public MessageAck[] getAcks() {
            MessageAck[] rc = new MessageAck[this.acks.size()];
            int count = 0;
            Iterator iter = this.acks.iterator();
            while (iter.hasNext()) {
                RemoveMessageCommand cmd = (RemoveMessageCommand)iter.next();
                rc[count++] = cmd.getMessageAck();
            }
            return rc;
        }

        public void commit() throws XAException {
            try {
                Object cmd;
                Iterator iter = this.messages.iterator();
                while (iter.hasNext()) {
                    cmd = (AddMessageCommand)iter.next();
                    cmd.run();
                }
                iter = this.acks.iterator();
                while (iter.hasNext()) {
                    cmd = (RemoveMessageCommand)iter.next();
                    cmd.run();
                }
            }
            catch (JMSException e) {
                throw (XAException)new XAException(-7).initCause(e);
            }
        }
    }
}

