/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelListener;
import org.codehaus.activemq.transport.TransportServerChannel;

public abstract class TransportServerChannelSupport
implements TransportServerChannel {
    private static final Log log = LogFactory.getLog((Class)TransportServerChannelSupport.class);
    private String url;
    private TransportChannelListener transportChannelListener;
    private List channels = new ArrayList();

    public TransportServerChannelSupport(URI url) {
        this(url.toString());
    }

    public TransportServerChannelSupport(String url) {
        this.url = url;
    }

    public void start() throws JMSException {
        if (this.transportChannelListener == null) {
            throw new JMSException("Must have a TransportChannelListener attached!");
        }
    }

    public synchronized void stop() throws JMSException {
        Iterator iter = this.channels.iterator();
        while (iter.hasNext()) {
            TransportChannel channel = (TransportChannel)iter.next();
            channel.stop();
        }
    }

    public TransportChannelListener getTransportChannelListener() {
        return this.transportChannelListener;
    }

    public void setTransportChannelListener(TransportChannelListener listener) {
        this.transportChannelListener = listener;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    protected synchronized void addClient(TransportChannel channel) {
        if (this.transportChannelListener == null) {
            log.warn((Object)("No listener attached, cannot add channel: " + channel));
        } else {
            this.transportChannelListener.addClient(channel);
            channel.setTransportChannelListener(this.transportChannelListener);
            this.channels.add(channel);
        }
    }

    protected String resolveHostName(String hostName) {
        String result = hostName;
        try {
            if (hostName != null && (hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1"))) {
                result = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException e) {
            log.debug((Object)"failed to resolve hostname", (Throwable)e);
        }
        return result;
    }
}

