/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport;

import java.net.URI;
import org.codehaus.activemq.transport.TransportChannel;

public class TransportStatusEvent {
    public static final int CONNECTED = 1;
    public static final int DISCONNECTED = 2;
    public static final int RECONNECTED = 3;
    public static final int FAILED = 4;
    public static final int STOPPED = 5;
    private URI remoteURI;
    private int channelStatus;
    private TransportChannel transportChannel;

    public TransportStatusEvent() {
    }

    public TransportStatusEvent(TransportChannel tc, int channelStatus) {
        this.transportChannel = tc;
        this.channelStatus = channelStatus;
    }

    public String toString() {
        return "Channel: " + this.transportChannel + " has " + this.getStatusAsString(this.channelStatus);
    }

    private String getStatusAsString(int status) {
        String result = null;
        switch (status) {
            case 1: {
                result = "connected";
                break;
            }
            case 2: {
                result = "disconnected";
                break;
            }
            case 3: {
                result = "reconnected";
                break;
            }
            case 4: {
                result = "failed";
                break;
            }
            case 5: {
                result = "stopped";
                break;
            }
            default: {
                result = "unknown";
            }
        }
        return result;
    }

    public int getChannelStatus() {
        return this.channelStatus;
    }

    public void setChannelStatus(int channelStatus) {
        this.channelStatus = channelStatus;
    }

    public TransportChannel getTransportChannel() {
        return this.transportChannel;
    }

    public void setTransportChannel(TransportChannel transportChannel) {
        this.transportChannel = transportChannel;
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public void setRemoteURI(URI remoteURI) {
        this.remoteURI = remoteURI;
    }
}

