/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.activeio;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.JMSException;
import org.activeio.AsynchChannelServer;
import org.activeio.ChannelFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.TransportServerChannel;
import org.codehaus.activemq.transport.TransportServerChannelFactory;
import org.codehaus.activemq.transport.activeio.ActiveIOTransportServerChannel;
import org.codehaus.activemq.transport.activeio.URIConverter;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class ActiveIOTransportServerChannelFactory
implements TransportServerChannelFactory {
    public TransportServerChannel create(WireFormat wireFormat, URI bindAddress) throws JMSException {
        AsynchChannelServer server = this.createAsynchChannelServer(bindAddress);
        return new ActiveIOTransportServerChannel(wireFormat, server);
    }

    private AsynchChannelServer createAsynchChannelServer(URI bindAddress) throws JMSException {
        try {
            bindAddress = URIConverter.convert(bindAddress);
            AsynchChannelServer server = new ChannelFactory().bindAsynchChannel(bindAddress);
            return server;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw JMSExceptionHelper.newJMSException(e.getMessage(), e);
        }
    }
}

