/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.web;

import javax.jms.JMSException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.activemq.broker.BrokerContainer;
import org.activemq.spring.SpringBrokerContainerFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.ServletContextResource;

public class SpringBrokerContextListener
implements ServletContextListener {
    public static final String INIT_PARAM_BROKER_URI = "brokerURI";
    private BrokerContainer brokerContainer;

    protected void setBrokerContainer(BrokerContainer container) {
        this.brokerContainer = container;
    }

    protected BrokerContainer getBrokerContainer() {
        return this.brokerContainer;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.log("Creating ActiveMQ Broker...");
        this.brokerContainer = this.createBroker(context);
        context.log("Starting ActiveMQ Broker");
        try {
            this.brokerContainer.start();
            context.log("Started ActiveMQ Broker");
        }
        catch (JMSException e) {
            context.log("Failed to start ActiveMQ broker: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        if (this.brokerContainer != null) {
            try {
                this.brokerContainer.stop();
            }
            catch (JMSException e) {
                context.log("Failed to stop the ActiveMQ Broker: " + (Object)((Object)e), (Throwable)e);
            }
            this.brokerContainer = null;
        }
    }

    protected BrokerContainer createBroker(ServletContext context) {
        String brokerURI = context.getInitParameter(INIT_PARAM_BROKER_URI);
        if (brokerURI == null) {
            brokerURI = "activemq.xml";
        }
        context.log("Loading ActiveMQ Broker configuration from: " + brokerURI);
        ServletContextResource resource = new ServletContextResource(context, brokerURI);
        return SpringBrokerContainerFactory.newInstance((Resource)resource);
    }
}

