/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.ListEventSourceMappingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListEventSourceMappingsRequestMarshaller
implements Marshaller<Request<ListEventSourceMappingsRequest>, ListEventSourceMappingsRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<ListEventSourceMappingsRequest> marshall(ListEventSourceMappingsRequest listEventSourceMappingsRequest) {
        String value;
        String name;
        if (listEventSourceMappingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listEventSourceMappingsRequest, "AWSLambda");
        String target = "AWSLambda.ListEventSourceMappings";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("EventSourceArn")) {
            name = DYNAMIC_QUERY_PARAMS.get("EventSourceArn");
            String string = value = listEventSourceMappingsRequest.getEventSourceArn() == null ? null : StringUtils.fromString((String)listEventSourceMappingsRequest.getEventSourceArn());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{EventSourceArn}", listEventSourceMappingsRequest.getEventSourceArn() == null ? "" : StringUtils.fromString((String)listEventSourceMappingsRequest.getEventSourceArn()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("FunctionName")) {
            name = DYNAMIC_QUERY_PARAMS.get("FunctionName");
            String string = value = listEventSourceMappingsRequest.getFunctionName() == null ? null : StringUtils.fromString((String)listEventSourceMappingsRequest.getFunctionName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{FunctionName}", listEventSourceMappingsRequest.getFunctionName() == null ? "" : StringUtils.fromString((String)listEventSourceMappingsRequest.getFunctionName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Marker")) {
            name = DYNAMIC_QUERY_PARAMS.get("Marker");
            String string = value = listEventSourceMappingsRequest.getMarker() == null ? null : StringUtils.fromString((String)listEventSourceMappingsRequest.getMarker());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Marker}", listEventSourceMappingsRequest.getMarker() == null ? "" : StringUtils.fromString((String)listEventSourceMappingsRequest.getMarker()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("MaxItems")) {
            name = DYNAMIC_QUERY_PARAMS.get("MaxItems");
            String string = value = listEventSourceMappingsRequest.getMaxItems() == null ? null : StringUtils.fromInteger((Integer)listEventSourceMappingsRequest.getMaxItems());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MaxItems}", listEventSourceMappingsRequest.getMaxItems() == null ? "" : StringUtils.fromInteger((Integer)listEventSourceMappingsRequest.getMaxItems()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }

    static {
        String path = "/2015-03-31/event-source-mappings/?Marker={Marker}&MaxItems={MaxItems}&FunctionName={FunctionName}&EventSourceArn={EventSourceArn}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

