/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.internal.stream;

import com.apptasticsoftware.rssreader.internal.stream.AutoCloseDoubleStream;
import com.apptasticsoftware.rssreader.internal.stream.AutoCloseIntStream;
import com.apptasticsoftware.rssreader.internal.stream.AutoCloseLongStream;
import com.apptasticsoftware.rssreader.internal.stream.AutoCloseStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class AbstractAutoCloseStream<T, S extends BaseStream<T, S>>
implements AutoCloseable {
    private final S stream;
    private final AtomicBoolean isClosed;

    AbstractAutoCloseStream(S stream) {
        this.stream = (BaseStream)Objects.requireNonNull(stream);
        this.isClosed = new AtomicBoolean();
    }

    protected S stream() {
        return this.stream;
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.stream().close();
        }
    }

    <R> R autoClose(Function<S, R> function) {
        try (S s = this.stream();){
            R r = function.apply(s);
            return r;
        }
    }

    <U> Stream<U> asAutoCloseStream(Stream<U> stream) {
        return this.asAutoCloseStream(stream, AutoCloseStream::new);
    }

    IntStream asAutoCloseStream(IntStream stream) {
        return this.asAutoCloseStream(stream, AutoCloseIntStream::new);
    }

    LongStream asAutoCloseStream(LongStream stream) {
        return this.asAutoCloseStream(stream, AutoCloseLongStream::new);
    }

    DoubleStream asAutoCloseStream(DoubleStream stream) {
        return this.asAutoCloseStream(stream, AutoCloseDoubleStream::new);
    }

    private <U> U asAutoCloseStream(U stream, UnaryOperator<U> wrapper) {
        if (stream instanceof AbstractAutoCloseStream) {
            return stream;
        }
        return (U)wrapper.apply(stream);
    }
}

