/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.Channel;
import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.Enclosure;
import com.apptasticsoftware.rssreader.Image;
import com.apptasticsoftware.rssreader.Item;
import com.apptasticsoftware.rssreader.internal.DaemonThreadFactory;
import com.apptasticsoftware.rssreader.internal.StreamUtil;
import com.apptasticsoftware.rssreader.internal.XMLInputFactorySecurity;
import com.apptasticsoftware.rssreader.internal.stream.AutoCloseStream;
import com.apptasticsoftware.rssreader.util.Default;
import com.apptasticsoftware.rssreader.util.Mapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractRssReader<C extends Channel, I extends Item> {
    private static final Logger LOGGER = Logger.getLogger("com.apptasticsoftware.rssreader");
    private static final ScheduledExecutorService EXECUTOR = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory("RssReaderWorker"));
    private static final Cleaner CLEANER = Cleaner.create();
    private final HttpClient httpClient;
    private DateTimeParser dateTimeParser = Default.getDateTimeParser();
    private String userAgent = "";
    private Duration connectionTimeout = Duration.ofSeconds(25L);
    private Duration requestTimeout = Duration.ofSeconds(25L);
    private Duration readTimeout = Duration.ofSeconds(25L);
    private final Map<String, String> headers = new HashMap<String, String>();
    private final HashMap<String, BiConsumer<C, String>> channelTags = new HashMap();
    private final HashMap<String, Map<String, BiConsumer<C, String>>> channelAttributes = new HashMap();
    private final HashMap<String, Consumer<I>> onItemTags = new HashMap();
    private final HashMap<String, BiConsumer<I, String>> itemTags = new HashMap();
    private final HashMap<String, Map<String, BiConsumer<I, String>>> itemAttributes = new HashMap();
    private final Set<String> collectChildNodesForTag = Set.of("content", "summary");
    private boolean isInitialized;

    protected AbstractRssReader() {
        this.httpClient = this.createHttpClient();
    }

    protected AbstractRssReader(HttpClient httpClient) {
        Objects.requireNonNull(httpClient, "Http client must not be null");
        this.httpClient = httpClient;
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    protected C createChannel() {
        return null;
    }

    protected abstract C createChannel(DateTimeParser var1);

    @Deprecated(since="3.5.0", forRemoval=true)
    protected I createItem() {
        return null;
    }

    protected abstract I createItem(DateTimeParser var1);

    protected void initialize() {
        this.registerChannelTags();
        this.registerChannelAttributes();
        this.registerItemTags();
        this.registerItemAttributes();
    }

    protected void registerChannelTags() {
        this.channelTags.putIfAbsent("title", (channel, value) -> Mapper.mapIfEmpty(value, channel::getTitle, channel::setTitle));
        this.channelTags.putIfAbsent("description", (channel, value) -> Mapper.mapIfEmpty(value, channel::getDescription, channel::setDescription));
        this.channelTags.putIfAbsent("/feed/title", Channel::setTitle);
        this.channelTags.putIfAbsent("/rss/channel/title", Channel::setTitle);
        this.channelTags.putIfAbsent("/rss/channel/description", Channel::setDescription);
        this.channelTags.putIfAbsent("subtitle", Channel::setDescription);
        this.channelTags.putIfAbsent("link", Channel::setLink);
        this.channelTags.putIfAbsent("category", Channel::addCategory);
        this.channelTags.putIfAbsent("language", Channel::setLanguage);
        this.channelTags.putIfAbsent("copyright", Channel::setCopyright);
        this.channelTags.putIfAbsent("rights", Channel::setCopyright);
        this.channelTags.putIfAbsent("generator", Channel::setGenerator);
        this.channelTags.putIfAbsent("ttl", Channel::setTtl);
        this.channelTags.putIfAbsent("pubDate", Channel::setPubDate);
        this.channelTags.putIfAbsent("lastBuildDate", Channel::setLastBuildDate);
        this.channelTags.putIfAbsent("updated", Channel::setLastBuildDate);
        this.channelTags.putIfAbsent("managingEditor", Channel::setManagingEditor);
        this.channelTags.putIfAbsent("webMaster", Channel::setWebMaster);
        this.channelTags.putIfAbsent("docs", Channel::setDocs);
        this.channelTags.putIfAbsent("rating", Channel::setRating);
        this.channelTags.putIfAbsent("/rss/channel/image/link", (channel, value) -> Mapper.createIfNull(channel::getImage, channel::setImage, Image::new).setLink((String)value));
        this.channelTags.putIfAbsent("/rss/channel/image/title", (channel, value) -> Mapper.createIfNull(channel::getImage, channel::setImage, Image::new).setTitle((String)value));
        this.channelTags.putIfAbsent("/rss/channel/image/url", (channel, value) -> Mapper.createIfNull(channel::getImage, channel::setImage, Image::new).setUrl((String)value));
        this.channelTags.putIfAbsent("/rss/channel/image/description", (channel, value) -> Mapper.createIfNullOptional(channel::getImage, channel::setImage, Image::new).ifPresent(i -> i.setDescription((String)value)));
        this.channelTags.putIfAbsent("/rss/channel/image/height", (channel, value) -> Mapper.createIfNullOptional(channel::getImage, channel::setImage, Image::new).ifPresent(i -> Mapper.mapInteger(value, i::setHeight)));
        this.channelTags.putIfAbsent("/rss/channel/image/width", (channel, value) -> Mapper.createIfNullOptional(channel::getImage, channel::setImage, Image::new).ifPresent(i -> Mapper.mapInteger(value, i::setWidth)));
        this.channelTags.putIfAbsent("dc:language", (channel, value) -> Mapper.mapIfEmpty(value, channel::getLanguage, channel::setLanguage));
        this.channelTags.putIfAbsent("dc:rights", (channel, value) -> Mapper.mapIfEmpty(value, channel::getCopyright, channel::setCopyright));
        this.channelTags.putIfAbsent("dc:title", (channel, value) -> Mapper.mapIfEmpty(value, channel::getTitle, channel::setTitle));
        this.channelTags.putIfAbsent("sy:updatePeriod", (channel, value) -> {
            channel.syUpdatePeriod = value;
        });
        this.channelTags.putIfAbsent("sy:updateFrequency", (channel, value) -> Mapper.mapInteger(value, number -> {
            channel.syUpdateFrequency = number;
        }));
        this.channelTags.putIfAbsent("/feed/icon", (channel, value) -> Mapper.createIfNull(channel::getImage, channel::setImage, Image::new).setUrl((String)value));
        this.channelTags.putIfAbsent("/feed/logo", (channel, value) -> Mapper.createIfNull(channel::getImage, channel::setImage, Image::new).setUrl((String)value));
    }

    protected void registerChannelAttributes() {
        this.channelAttributes.computeIfAbsent("link", k -> new HashMap()).put("href", Channel::setLink);
        this.channelAttributes.computeIfAbsent("category", k -> new HashMap()).putIfAbsent("term", Channel::addCategory);
    }

    protected void registerItemTags() {
        this.itemTags.putIfAbsent("guid", Item::setGuid);
        this.itemTags.putIfAbsent("id", Item::setGuid);
        this.itemTags.putIfAbsent("title", (item, value) -> Mapper.mapIfEmpty(value, item::getTitle, item::setTitle));
        this.itemTags.putIfAbsent("/feed/entry/title", Item::setTitle);
        this.itemTags.putIfAbsent("/rss/channel/item/title", Item::setTitle);
        this.itemTags.putIfAbsent("description", Item::setDescription);
        this.itemTags.putIfAbsent("summary", Item::setDescription);
        this.itemTags.putIfAbsent("content", Item::setContent);
        this.itemTags.putIfAbsent("content:encoded", (item, value) -> Mapper.mapIfEmpty(value, item::getContent, item::setContent));
        this.itemTags.putIfAbsent("link", Item::setLink);
        this.itemTags.putIfAbsent("author", Item::setAuthor);
        this.itemTags.putIfAbsent("/feed/entry/author/name", Item::setAuthor);
        this.itemTags.putIfAbsent("category", Item::addCategory);
        this.itemTags.putIfAbsent("pubDate", Item::setPubDate);
        this.itemTags.putIfAbsent("published", Item::setPubDate);
        this.itemTags.putIfAbsent("updated", (item, value) -> {
            item.setUpdated((String)value);
            Mapper.mapIfEmpty(value, item::getPubDate, item::setPubDate);
        });
        this.itemTags.putIfAbsent("comments", Item::setComments);
        this.itemTags.putIfAbsent("dc:creator", (item, value) -> Mapper.mapIfEmpty(value, item::getAuthor, item::setAuthor));
        this.itemTags.putIfAbsent("dc:date", (item, value) -> Mapper.mapIfEmpty(value, item::getPubDate, item::setPubDate));
        this.itemTags.putIfAbsent("dc:identifier", (item, value) -> Mapper.mapIfEmpty(value, item::getGuid, item::setGuid));
        this.itemTags.putIfAbsent("dc:title", (item, value) -> Mapper.mapIfEmpty(value, item::getTitle, item::setTitle));
        this.itemTags.putIfAbsent("dc:description", (item, value) -> Mapper.mapIfEmpty(value, item::getDescription, item::setDescription));
        this.onItemTags.put("enclosure", item -> item.addEnclosure(new Enclosure()));
    }

    protected void registerItemAttributes() {
        this.itemAttributes.computeIfAbsent("link", k -> new HashMap()).putIfAbsent("href", Item::setLink);
        this.itemAttributes.computeIfAbsent("guid", k -> new HashMap()).putIfAbsent("isPermaLink", (item, value) -> item.setIsPermaLink(Boolean.parseBoolean(value)));
        this.itemAttributes.computeIfAbsent("category", k -> new HashMap()).putIfAbsent("term", Item::addCategory);
        Map enclosureAttributes = this.itemAttributes.computeIfAbsent("enclosure", k -> new HashMap());
        enclosureAttributes.putIfAbsent("url", (item, value) -> item.getEnclosure().ifPresent(a -> a.setUrl((String)value)));
        enclosureAttributes.putIfAbsent("type", (item, value) -> item.getEnclosure().ifPresent(a -> a.setType((String)value)));
        enclosureAttributes.putIfAbsent("length", (item, value) -> item.getEnclosure().ifPresent(e -> Mapper.mapLong(value, e::setLength)));
    }

    public AbstractRssReader<C, I> setDateTimeParser(DateTimeParser dateTimeParser) {
        Objects.requireNonNull(dateTimeParser, "Date time parser must not be null");
        this.dateTimeParser = dateTimeParser;
        return this;
    }

    public AbstractRssReader<C, I> setUserAgent(String userAgent) {
        Objects.requireNonNull(userAgent, "User-agent must not be null");
        this.userAgent = userAgent;
        return this;
    }

    public AbstractRssReader<C, I> addHeader(String key, String value) {
        Objects.requireNonNull(key, "Key must not be null");
        Objects.requireNonNull(value, "Value must not be null");
        this.headers.put(key, value);
        return this;
    }

    public AbstractRssReader<C, I> setConnectionTimeout(Duration connectionTimeout) {
        this.validate(connectionTimeout, "Connection timeout");
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public AbstractRssReader<C, I> setRequestTimeout(Duration requestTimeout) {
        this.validate(requestTimeout, "Request timeout");
        this.requestTimeout = requestTimeout;
        return this;
    }

    public AbstractRssReader<C, I> setReadTimeout(Duration readTimeout) {
        this.validate(readTimeout, "Read timeout");
        this.readTimeout = readTimeout;
        return this;
    }

    private void validate(Duration duration, String name) {
        Objects.requireNonNull(duration, name + " must not be null");
        if (duration.isNegative()) {
            throw new IllegalArgumentException(name + " must not be negative");
        }
    }

    public AbstractRssReader<C, I> addItemExtension(String tag, BiConsumer<I, String> consumer) {
        Objects.requireNonNull(tag, "Item tag must not be null");
        Objects.requireNonNull(consumer, "Item consumer must not be null");
        this.itemTags.put(tag, consumer);
        return this;
    }

    public AbstractRssReader<C, I> addItemExtension(String tag, String attribute, BiConsumer<I, String> consumer) {
        Objects.requireNonNull(tag, "Item tag must not be null");
        Objects.requireNonNull(attribute, "Item attribute must not be null");
        Objects.requireNonNull(consumer, "Item consumer must not be null");
        this.itemAttributes.computeIfAbsent(tag, k -> new HashMap()).put(attribute, consumer);
        return this;
    }

    public AbstractRssReader<C, I> addChannelExtension(String tag, BiConsumer<C, String> consumer) {
        Objects.requireNonNull(tag, "Channel tag must not be null");
        Objects.requireNonNull(consumer, "Channel consumer must not be null");
        this.channelTags.put(tag, consumer);
        return this;
    }

    public AbstractRssReader<C, I> addChannelExtension(String tag, String attribute, BiConsumer<C, String> consumer) {
        Objects.requireNonNull(tag, "Channel tag must not be null");
        Objects.requireNonNull(attribute, "Channel attribute must not be null");
        Objects.requireNonNull(consumer, "Channel consumer must not be null");
        this.channelAttributes.computeIfAbsent(tag, k -> new HashMap()).put(attribute, consumer);
        return this;
    }

    public Stream<I> read(String url) throws IOException {
        Objects.requireNonNull(url, "URL must not be null");
        try {
            return this.readAsync(url).get(1L, TimeUnit.MINUTES);
        }
        catch (CompletionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException e2) {
                throw e2;
            }
            catch (Throwable e2) {
                throw new AssertionError((Object)e2);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    public Stream<Item> read(Collection<String> urls) {
        Objects.requireNonNull(urls, "URLs collection must not be null");
        urls.forEach(url -> Objects.requireNonNull(url, "URL must not be null. Url: " + url));
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        return AutoCloseStream.of(((Stream)urls.stream().parallel()).map(url -> {
            try {
                return Map.entry(url, this.readAsync((String)url));
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, () -> String.format("Failed read URL %s. Message: %s", url, e.getMessage()));
                }
                return null;
            }
        }).filter(Objects::nonNull).flatMap(f -> {
            try {
                return (Stream)((CompletableFuture)f.getValue()).join();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, () -> String.format("Failed to read URL %s. Message: %s", f.getKey(), e.getMessage()));
                }
                return Stream.empty();
            }
        }));
    }

    public Stream<I> read(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "Input stream must not be null");
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        inputStream = new BufferedInputStream(inputStream);
        this.removeBadData(inputStream);
        RssItemIterator itemIterator = new RssItemIterator(inputStream);
        return AutoCloseStream.of((Stream)StreamUtil.asStream(itemIterator).onClose(itemIterator::close));
    }

    public CompletableFuture<Stream<I>> readAsync(String url) {
        Objects.requireNonNull(url, "URL must not be null");
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        try {
            URI uri = URI.create(url);
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return this.read(new FileInputStream(uri.getPath()));
                    }
                    catch (FileNotFoundException e) {
                        throw new CompletionException(e);
                    }
                });
            }
            return this.sendAsyncRequest(url).thenApply(this.processResponse());
        }
        catch (IllegalArgumentException e) {
            return CompletableFuture.supplyAsync(() -> {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(url.getBytes(StandardCharsets.UTF_8));
                return this.read(inputStream);
            });
        }
    }

    protected CompletableFuture<HttpResponse<InputStream>> sendAsyncRequest(String url) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url)).header("Accept-Encoding", "gzip");
        if (this.requestTimeout.toMillis() > 0L) {
            builder.timeout(this.requestTimeout);
        }
        if (!this.userAgent.isBlank()) {
            builder.header("User-Agent", this.userAgent);
        }
        this.headers.forEach(builder::header);
        return this.httpClient.sendAsync(builder.GET().build(), HttpResponse.BodyHandlers.ofInputStream());
    }

    private Function<HttpResponse<InputStream>, Stream<I>> processResponse() {
        return response -> {
            try {
                if (response.statusCode() >= 400 && response.statusCode() < 600) {
                    throw new IOException(String.format("Response HTTP status code: %d", response.statusCode()));
                }
                InputStream inputStream = (InputStream)response.body();
                if ("gzip".equals(response.headers().firstValue("Content-Encoding").orElse(null))) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                inputStream = new BufferedInputStream(inputStream);
                this.removeBadData(inputStream);
                RssItemIterator itemIterator = new RssItemIterator(inputStream);
                return AutoCloseStream.of((Stream)StreamUtil.asStream(itemIterator).onClose(itemIterator::close));
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        };
    }

    private void removeBadData(InputStream inputStream) {
        try {
            inputStream.mark(128);
            long count = 0L;
            int data = inputStream.read();
            while (Character.isWhitespace(data)) {
                data = inputStream.read();
                ++count;
            }
            inputStream.reset();
            inputStream.skip(count);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HttpClient createHttpClient() {
        HttpClient client;
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.3");
            context.init(null, null, null);
            HttpClient.Builder builder = HttpClient.newBuilder().sslContext(context).followRedirects(HttpClient.Redirect.ALWAYS);
            if (this.connectionTimeout.toMillis() > 0L) {
                builder.connectTimeout(this.connectionTimeout);
            }
            client = builder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS);
            if (this.connectionTimeout.toMillis() > 0L) {
                builder.connectTimeout(this.connectionTimeout);
            }
            client = builder.build();
        }
        return client;
    }

    class RssItemIterator
    implements Iterator<I>,
    AutoCloseable {
        private final StringBuilder textBuilder = new StringBuilder();
        private final Map<String, StringBuilder> childNodeTextBuilder = new HashMap<String, StringBuilder>();
        private final Deque<String> elementStack = new ArrayDeque<String>();
        private XMLStreamReader reader;
        private C channel;
        private I item = null;
        private I nextItem = null;
        private boolean isChannelPart = false;
        private boolean isItemPart = false;
        private ScheduledFuture<?> parseWatchdog;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private Cleaner.Cleanable cleanable;

        public RssItemIterator(InputStream is) {
            try {
                XMLInputFactory xmlInputFactory = XMLInputFactorySecurity.hardenFactory(XMLInputFactory.newInstance());
                xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
                xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
                this.reader = xmlInputFactory.createXMLStreamReader(is);
                this.cleanable = CLEANER.register(this, new CleaningAction(this.reader, is));
                if (!AbstractRssReader.this.readTimeout.isZero()) {
                    this.parseWatchdog = EXECUTOR.schedule(this::close, AbstractRssReader.this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.WARNING, "Failed to process XML.", e);
            }
        }

        @Override
        public void close() {
            if (this.isClosed.compareAndSet(false, true)) {
                this.cleanable.clean();
                if (this.parseWatchdog != null) {
                    this.parseWatchdog.cancel(false);
                }
            }
        }

        private void peekNext() {
            if (this.nextItem == null) {
                try {
                    this.nextItem = this.next();
                }
                catch (NoSuchElementException e) {
                    this.nextItem = null;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.peekNext();
            return this.nextItem != null;
        }

        @Override
        public I next() {
            if (this.nextItem != null) {
                Object next = this.nextItem;
                this.nextItem = null;
                return next;
            }
            try {
                while (this.reader.hasNext()) {
                    boolean itemParsed;
                    int type = this.reader.next();
                    this.collectChildNodes(type);
                    if (type == 4 || type == 12) {
                        this.parseCharacters();
                        continue;
                    }
                    if (type == 1) {
                        this.parseStartElement();
                        this.parseAttributes();
                        continue;
                    }
                    if (type != 2 || !(itemParsed = this.parseEndElement())) continue;
                    return this.item;
                }
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.WARNING, "Failed to parse XML.", e);
            }
            this.close();
            throw new NoSuchElementException();
        }

        private void collectChildNodes(int type) {
            if (type == 1) {
                String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
                if (!this.childNodeTextBuilder.isEmpty()) {
                    int i;
                    StringBuilder startTagBuilder = new StringBuilder("<").append(nsTagName);
                    for (i = 0; i < this.reader.getNamespaceCount(); ++i) {
                        startTagBuilder.append(" ").append(this.toNamespacePrefix(this.reader.getNamespacePrefix(i))).append("=").append(this.reader.getNamespaceURI(i));
                    }
                    for (i = 0; i < this.reader.getAttributeCount(); ++i) {
                        startTagBuilder.append(" ").append(this.toNsName(this.reader.getAttributePrefix(i), this.reader.getAttributeLocalName(i))).append("=").append(this.reader.getAttributeValue(i));
                    }
                    startTagBuilder.append(">");
                    String startTag = startTagBuilder.toString();
                    this.childNodeTextBuilder.entrySet().stream().filter(e -> !((String)e.getKey()).equals(nsTagName)).forEach(e -> ((StringBuilder)e.getValue()).append(startTag));
                }
                if (AbstractRssReader.this.collectChildNodesForTag.contains(nsTagName)) {
                    this.childNodeTextBuilder.put(nsTagName, new StringBuilder());
                }
            } else if (type == 4 || type == 12) {
                this.childNodeTextBuilder.forEach((k, builder) -> builder.append(this.reader.getText()));
            } else if (type == 2) {
                String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
                String endTag = "</" + nsTagName + ">";
                this.childNodeTextBuilder.entrySet().stream().filter(e -> !((String)e.getKey()).equals(nsTagName)).forEach(e -> ((StringBuilder)e.getValue()).append(endTag));
            }
        }

        private void parseStartElement() {
            this.textBuilder.setLength(0);
            String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
            this.elementStack.addLast(nsTagName);
            if (this.isChannel(nsTagName)) {
                this.channel = (Channel)Objects.requireNonNullElse(AbstractRssReader.this.createChannel(AbstractRssReader.this.dateTimeParser), AbstractRssReader.this.createChannel());
                ((Channel)this.channel).setTitle("");
                ((Channel)this.channel).setDescription("");
                ((Channel)this.channel).setLink("");
                this.isChannelPart = true;
            } else if (this.isItem(nsTagName)) {
                this.item = (Item)Objects.requireNonNullElse(AbstractRssReader.this.createItem(AbstractRssReader.this.dateTimeParser), AbstractRssReader.this.createItem());
                ((Item)this.item).setChannel((Channel)this.channel);
                this.isChannelPart = false;
                this.isItemPart = true;
            }
        }

        protected boolean isChannel(String tagName) {
            return "channel".equals(tagName) || "feed".equals(tagName);
        }

        protected boolean isItem(String tagName) {
            return "item".equals(tagName) || "entry".equals(tagName);
        }

        private void parseAttributes() {
            String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
            String elementFullPath = this.getElementFullPath();
            if (this.isChannelPart) {
                this.mapChannelAttributes(nsTagName);
                this.mapChannelAttributes(elementFullPath);
            } else if (this.isItemPart) {
                AbstractRssReader.this.onItemTags.computeIfPresent(nsTagName, (k, f) -> {
                    f.accept(this.item);
                    return f;
                });
                AbstractRssReader.this.onItemTags.computeIfPresent(this.getElementFullPath(), (k, f) -> {
                    f.accept(this.item);
                    return f;
                });
                this.mapItemAttributes(nsTagName);
                this.mapItemAttributes(elementFullPath);
            }
        }

        private void mapChannelAttributes(String key) {
            Map consumers = AbstractRssReader.this.channelAttributes.get(key);
            if (consumers != null && this.channel != null) {
                consumers.forEach((attributeName, consumer) -> {
                    Optional<String> attributeValue = Optional.ofNullable(this.reader.getAttributeValue(null, (String)attributeName));
                    attributeValue.ifPresent(v -> consumer.accept(this.channel, v));
                });
            }
        }

        private void mapItemAttributes(String key) {
            Map consumers = AbstractRssReader.this.itemAttributes.get(key);
            if (consumers != null && this.item != null) {
                consumers.forEach((attributeName, consumer) -> {
                    Optional<String> attributeValue = Optional.ofNullable(this.reader.getAttributeValue(null, (String)attributeName));
                    attributeValue.ifPresent(v -> consumer.accept(this.item, v));
                });
            }
        }

        private boolean parseEndElement() {
            String nsTagName = this.toNsName(this.reader.getPrefix(), this.reader.getLocalName());
            String text = this.textBuilder.toString().trim();
            String elementFullPath = this.getElementFullPath();
            this.elementStack.removeLast();
            if (this.isChannelPart) {
                this.parseChannelCharacters(this.channel, nsTagName, elementFullPath, text);
            } else {
                this.parseItemCharacters(this.item, nsTagName, elementFullPath, text);
            }
            this.textBuilder.setLength(0);
            return this.isItem(nsTagName);
        }

        private void parseCharacters() {
            String text = this.reader.getText();
            if (text.isBlank()) {
                return;
            }
            this.textBuilder.append(text);
        }

        private void parseChannelCharacters(C channel, String nsTagName, String elementFullPath, String text) {
            if (channel == null || text.isEmpty()) {
                return;
            }
            AbstractRssReader.this.channelTags.computeIfPresent(nsTagName, (k, f) -> {
                f.accept(channel, text);
                return f;
            });
            AbstractRssReader.this.channelTags.computeIfPresent(elementFullPath, (k, f) -> {
                f.accept(channel, text);
                return f;
            });
        }

        private void parseItemCharacters(I item, String nsTagName, String elementFullPath, String text) {
            StringBuilder builder = this.childNodeTextBuilder.remove(nsTagName);
            if (item == null || text.isEmpty() && builder == null) {
                return;
            }
            String textValue = builder != null ? builder.toString().trim() : text;
            AbstractRssReader.this.itemTags.computeIfPresent(nsTagName, (k, f) -> {
                f.accept(item, textValue);
                return f;
            });
            AbstractRssReader.this.itemTags.computeIfPresent(elementFullPath, (k, f) -> {
                f.accept(item, text);
                return f;
            });
        }

        private String toNsName(String prefix, String name) {
            return prefix.isEmpty() ? name : prefix + ":" + name;
        }

        private String toNamespacePrefix(String prefix) {
            return prefix == null || prefix.isEmpty() ? "xmlns" : "xmlns:" + prefix;
        }

        private String getElementFullPath() {
            return "/" + String.join((CharSequence)"/", this.elementStack);
        }
    }

    private static class CleaningAction
    implements Runnable {
        private final XMLStreamReader xmlStreamReader;
        private final List<AutoCloseable> resources;

        public CleaningAction(XMLStreamReader xmlStreamReader, AutoCloseable ... resources) {
            this.xmlStreamReader = xmlStreamReader;
            this.resources = List.of(resources);
        }

        @Override
        public void run() {
            try {
                if (this.xmlStreamReader != null) {
                    this.xmlStreamReader.close();
                }
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.WARNING, "Failed to close XML stream. ", e);
            }
            for (AutoCloseable resource : this.resources) {
                try {
                    if (resource == null) continue;
                    resource.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to close resource. ", e);
                }
            }
        }
    }
}

