/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.toolkit;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.p6spy.engine.spy.P6DataSource;
import io.seata.rm.datasource.DataSourceProxy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.sql.DataSource;

public final class DatabasebUtils {
    private static boolean seataExist;
    private static boolean p6spyExist;

    public static void closeDataSource(DataSource dataSource) throws Exception {
        if (dataSource instanceof ItemDataSource) {
            ((ItemDataSource)((Object)dataSource)).close();
        } else {
            if (seataExist && dataSource instanceof DataSourceProxy) {
                DataSourceProxy dataSourceProxy = (DataSourceProxy)dataSource;
                dataSource = dataSourceProxy.getTargetDataSource();
            }
            if (p6spyExist && dataSource instanceof P6DataSource) {
                Field realDataSourceField = P6DataSource.class.getDeclaredField("realDataSource");
                realDataSourceField.setAccessible(true);
                dataSource = (DataSource)realDataSourceField.get(dataSource);
            }
            Class<?> clazz = dataSource.getClass();
            Method closeMethod = clazz.getDeclaredMethod("close", new Class[0]);
            closeMethod.invoke((Object)dataSource, new Object[0]);
        }
    }

    private DatabasebUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try {
            Class.forName("io.seata.rm.datasource.DataSourceProxy");
            seataExist = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("com.p6spy.engine.spy.P6DataSource");
            p6spyExist = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

