/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class MybatisDefaultParameterHandler
extends DefaultParameterHandler {
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final MappedStatement mappedStatement;
    private final Object parameterObject;
    private final BoundSql boundSql;
    private final Configuration configuration;

    public MybatisDefaultParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        super(mappedStatement, MybatisDefaultParameterHandler.processParameter(mappedStatement, parameterObject), boundSql);
        this.mappedStatement = mappedStatement;
        this.configuration = mappedStatement.getConfiguration();
        this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        this.parameterObject = parameterObject;
        this.boundSql = boundSql;
    }

    protected static Object processParameter(MappedStatement ms, Object parameterObject) {
        if (parameterObject != null && (SqlCommandType.INSERT == ms.getSqlCommandType() || SqlCommandType.UPDATE == ms.getSqlCommandType())) {
            if (ReflectionKit.isPrimitiveOrWrapper(parameterObject.getClass()) || parameterObject.getClass() == String.class) {
                return parameterObject;
            }
            Collection<Object> parameters = MybatisDefaultParameterHandler.getParameters(parameterObject);
            if (null != parameters) {
                parameters.stream().filter(Objects::nonNull).forEach(obj -> MybatisDefaultParameterHandler.process(ms, obj));
            } else {
                MybatisDefaultParameterHandler.process(ms, parameterObject);
            }
        }
        return parameterObject;
    }

    private static void process(MappedStatement ms, Object parameterObject) {
        TableInfo tableInfo = null;
        Object entity = parameterObject;
        if (parameterObject instanceof Map) {
            Object et;
            Map map = (Map)parameterObject;
            if (map.containsKey("et") && (et = map.get("et")) != null) {
                if (et instanceof Map) {
                    Map realEtMap = (Map)et;
                    if (realEtMap.containsKey("MP_OPTLOCK_ET_ORIGINAL")) {
                        entity = realEtMap.get("MP_OPTLOCK_ET_ORIGINAL");
                        tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
                    }
                } else {
                    entity = et;
                    tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
                }
            }
        } else {
            tableInfo = TableInfoHelper.getTableInfo(parameterObject.getClass());
        }
        if (tableInfo != null) {
            MetaObject metaObject = ms.getConfiguration().newMetaObject(entity);
            if (SqlCommandType.INSERT == ms.getSqlCommandType()) {
                MybatisDefaultParameterHandler.populateKeys(tableInfo, metaObject, entity);
                MybatisDefaultParameterHandler.insertFill(metaObject, tableInfo);
            } else {
                MybatisDefaultParameterHandler.updateFill(metaObject, tableInfo);
            }
        }
    }

    protected static Collection<Object> getParameters(Object parameter) {
        List<Object> parameters = null;
        if (parameter instanceof Collection) {
            parameters = (List<Object>)parameter;
        } else if (parameter instanceof Map) {
            Map parameterMap = (Map)parameter;
            if (parameterMap.containsKey("collection")) {
                parameters = (Collection)parameterMap.get("collection");
            } else if (parameterMap.containsKey("list")) {
                parameters = (List)parameterMap.get("list");
            } else if (parameterMap.containsKey("array")) {
                parameters = Arrays.asList((Object[])parameterMap.get("array"));
            }
        }
        return parameters;
    }

    protected static void populateKeys(TableInfo tableInfo, MetaObject metaObject, Object entity) {
        IdType idType = tableInfo.getIdType();
        String keyProperty = tableInfo.getKeyProperty();
        if (StringUtils.isNotBlank(keyProperty) && null != idType && idType.getKey() >= 3) {
            IdentifierGenerator identifierGenerator = GlobalConfigUtils.getGlobalConfig(tableInfo.getConfiguration()).getIdentifierGenerator();
            Object idValue = metaObject.getValue(keyProperty);
            if (StringUtils.checkValNull(idValue)) {
                if (idType.getKey() == IdType.ASSIGN_ID.getKey()) {
                    if (Number.class.isAssignableFrom(tableInfo.getKeyType())) {
                        metaObject.setValue(keyProperty, (Object)identifierGenerator.nextId(entity));
                    } else {
                        metaObject.setValue(keyProperty, (Object)identifierGenerator.nextId(entity).toString());
                    }
                } else if (idType.getKey() == IdType.ASSIGN_UUID.getKey()) {
                    metaObject.setValue(keyProperty, (Object)identifierGenerator.nextUUID(entity));
                }
            }
        }
    }

    protected static void insertFill(MetaObject metaObject, TableInfo tableInfo) {
        GlobalConfigUtils.getMetaObjectHandler(tableInfo.getConfiguration()).ifPresent(metaObjectHandler -> {
            if (metaObjectHandler.openInsertFill()) {
                Object value;
                String keyProperty;
                if (tableInfo.isWithInsertFill()) {
                    metaObjectHandler.insertFill(metaObject);
                } else if (metaObjectHandler.compatibleFillId() && StringUtils.isNotBlank(keyProperty = tableInfo.getKeyProperty()) && (value = metaObject.getValue(keyProperty)) == null && (IdType.NONE == tableInfo.getIdType() || IdType.INPUT == tableInfo.getIdType())) {
                    metaObjectHandler.insertFill(metaObject);
                }
            }
        });
    }

    protected static void updateFill(MetaObject metaObject, TableInfo tableInfo) {
        GlobalConfigUtils.getMetaObjectHandler(tableInfo.getConfiguration()).ifPresent(metaObjectHandler -> {
            if (metaObjectHandler.openUpdateFill() && tableInfo.isWithUpdateFill()) {
                metaObjectHandler.updateFill(metaObject);
            }
        });
    }

    public void setParameters(PreparedStatement ps) {
        ErrorContext.instance().activity("setting parameters").object(this.mappedStatement.getParameterMap().getId());
        List parameterMappings = this.boundSql.getParameterMappings();
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (this.boundSql.hasAdditionalParameter(propertyName)) {
                    value = this.boundSql.getAdditionalParameter(propertyName);
                } else if (this.parameterObject == null) {
                    value = null;
                } else if (this.typeHandlerRegistry.hasTypeHandler(this.parameterObject.getClass())) {
                    value = this.parameterObject;
                } else {
                    MetaObject metaObject = this.configuration.newMetaObject(this.parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                JdbcType jdbcType = parameterMapping.getJdbcType();
                if (value == null && jdbcType == null) {
                    jdbcType = this.configuration.getJdbcTypeForNull();
                }
                try {
                    typeHandler.setParameter(ps, i + 1, value, jdbcType);
                    continue;
                }
                catch (SQLException | TypeException e) {
                    throw new TypeException("Could not set parameters for mapping: " + parameterMapping + ". Cause: " + e, e);
                }
            }
        }
    }
}

