/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.update;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.Update;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlInjectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class UpdateWrapper<T>
extends AbstractWrapper<T, String, UpdateWrapper<T>>
implements Update<UpdateWrapper<T>, String> {
    private final List<String> sqlSet;
    private boolean checkSqlInjection;

    public UpdateWrapper() {
        this(null);
    }

    public UpdateWrapper(T entity) {
        super.setEntity(entity);
        super.initNeed();
        this.sqlSet = new ArrayList<String>();
    }

    private UpdateWrapper(T entity, List<String> sqlSet, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString paramAlias, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst) {
        super.setEntity(entity);
        this.sqlSet = sqlSet;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.paramAlias = paramAlias;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
    }

    public UpdateWrapper<T> checkSqlInjection() {
        this.checkSqlInjection = true;
        return this;
    }

    @Override
    protected String columnToString(String column) {
        if (this.checkSqlInjection && SqlInjectionUtils.check(column)) {
            throw new MybatisPlusException("Discovering SQL injection column: " + column);
        }
        return column;
    }

    @Override
    public String getSqlSet() {
        if (CollectionUtils.isEmpty(this.sqlSet)) {
            return null;
        }
        return String.join((CharSequence)",", this.sqlSet);
    }

    @Override
    public UpdateWrapper<T> set(boolean condition, String column, Object val, String mapping) {
        return (UpdateWrapper)this.maybeDo(condition, () -> {
            String sql = this.formatParam(mapping, val);
            this.sqlSet.add(column + "=" + sql);
        });
    }

    @Override
    public UpdateWrapper<T> setSql(boolean condition, String setSql, Object ... params) {
        if (condition && StringUtils.isNotBlank(setSql)) {
            this.sqlSet.add(this.formatSqlMaybeWithParam(setSql, params));
        }
        return (UpdateWrapper)this.typedThis;
    }

    public LambdaUpdateWrapper<T> lambda() {
        return new LambdaUpdateWrapper(this.getEntity(), this.getEntityClass(), this.sqlSet, this.paramNameSeq, this.paramNameValuePairs, this.expression, this.paramAlias, this.lastSql, this.sqlComment, this.sqlFirst);
    }

    @Override
    protected UpdateWrapper<T> instance() {
        return new UpdateWrapper(this.getEntity(), null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), this.paramAlias, SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString());
    }

    @Override
    public void clear() {
        super.clear();
        this.sqlSet.clear();
    }
}

