/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.examples.deltaspike.data.rest.controller;

import com.blazebit.persistence.deltaspike.data.KeysetAwarePage;
import com.blazebit.persistence.deltaspike.data.KeysetPageable;
import com.blazebit.persistence.deltaspike.data.Page;
import com.blazebit.persistence.deltaspike.data.Pageable;
import com.blazebit.persistence.deltaspike.data.Specification;
import com.blazebit.persistence.deltaspike.data.rest.KeysetConfig;
import com.blazebit.persistence.examples.deltaspike.data.rest.filter.Filter;
import com.blazebit.persistence.examples.deltaspike.data.rest.model.Cat;
import com.blazebit.persistence.examples.deltaspike.data.rest.repository.CatRepository;
import com.blazebit.persistence.examples.deltaspike.data.rest.repository.CatViewRepository;
import com.blazebit.persistence.examples.deltaspike.data.rest.view.CatWithOwnerView;
import com.blazebit.text.FormatUtils;
import com.blazebit.text.SerializableFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="")
public class CatRestController {
    private static final Map<String, SerializableFormat<?>> FILTER_ATTRIBUTES;
    @Inject
    private CatRepository catRepository;
    @Inject
    private CatViewRepository catViewRepository;

    @GET
    @Path(value="/cats")
    @Produces(value={"application/json"})
    public Page<Cat> findPaginated(@KeysetConfig(value=Cat.class) KeysetPageable keysetPageable, @QueryParam(value="filter") Filter[] filters) {
        Specification specification = this.getSpecificationForFilter(filters);
        KeysetAwarePage resultPage = this.catRepository.findAll(specification, (Pageable)keysetPageable);
        if (keysetPageable.getPageNumber() > resultPage.getTotalPages()) {
            throw new RuntimeException("Invalid page number!");
        }
        return resultPage;
    }

    @GET
    @Path(value="/cat-views")
    @Produces(value={"application/json"})
    public Page<CatWithOwnerView> findPaginatedViews(@KeysetConfig(value=Cat.class) KeysetPageable keysetPageable, @QueryParam(value="filter") Filter[] filters) {
        Specification specification = this.getSpecificationForFilter(filters);
        KeysetAwarePage resultPage = this.catViewRepository.findAll(specification, (Pageable)keysetPageable);
        if (keysetPageable.getPageNumber() > resultPage.getTotalPages()) {
            throw new RuntimeException("Invalid page number!");
        }
        return resultPage;
    }

    private Specification<Cat> getSpecificationForFilter(Filter[] filters) {
        if (filters == null || filters.length == 0) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Map access$100() {
        return FILTER_ATTRIBUTES;
    }

    static {
        HashMap<String, SerializableFormat> filterAttributes = new HashMap<String, SerializableFormat>();
        filterAttributes.put("id", (SerializableFormat)FormatUtils.getAvailableFormatters().get(Long.class));
        filterAttributes.put("name", (SerializableFormat)FormatUtils.getAvailableFormatters().get(String.class));
        filterAttributes.put("age", (SerializableFormat)FormatUtils.getAvailableFormatters().get(Integer.class));
        filterAttributes.put("owner.name", (SerializableFormat)FormatUtils.getAvailableFormatters().get(String.class));
        FILTER_ATTRIBUTES = Collections.unmodifiableMap(filterAttributes);
    }
}

