/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.convert.CommonValues;
import com.cedarsoftware.util.convert.Convert;
import com.cedarsoftware.util.convert.DefaultConverterOptions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Converter {
    private static final com.cedarsoftware.util.convert.Converter instance = new com.cedarsoftware.util.convert.Converter(new DefaultConverterOptions());

    private Converter() {
    }

    public static <T> T convert(Object from, Class<T> toType) {
        return instance.convert(from, toType);
    }

    public static boolean isConversionSupportedFor(Class<?> source, Class<?> target) {
        return instance.isConversionSupportedFor(source, target);
    }

    public static boolean isSimpleTypeConversionSupported(Class<?> source, Class<?> target) {
        return instance.isSimpleTypeConversionSupported(source, target);
    }

    public static Map<Class<?>, Set<Class<?>>> allSupportedConversions() {
        return instance.allSupportedConversions();
    }

    public static Map<String, Set<String>> getSupportedConversions() {
        return instance.getSupportedConversions();
    }

    public static Convert<?> addConversion(Class<?> source, Class<?> target, Convert<?> conversionFunction) {
        return com.cedarsoftware.util.convert.Converter.addConversion(source, target, conversionFunction);
    }

    public static String convert2String(Object fromInstance) {
        if (fromInstance == null) {
            return "";
        }
        return instance.convert(fromInstance, String.class);
    }

    public static String convertToString(Object fromInstance) {
        return instance.convert(fromInstance, String.class);
    }

    public static BigDecimal convert2BigDecimal(Object fromInstance) {
        if (fromInstance == null) {
            return BigDecimal.ZERO;
        }
        return instance.convert(fromInstance, BigDecimal.class);
    }

    public static BigDecimal convertToBigDecimal(Object fromInstance) {
        return instance.convert(fromInstance, BigDecimal.class);
    }

    public static BigInteger convert2BigInteger(Object fromInstance) {
        if (fromInstance == null) {
            return BigInteger.ZERO;
        }
        return instance.convert(fromInstance, BigInteger.class);
    }

    public static BigInteger convertToBigInteger(Object fromInstance) {
        return instance.convert(fromInstance, BigInteger.class);
    }

    public static Date convertToSqlDate(Object fromInstance) {
        return instance.convert(fromInstance, Date.class);
    }

    public static Timestamp convertToTimestamp(Object fromInstance) {
        return instance.convert(fromInstance, Timestamp.class);
    }

    public static java.util.Date convertToDate(Object fromInstance) {
        return instance.convert(fromInstance, java.util.Date.class);
    }

    public static LocalDate convertToLocalDate(Object fromInstance) {
        return instance.convert(fromInstance, LocalDate.class);
    }

    public static LocalDateTime convertToLocalDateTime(Object fromInstance) {
        return instance.convert(fromInstance, LocalDateTime.class);
    }

    public static ZonedDateTime convertToZonedDateTime(Object fromInstance) {
        return instance.convert(fromInstance, ZonedDateTime.class);
    }

    public static Calendar convertToCalendar(Object fromInstance) {
        return Converter.convert(fromInstance, Calendar.class);
    }

    public static char convert2char(Object fromInstance) {
        if (fromInstance == null) {
            return '\u0000';
        }
        return instance.convert(fromInstance, Character.TYPE).charValue();
    }

    public static Character convertToCharacter(Object fromInstance) {
        return instance.convert(fromInstance, Character.class);
    }

    public static byte convert2byte(Object fromInstance) {
        if (fromInstance == null) {
            return 0;
        }
        return instance.convert(fromInstance, Byte.TYPE);
    }

    public static Byte convertToByte(Object fromInstance) {
        return instance.convert(fromInstance, Byte.class);
    }

    public static short convert2short(Object fromInstance) {
        if (fromInstance == null) {
            return 0;
        }
        return instance.convert(fromInstance, Short.TYPE);
    }

    public static Short convertToShort(Object fromInstance) {
        return instance.convert(fromInstance, Short.class);
    }

    public static int convert2int(Object fromInstance) {
        if (fromInstance == null) {
            return 0;
        }
        return instance.convert(fromInstance, Integer.TYPE);
    }

    public static Integer convertToInteger(Object fromInstance) {
        return instance.convert(fromInstance, Integer.class);
    }

    public static long convert2long(Object fromInstance) {
        if (fromInstance == null) {
            return CommonValues.LONG_ZERO;
        }
        return instance.convert(fromInstance, Long.TYPE);
    }

    public static Long convertToLong(Object fromInstance) {
        return instance.convert(fromInstance, Long.class);
    }

    public static float convert2float(Object fromInstance) {
        if (fromInstance == null) {
            return CommonValues.FLOAT_ZERO.floatValue();
        }
        return instance.convert(fromInstance, Float.TYPE).floatValue();
    }

    public static Float convertToFloat(Object fromInstance) {
        return instance.convert(fromInstance, Float.class);
    }

    public static double convert2double(Object fromInstance) {
        if (fromInstance == null) {
            return CommonValues.DOUBLE_ZERO;
        }
        return instance.convert(fromInstance, Double.TYPE);
    }

    public static Double convertToDouble(Object fromInstance) {
        return instance.convert(fromInstance, Double.class);
    }

    public static boolean convert2boolean(Object fromInstance) {
        if (fromInstance == null) {
            return false;
        }
        return instance.convert(fromInstance, Boolean.TYPE);
    }

    public static Boolean convertToBoolean(Object fromInstance) {
        return instance.convert(fromInstance, Boolean.class);
    }

    public static AtomicInteger convert2AtomicInteger(Object fromInstance) {
        if (fromInstance == null) {
            return new AtomicInteger(0);
        }
        return instance.convert(fromInstance, AtomicInteger.class);
    }

    public static AtomicInteger convertToAtomicInteger(Object fromInstance) {
        return instance.convert(fromInstance, AtomicInteger.class);
    }

    public static AtomicLong convert2AtomicLong(Object fromInstance) {
        if (fromInstance == null) {
            return new AtomicLong(0L);
        }
        return instance.convert(fromInstance, AtomicLong.class);
    }

    public static AtomicLong convertToAtomicLong(Object fromInstance) {
        return instance.convert(fromInstance, AtomicLong.class);
    }

    public static AtomicBoolean convert2AtomicBoolean(Object fromInstance) {
        if (fromInstance == null) {
            return new AtomicBoolean(false);
        }
        return instance.convert(fromInstance, AtomicBoolean.class);
    }

    public static AtomicBoolean convertToAtomicBoolean(Object fromInstance) {
        return instance.convert(fromInstance, AtomicBoolean.class);
    }

    @Deprecated
    public static long localDateToMillis(LocalDate localDate) {
        return instance.convert(localDate, Long.TYPE);
    }

    @Deprecated
    public static long localDateTimeToMillis(LocalDateTime localDateTime) {
        return instance.convert(localDateTime, Long.TYPE);
    }

    @Deprecated
    public static long zonedDateTimeToMillis(ZonedDateTime zonedDateTime) {
        return instance.convert(zonedDateTime, Long.TYPE);
    }
}

