/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ClassValueMap<V>
extends AbstractMap<Class<?>, V>
implements ConcurrentMap<Class<?>, V> {
    private static final Object NO_VALUE = new Object();
    private final ConcurrentMap<Class<?>, V> backingMap = new ConcurrentHashMapNullSafe();
    private final AtomicReference<V> nullKeyValue = new AtomicReference();
    private final ClassValue<Object> cache = new ClassValue<Object>(){

        @Override
        protected Object computeValue(Class<?> key) {
            Object value = ClassValueMap.this.backingMap.get(key);
            return value != null || ClassValueMap.this.backingMap.containsKey(key) ? value : NO_VALUE;
        }
    };

    public ClassValueMap() {
    }

    public ClassValueMap(Map<? extends Class<?>, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException("Map cannot be null");
        }
        this.putAll(map);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.nullKeyValue.get();
        }
        if (!(key instanceof Class)) {
            return null;
        }
        Class clazz = (Class)key;
        Object value = this.cache.get(clazz);
        return (V)(value == NO_VALUE ? null : value);
    }

    @Override
    public V put(Class<?> key, V value) {
        if (key == null) {
            return this.nullKeyValue.getAndSet(value);
        }
        V old = this.backingMap.put(key, value);
        this.cache.remove(key);
        return old;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return this.nullKeyValue.getAndSet(null);
        }
        if (!(key instanceof Class)) {
            return null;
        }
        Class clazz = (Class)key;
        Object old = this.backingMap.remove(clazz);
        this.cache.remove(clazz);
        return old;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.nullKeyValue.get() != null;
        }
        if (!(key instanceof Class)) {
            return false;
        }
        Class clazz = (Class)key;
        return this.cache.get(clazz) != NO_VALUE;
    }

    @Override
    public void clear() {
        HashSet keysToInvalidate = new HashSet(this.backingMap.keySet());
        this.backingMap.clear();
        this.nullKeyValue.set(null);
        for (Class key : keysToInvalidate) {
            this.cache.remove(key);
        }
    }

    @Override
    public int size() {
        return this.backingMap.size() + (this.nullKeyValue.get() != null ? 1 : 0);
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        return new AbstractSet<Map.Entry<Class<?>, V>>(){

            @Override
            public Iterator<Map.Entry<Class<?>, V>> iterator() {
                final Iterator backingIterator = ClassValueMap.this.backingMap.entrySet().iterator();
                final AbstractMap.SimpleImmutableEntry nullEntry = ClassValueMap.this.nullKeyValue.get() != null ? new AbstractMap.SimpleImmutableEntry(null, ClassValueMap.this.nullKeyValue.get()) : null;
                return new Iterator<Map.Entry<Class<?>, V>>(){
                    private boolean nullEntryReturned;
                    {
                        this.nullEntryReturned = nullEntry == null;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.nullEntryReturned || backingIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<Class<?>, V> next() {
                        if (!this.nullEntryReturned) {
                            this.nullEntryReturned = true;
                            return nullEntry;
                        }
                        return (Map.Entry)backingIterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal not supported via iterator.");
                    }
                };
            }

            @Override
            public int size() {
                return ClassValueMap.this.size();
            }
        };
    }

    @Override
    public V putIfAbsent(Class<?> key, V value) {
        if (key == null) {
            return this.nullKeyValue.compareAndSet(null, value) ? null : (V)this.nullKeyValue.get();
        }
        V prev = this.backingMap.putIfAbsent(key, value);
        this.cache.remove(key);
        return prev;
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            return this.nullKeyValue.compareAndSet(value, null);
        }
        if (!(key instanceof Class)) {
            return false;
        }
        boolean removed = this.backingMap.remove(key, value);
        this.cache.remove((Class)key);
        return removed;
    }

    @Override
    public boolean replace(Class<?> key, V oldValue, V newValue) {
        if (key == null) {
            return this.nullKeyValue.compareAndSet(oldValue, newValue);
        }
        boolean replaced = this.backingMap.replace(key, oldValue, newValue);
        this.cache.remove(key);
        return replaced;
    }

    @Override
    public V replace(Class<?> key, V value) {
        if (key == null) {
            V prev = this.nullKeyValue.get();
            this.nullKeyValue.set(value);
            return prev;
        }
        V replaced = this.backingMap.replace(key, value);
        this.cache.remove(key);
        return replaced;
    }

    @Override
    public Collection<V> values() {
        HashSet vals = new HashSet(this.backingMap.values());
        if (this.nullKeyValue.get() != null) {
            vals.add(this.nullKeyValue.get());
        }
        return vals;
    }

    public Map<Class<?>, V> unmodifiableView() {
        final ClassValueMap thisMap = this;
        return new AbstractMap<Class<?>, V>(){

            @Override
            public Set<Map.Entry<Class<?>, V>> entrySet() {
                return Collections.unmodifiableSet(thisMap.entrySet());
            }

            @Override
            public V get(Object key) {
                return thisMap.get(key);
            }

            @Override
            public boolean containsKey(Object key) {
                return thisMap.containsKey(key);
            }

            @Override
            public Set<Class<?>> keySet() {
                return Collections.unmodifiableSet(thisMap.keySet());
            }

            @Override
            public Collection<V> values() {
                return Collections.unmodifiableCollection(thisMap.values());
            }

            @Override
            public int size() {
                return thisMap.size();
            }

            @Override
            public V put(Class<?> key, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends Class<?>, ? extends V> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

