/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;

final class FileConversions {
    private FileConversions() {
    }

    static String toString(Object from, Converter converter) {
        File file = (File)from;
        return file.getPath();
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        File file = (File)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("file", file.getPath());
        return target;
    }

    static URI toURI(Object from, Converter converter) {
        File file = (File)from;
        return file.toURI();
    }

    static URL toURL(Object from, Converter converter) {
        File file = (File)from;
        try {
            return file.toURI().toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert File to URL, input File: " + file, e);
        }
    }

    static Path toPath(Object from, Converter converter) {
        File file = (File)from;
        return file.toPath();
    }

    static char[] toCharArray(Object from, Converter converter) {
        File file = (File)from;
        return file.getPath().toCharArray();
    }

    static byte[] toByteArray(Object from, Converter converter) {
        File file = (File)from;
        return file.getPath().getBytes(StandardCharsets.UTF_8);
    }
}

