/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class ThrowableFactory
implements JsonReader.ClassFactory {
    private static final String DETAIL_MESSAGE = "detailMessage";
    private static final String CAUSE = "cause";
    private static final String STACK_TRACE = "stackTrace";

    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        Object[] stackTrace;
        ArrayList<Object> arguments = new ArrayList<Object>();
        String message = (String)jObj.get(DETAIL_MESSAGE);
        message = message == null ? "" : message;
        arguments.add(message);
        JsonObject jsonCause = (JsonObject)jObj.get(CAUSE);
        Class causeType = jsonCause == null ? Throwable.class : (Class)jsonCause.getType();
        causeType = causeType == null ? Throwable.class : causeType;
        Throwable cause = (Throwable)resolver.toJavaObjects(jsonCause, causeType);
        if (cause != null) {
            arguments.add(cause);
        }
        this.gatherRemainingValues(resolver, jObj, arguments, CollectionUtilities.setOf((Object[])new String[]{DETAIL_MESSAGE, CAUSE, STACK_TRACE}));
        Throwable t = (Throwable)ClassUtilities.newInstance((Converter)resolver.getConverter(), c, arguments);
        if (t.getCause() == null && cause != null) {
            t.initCause(cause);
        }
        if ((stackTrace = (Object[])jObj.get(STACK_TRACE)) != null) {
            StackTraceElement[] elements = new StackTraceElement[stackTrace.length];
            for (int i = 0; i < stackTrace.length; ++i) {
                JsonObject stackTraceMap = (JsonObject)stackTrace[i];
                elements[i] = stackTraceMap == null ? null : (StackTraceElement)resolver.toJavaObjects(stackTraceMap, (Type)((Object)StackTraceElement.class));
            }
            t.setStackTrace(elements);
        }
        return t;
    }
}

