/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;

public class ThreadUtil {
    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        return tg;
    }

    public static Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = ThreadUtil.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    public static Thread getThread(long id) {
        Thread[] threads;
        for (Thread thread : threads = ThreadUtil.getAllThreads()) {
            if (thread.getId() != id) continue;
            return thread;
        }
        return null;
    }

    public static Thread[] getAllThreadsMatching(String regex) {
        if (regex == null) {
            throw new NullPointerException("Null thread name regex");
        }
        Thread[] threads = ThreadUtil.getAllThreads();
        ArrayList<Thread> matchingThreads = new ArrayList<Thread>();
        for (Thread thread : threads) {
            if (!thread.getName().matches(regex)) continue;
            matchingThreads.add(thread);
        }
        return matchingThreads.toArray(new Thread[0]);
    }
}

