/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.HexUtil;
import java.util.Arrays;

public final class HexString {
    public static final HexString NULL = new HexString(new byte[0], "");
    private final String hex;
    private final byte[] bytes;

    public static HexString valueOf(String hex) {
        return hex == null || hex.equals("") ? NULL : HexString.createHexString(hex);
    }

    public static HexString valueOf(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? NULL : HexString.createHexString(bytes);
    }

    private static HexString createHexString(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("hex string argument cannot be null; use HexString.NULL instead");
        }
        if (hex.equals("")) {
            throw new IllegalArgumentException("hex string argument cannot be empty; use HexString.NULL instead");
        }
        byte[] bytes = HexUtil.toByteArray(hex);
        return new HexString(bytes, hex.toUpperCase());
    }

    private static HexString createHexString(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes argument cannot be null; use HexString.NULL instead");
        }
        if (bytes.length == 0) {
            throw new IllegalArgumentException("bytes argument cannot be zero length; use HexString.NULL instead");
        }
        byte[] copyOfbytes = HexString.copyByteArray(bytes);
        String hex = HexUtil.toHexString(copyOfbytes).toUpperCase();
        return new HexString(copyOfbytes, hex);
    }

    private static byte[] copyByteArray(byte[] bytes) {
        return Arrays.copyOf(bytes, bytes.length);
    }

    private HexString(byte[] bytes, String hex) {
        this.bytes = bytes;
        this.hex = hex;
    }

    public String asString() {
        return this.hex;
    }

    public byte[] asBytes() {
        return HexString.copyByteArray(this.bytes);
    }

    public String toString() {
        return "0x" + this.hex;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof HexString) {
            HexString hexString = (HexString)other;
            return this.hex.equals(hexString.hex);
        }
        return false;
    }

    public int hashCode() {
        return this.hex.hashCode();
    }
}

