/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.client.ClientSettings;
import com.databend.client.DatabendClient;
import com.databend.client.DatabendSession;
import com.databend.client.JsonCodec;
import com.databend.client.JsonResponse;
import com.databend.client.PaginationOptions;
import com.databend.client.QueryRequest;
import com.databend.client.QueryResults;
import com.databend.client.errors.CloudErrors;
import com.google.shaded.common.base.MoreObjects;
import java.io.IOException;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

@ThreadSafe
public class DatabendClientV1
implements DatabendClient {
    private static final String USER_AGENT_VALUE = DatabendClientV1.class.getSimpleName() + "/" + MoreObjects.firstNonNull(DatabendClientV1.class.getPackage().getImplementationVersion(), "jvm-unknown");
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private static final String QUERY_PATH = "/v1/query";
    private static final long MAX_MATERIALIZED_JSON_RESPONSE_SIZE = 131072L;
    private final OkHttpClient httpClient;
    private final String query;
    private final String host;
    private final int maxRetryAttempts;
    private final PaginationOptions paginationOptions;
    private final Integer requestTimeoutSecs;
    private final Map<String, String> additonalHeaders;
    private final AtomicReference<DatabendSession> databendSession;
    private final AtomicReference<QueryResults> currentResults = new AtomicReference();

    public DatabendClientV1(OkHttpClient httpClient, String sql, ClientSettings settings2) {
        Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(sql, "sql is null");
        Objects.requireNonNull(settings2, "settings is null");
        Objects.requireNonNull(settings2.getHost(), "settings.host is null");
        this.httpClient = httpClient;
        this.query = sql;
        this.host = settings2.getHost();
        this.paginationOptions = settings2.getPaginationOptions();
        this.requestTimeoutSecs = settings2.getQueryTimeoutSecs();
        this.additonalHeaders = settings2.getAdditionalHeaders();
        this.maxRetryAttempts = settings2.getRetryAttempts();
        this.databendSession = new AtomicReference<DatabendSession>(settings2.getSession());
        Request request = this.buildQueryRequest(this.query, settings2);
        boolean completed = this.execute(request);
        if (!completed) {
            throw new RuntimeException("Query failed to complete");
        }
    }

    private Request.Builder prepareRequst(HttpUrl url) {
        Request.Builder builder = new Request.Builder().url(url).header("User-Agent", USER_AGENT_VALUE).header("Accept", "application/json").header("Content-Type", "application/json");
        if (this.getAdditionalHeaders() != null) {
            this.getAdditionalHeaders().forEach(builder::addHeader);
        }
        return builder;
    }

    private Request buildQueryRequest(String query, ClientSettings settings2) {
        HttpUrl url = HttpUrl.get(settings2.getHost());
        if (url == null) {
            throw new IllegalArgumentException("Invalid host: " + settings2.getHost());
        }
        QueryRequest req = QueryRequest.builder().setSession(settings2.getSession()).setStageAttachment(settings2.getStageAttachment()).setPaginationOptions(settings2.getPaginationOptions()).setSql(query).build();
        String reqString = req.toString();
        if (reqString == null || reqString.isEmpty()) {
            throw new IllegalArgumentException("Invalid request: " + req);
        }
        url = url.newBuilder().encodedPath(QUERY_PATH).build();
        Request.Builder builder = this.prepareRequst(url);
        return builder.post(RequestBody.create(MEDIA_TYPE_JSON, reqString)).build();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(Request request, OptionalLong materializedJsonSizeLimit) {
        JsonResponse<QueryResults> response;
        block13: {
            CloudErrors errors;
            Objects.requireNonNull(request, "request is null");
            long start = System.nanoTime();
            long attempts = 0L;
            RuntimeException cause = null;
            while (true) {
                if (attempts > 0L) {
                    Duration sinceStart = Duration.ofNanos(System.nanoTime() - start);
                    if (sinceStart.compareTo(Duration.ofSeconds(this.requestTimeoutSecs.intValue())) > 0) {
                        throw new RuntimeException(String.format("Error fetching next (attempts: %s, duration: %s)", attempts, sinceStart.getSeconds()), cause);
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(attempts * 100L);
                    }
                    catch (InterruptedException e) {
                        try {
                            this.close();
                        }
                        finally {
                            Thread.currentThread().interrupt();
                        }
                        throw new RuntimeException("StatementClient thread was interrupted");
                    }
                }
                ++attempts;
                try {
                    response = JsonResponse.execute(QUERY_RESULTS_CODEC, this.httpClient, request, materializedJsonSizeLimit);
                }
                catch (RuntimeException e) {
                    cause = e;
                    continue;
                }
                if (response.getStatusCode() == 200 && response.hasValue()) {
                    this.processResponse(response.getHeaders(), response.getValue());
                    return true;
                }
                if (!response.getResponseBody().isPresent() || (errors = CloudErrors.tryParse(response.getResponseBody().get())) == null) break block13;
                if (!errors.tryGetErrorKind().canRetry()) break;
            }
            throw new RuntimeException(errors.toString());
        }
        if (response.getStatusCode() != 520) {
            throw new RuntimeException("Query failed: " + response.getResponseBody());
        }
        return false;
    }

    @Override
    public boolean execute(Request request) {
        return this.executeInternal(request, OptionalLong.empty());
    }

    private void processResponse(Headers headers2, QueryResults results) {
        if (results.getSession() != null) {
            this.databendSession.set(results.getSession());
        }
        this.currentResults.set(results);
    }

    @Override
    public boolean next() {
        Objects.requireNonNull(this.host, "host is null");
        Objects.requireNonNull(this.currentResults.get(), "currentResults is null");
        if (this.currentResults.get().getNextUri() == null) {
            return false;
        }
        String nextUriPath = this.currentResults.get().getNextUri().toString();
        HttpUrl url = HttpUrl.get(this.host);
        url = url.newBuilder().encodedPath(nextUriPath).build();
        Request.Builder builder = this.prepareRequst(url);
        Request request = builder.get().build();
        return this.executeInternal(request, OptionalLong.of(131072L));
    }

    @Override
    public boolean isRunning() {
        QueryResults results = this.currentResults.get();
        if (results == null) {
            return false;
        }
        if (results.getState().toLowerCase(Locale.US).equals("failed") || results.getState().toLowerCase(Locale.US).equals("finished")) {
            return false;
        }
        return results.getNextUri() != null;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additonalHeaders;
    }

    @Override
    public QueryResults getResults() {
        return this.currentResults.get();
    }

    @Override
    public DatabendSession getSession() {
        return this.databendSession.get();
    }

    @Override
    public void close() {
        this.killQuery();
    }

    private void killQuery() {
        QueryResults q = this.currentResults.get();
        if (q == null) {
            return;
        }
        if (q.getKillUri() == null) {
            return;
        }
        String killUriPath = q.getKillUri().toString();
        HttpUrl url = HttpUrl.get(this.host);
        url = url.newBuilder().encodedPath(killUriPath).build();
        Request r = this.prepareRequst(url).get().build();
        try {
            this.httpClient.newCall(r).execute().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

