/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.client.DatabendSession;
import com.databend.client.PaginationOptions;
import com.databend.client.StageAttachment;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;

public class QueryRequest {
    private final String sql;
    private final String sessionId;
    private final PaginationOptions paginationOptions;
    private final DatabendSession session;
    private final StageAttachment stageAttachment;

    @JsonCreator
    public QueryRequest(@JsonProperty(value="sql") String sql, @JsonProperty(value="session_id") String sessionId, @JsonProperty(value="pagination") PaginationOptions paginationOptions, @JsonProperty(value="session") DatabendSession session, @JsonProperty(value="stage_attachment") StageAttachment stageAttachment) {
        this.sql = sql;
        this.sessionId = sessionId;
        this.paginationOptions = paginationOptions;
        this.session = session;
        this.stageAttachment = stageAttachment;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="sql")
    public String getSql() {
        return this.sql;
    }

    @JsonProperty(value="session_id")
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="pagination")
    public PaginationOptions getPaginationOptions() {
        return this.paginationOptions;
    }

    @JsonProperty(value="session")
    public DatabendSession getSession() {
        return this.session;
    }

    @JsonProperty(value="stage_attachment")
    public StageAttachment getStageAttachment() {
        return this.stageAttachment;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Builder {
        private String sql;
        private String sessionId;
        private PaginationOptions paginationOptions;
        private DatabendSession session;
        private StageAttachment stageAttachment;

        public Builder setSql(String sql) {
            this.sql = sql;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder setPaginationOptions(PaginationOptions paginationOptions) {
            this.paginationOptions = paginationOptions;
            return this;
        }

        public Builder setSession(DatabendSession session) {
            this.session = session;
            return this;
        }

        public Builder setStageAttachment(StageAttachment stageAttachment) {
            this.stageAttachment = stageAttachment;
            return this;
        }

        public QueryRequest build() {
            return new QueryRequest(this.sql, this.sessionId, this.paginationOptions, this.session, this.stageAttachment);
        }
    }
}

