/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.errors;

import com.google.shaded.common.base.MoreObjects;

public enum CloudErrorKinds {
    TENANT_NOT_FOUND("TenantNotFound", "Tenant not found, please check your tenant id", false),
    TENANT_BOOTSTRAP_FAILED("TenantBootstrapFailed", "tenant bootstrap failed", false),
    WAREHOUSE_NOT_FOUND("WarehouseNotFound", "warehouse not found", false),
    BAD_WAREHOUSE("BadWarehouse", "bad warehouse", false),
    WAREHOUSE_ALREADY_EXISTS("WarehouseAlreadyExists", "warehouse already exists", false),
    EMPTY_REQUEST("EmptyRequest", "empty request", false),
    BAD_REQUEST("BadRequest", "bad request", false),
    REQUIRE_TENANT_HEADER("TenantHeaderRequired", "X-DATABEND-TENANT is required", false),
    REQUIRE_PIPE_NAME("PipeNameRequired", "pipe name is required", false),
    REQUIRE_WAREHOUSE_HEADER("WarehouseHeaderRequired", "X-DATABENDCLOUD-WAREHOUSE is required", false),
    JWT_VERIFICATION_FAILED("JWTVerificationFailed", "JWT Verification Failed", false),
    PASSWORD_AUTH_FAILED("PasswordAuthFailed", "Please check your username and password", false),
    FORBIDDEN_ACCESS_USER("ForbiddenAccessUser", "Permission denied", false),
    ILLEGAL_HOST_NAME("IllegalHostName", "HostName is illegal", false),
    BAD_GATEWAY("BadGateway", "bad gateway", false),
    GATEWAY_TIMEOUT("GatewayTimeout", "gateway timeout", false),
    PROVISION_WAREHOUSE_TIMEOUT("ProvisionWarehouseTimeout", "provision warehouse timeout", true),
    UNEXPECTED("Unexpected", "unexpected", false),
    NOT_IMPLEMENTED("NotImplemented", "not implemented", false),
    HEALTH_CHECK_FAILED("HealthCheckFailed", "health check failed", false),
    BAD_TENANT("BadTenant", "bad tenant", false);

    private final String kind;
    private final String description;
    private final boolean canRetry;

    private CloudErrorKinds(String kind, String description, boolean canRetry) {
        this.kind = kind;
        this.description = description;
        this.canRetry = canRetry;
    }

    public static CloudErrorKinds tryGetErrorKind(String kind) {
        for (CloudErrorKinds errorKind : CloudErrorKinds.values()) {
            if (!errorKind.getKind().equalsIgnoreCase(kind)) continue;
            return errorKind;
        }
        return UNEXPECTED;
    }

    public String getKind() {
        return this.kind;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean canRetry() {
        return this.canRetry;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("kind", this.kind).add("description", this.description).add("canRetry", this.canRetry).toString();
    }
}

